/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.opacbluemapintegration;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public enum ChunkPosDirection {
    LEFT(-1, 0),
    FORWARD(0, 1),
    RIGHT(1, 0),
    BACKWARD(0, -1);

    public final int x;
    public final int z;
    public final ChunkPos value;

    private ChunkPosDirection(int x, int z) {
        this.x = x;
        this.z = z;
        this.value = new ChunkPos(x, z);
    }

    public ChunkPosDirection getLeft() {
        return this.rotate(-1);
    }

    public ChunkPosDirection getRight() {
        return this.rotate(1);
    }

    public ChunkPosDirection getOpposite() {
        return this.rotate(2);
    }

    public ChunkPosDirection rotate(int clockwiseDistance) {
        return ChunkPosDirection.values()[this.ordinal() + clockwiseDistance & 3];
    }

    public ChunkPos add(ChunkPos pos) {
        return new ChunkPos(pos.f_45578_ + this.x, pos.f_45579_ + this.z);
    }

    public int getEdge(ChunkPos pos) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LEFT -> pos.m_45604_();
            case FORWARD -> pos.m_45609_() + 1;
            case RIGHT -> pos.m_45608_() + 1;
            case BACKWARD -> pos.m_45605_();
        };
    }

    public static BlockPos getCorner(ChunkPos pos, ChunkPosDirection a, ChunkPosDirection b) {
        if (a == b || a.getOpposite() == b) {
            throw new IllegalArgumentException("Corner can't be accessed with opposite directions");
        }
        return a.x != 0 ? new BlockPos(a.getEdge(pos), 0, b.getEdge(pos)) : new BlockPos(b.getEdge(pos), 0, a.getEdge(pos));
    }
}

