/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.opacbluemapintegration;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import io.github.gaming32.opacbluemapintegration.ChunkPosDirection;
import io.github.gaming32.opacbluemapintegration.OpacBluemapConfig;
import io.github.gaming32.opacbluemapintegration.ShapeHolder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import xaero.pac.common.claims.player.api.IPlayerClaimPosListAPI;
import xaero.pac.common.claims.player.api.IPlayerDimensionClaimsAPI;
import xaero.pac.common.server.api.OpenPACServerAPI;

@Mod(value="opac_bluemap_integration")
public final class OpacBluemapIntegration {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final String MARKER_SET_KEY = "opac-bluemap-integration";
    private static MinecraftServer minecraftServer;
    private static int updateIn;
    public static final String MOD_ID = "opac_bluemap_integration";

    public OpacBluemapIntegration() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)OpacBluemapConfig.serverSpec);
        BlueMapAPI.onEnable(OpacBluemapIntegration::updateClaims);
        MinecraftForge.EVENT_BUS.register(OpacBluemapModEvents.class);
    }

    public static void updateClaims(BlueMapAPI blueMap) {
        if (minecraftServer == null) {
            LOGGER.warn("updateClaims called with minecraftServer == null!");
            return;
        }
        LOGGER.info("Refreshing OpenPaC BlueMap markers");
        OpenPACServerAPI.get((MinecraftServer)minecraftServer).getServerClaimsManager().getPlayerInfoStream().forEach(playerClaimInfo -> {
            String idName;
            Object name = playerClaimInfo.getClaimsName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = playerClaimInfo.getPlayerUsername();
                idName = name;
                name = ((String)name).length() > 2 && ((String)name).charAt(0) == '\"' && ((String)name).charAt(((String)name).length() - 1) == '\"' ? ((String)name).substring(1, ((String)name).length() - 1) + " claim" : (String)name + "'s claim";
            } else {
                idName = name;
            }
            String displayName = name;
            playerClaimInfo.getStream().forEach(entry -> {
                BlueMapWorld world = blueMap.getWorld((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceLocation)entry.getKey()))).orElse(null);
                if (world == null) {
                    return;
                }
                List<ShapeHolder> shapes = OpacBluemapIntegration.createShapes(((IPlayerDimensionClaimsAPI)entry.getValue()).getStream().flatMap(IPlayerClaimPosListAPI::getStream).collect(Collectors.toSet()));
                world.getMaps().forEach(map -> {
                    Map markers = map.getMarkerSets().computeIfAbsent(MARKER_SET_KEY, k -> MarkerSet.builder().toggleable(Boolean.valueOf(true)).label("Open Parties and Claims").build()).getMarkers();
                    float minY = ((Double)OpacBluemapConfig.SERVER.markerMinY.get()).floatValue();
                    float maxY = ((Double)OpacBluemapConfig.SERVER.markerMaxY.get()).floatValue();
                    boolean flatPlane = Mth.m_14033_((float)minY, (float)maxY);
                    markers.keySet().removeIf(k -> k.startsWith(idName + "---"));
                    for (int i = 0; i < shapes.size(); ++i) {
                        ShapeHolder shape = (ShapeHolder)shapes.get(i);
                        markers.put(idName + "---" + i, flatPlane ? ((ShapeMarker.Builder)ShapeMarker.builder().label(displayName)).fillColor(new Color(playerClaimInfo.getClaimsColor(), 150)).lineColor(new Color(playerClaimInfo.getClaimsColor(), 255)).shape(shape.baseShape(), minY).holes(shape.holes()).depthTestEnabled(((Boolean)OpacBluemapConfig.SERVER.depthTest.get()).booleanValue()).build() : ((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(displayName)).fillColor(new Color(playerClaimInfo.getClaimsColor(), 150)).lineColor(new Color(playerClaimInfo.getClaimsColor(), 255)).shape(shape.baseShape(), minY, maxY).holes(shape.holes()).depthTestEnabled(((Boolean)OpacBluemapConfig.SERVER.depthTest.get()).booleanValue()).build());
                    }
                });
            });
        });
        LOGGER.info("Refreshed OpenPaC BlueMap markers");
        updateIn = (Integer)OpacBluemapConfig.SERVER.updateInterval.get();
    }

    public static List<ShapeHolder> createShapes(Set<ChunkPos> chunks) {
        return OpacBluemapIntegration.createChunkGroups(chunks).stream().map(ShapeHolder::create).toList();
    }

    public static List<Set<ChunkPos>> createChunkGroups(Set<ChunkPos> chunks) {
        ArrayList<Set<ChunkPos>> result = new ArrayList<Set<ChunkPos>>();
        HashSet<ChunkPos> visited = new HashSet<ChunkPos>();
        for (ChunkPos chunk : chunks) {
            if (visited.contains(chunk)) continue;
            Set<ChunkPos> neighbors = OpacBluemapIntegration.findNeighbors(chunk, chunks);
            result.add(neighbors);
            visited.addAll(neighbors);
        }
        return result;
    }

    public static Set<ChunkPos> findNeighbors(ChunkPos chunk, Set<ChunkPos> chunks) {
        if (!chunks.contains(chunk)) {
            throw new IllegalArgumentException("chunks must contain chunk to find neighbors!");
        }
        HashSet<ChunkPos> visited = new HashSet<ChunkPos>();
        ArrayDeque<ChunkPos> toVisit = new ArrayDeque<ChunkPos>();
        visited.add(chunk);
        toVisit.add(chunk);
        while (!toVisit.isEmpty()) {
            ChunkPos visiting = (ChunkPos)toVisit.remove();
            for (ChunkPosDirection dir : ChunkPosDirection.values()) {
                ChunkPos offsetPos = dir.add(visiting);
                if (!chunks.contains(offsetPos) || !visited.add(offsetPos)) continue;
                toVisit.add(offsetPos);
            }
        }
        return visited;
    }

    public static class OpacBluemapModEvents {
        @SubscribeEvent
        public static void serverStarted(ServerStartedEvent ev) {
            minecraftServer = ev.getServer();
        }

        @SubscribeEvent
        public static void serverStopping(ServerStoppingEvent ev) {
            minecraftServer = null;
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void serverTick(TickEvent.ServerTickEvent ev) {
            if (updateIn <= 0) {
                return;
            }
            if (--updateIn <= 0) {
                BlueMapAPI.getInstance().ifPresent(OpacBluemapIntegration::updateClaims);
            }
        }

        @SubscribeEvent
        public static void commandEvent(RegisterCommandsEvent ev) {
            ev.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-bluemap").requires(s -> s.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refresh-now").requires(s -> BlueMapAPI.getInstance().isPresent())).executes(ctx -> {
                BlueMapAPI api = BlueMapAPI.getInstance().orElse(null);
                if (api == null) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"BlueMap not loaded").m_130940_(ChatFormatting.RED));
                    return 0;
                }
                OpacBluemapIntegration.updateClaims(api);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"BlueMap OpenPaC claims refreshed").m_130940_(ChatFormatting.GREEN), true);
                return 1;
            }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refresh-in").executes(ctx -> {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"OpenPaC BlueMap will refresh in ").m_7220_((Component)Component.m_237113_((String)(updateIn / 20 + "s")).m_130940_(ChatFormatting.GREEN)), true);
                return 1;
            })).then(Commands.m_82129_((String)"time", (ArgumentType)TimeArgument.m_113037_()).executes(ctx -> {
                updateIn = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time");
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"OpenPaC BlueMap will refresh in ").m_7220_((Component)Component.m_237113_((String)(updateIn / 20 + "s")).m_130940_(ChatFormatting.GREEN)), true);
                return 1;
            })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refresh-every").executes(ctx -> {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"OpenPaC BlueMap auto refreshes every ").m_7220_((Component)Component.m_237113_((String)((Integer)OpacBluemapConfig.SERVER.updateInterval.get() / 20 + "s")).m_130940_(ChatFormatting.GREEN)), true);
                return 1;
            })).then(Commands.m_82129_((String)"interval", (ArgumentType)TimeArgument.m_113037_()).executes(ctx -> {
                int interval = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"interval");
                OpacBluemapConfig.SERVER.updateInterval.set((Object)interval);
                if (interval < updateIn) {
                    updateIn = interval;
                }
                OpacBluemapConfig.SERVER.updateInterval.save();
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"OpenPaC BlueMap will auto refresh every ").m_7220_((Component)Component.m_237113_((String)(interval / 20 + "s")).m_130940_(ChatFormatting.GREEN)), true);
                return 1;
            })))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
                if ((Integer)OpacBluemapConfig.SERVER.updateInterval.get() < updateIn) {
                    updateIn = (Integer)OpacBluemapConfig.SERVER.updateInterval.get();
                }
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Reloaded OpenPaC BlueMap config").m_130940_(ChatFormatting.GREEN), true);
                return 1;
            })));
        }
    }
}

