/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.opacbluemapintegration;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.math.Shape;
import io.github.gaming32.opacbluemapintegration.ChunkPosDirection;
import io.github.gaming32.opacbluemapintegration.OpacBluemapIntegration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public record ShapeHolder(Shape baseShape, Shape[] holes) {
    public static ShapeHolder create(Set<ChunkPos> chunks) {
        return new ShapeHolder(ShapeHolder.createBaseShape(chunks), (Shape[])OpacBluemapIntegration.createChunkGroups(ShapeHolder.cutoutChunks(chunks)).stream().map(ShapeHolder::createBaseShape).toArray(Shape[]::new));
    }

    private static Shape createBaseShape(Set<ChunkPos> chunks) {
        ChunkPos firstChunk = ShapeHolder.getBound(chunks, Math::min);
        while (!chunks.contains(firstChunk)) {
            firstChunk = ChunkPosDirection.RIGHT.add(firstChunk);
        }
        ArrayList<Vector2d> points = new ArrayList<Vector2d>();
        points.add(new Vector2d((float)firstChunk.m_45604_(), (float)firstChunk.m_45605_()));
        ChunkPos current = firstChunk;
        ChunkPosDirection direction = ChunkPosDirection.RIGHT;
        do {
            points.add(ShapeHolder.vector(ChunkPosDirection.getCorner(current, direction, direction.getRight())));
            ChunkPos next = direction.add(current);
            if (chunks.contains(next)) {
                ChunkPos right = direction.getRight().add(next);
                if (chunks.contains(right)) {
                    current = right;
                    direction = direction.getRight();
                    continue;
                }
                current = next;
                continue;
            }
            direction = direction.getLeft();
        } while (!current.equals((Object)firstChunk) || direction != ChunkPosDirection.RIGHT);
        return new Shape(ShapeHolder.simplifyPoints(points));
    }

    private static Set<ChunkPos> cutoutChunks(Set<ChunkPos> chunks) {
        ChunkPos minChunk = ShapeHolder.getBound(chunks, Math::min);
        ChunkPos maxChunk = ShapeHolder.getBound(chunks, Math::max);
        ArrayDeque<ChunkPos> toVisit = new ArrayDeque<ChunkPos>();
        for (int x = minChunk.f_45578_; x <= maxChunk.f_45578_; ++x) {
            for (int z = minChunk.f_45579_; z <= maxChunk.f_45579_; ++z) {
                ChunkPos chunk;
                if (x > minChunk.f_45578_ && x < maxChunk.f_45578_ && z > minChunk.f_45579_ && z < maxChunk.f_45579_ || chunks.contains(chunk = new ChunkPos(x, z))) continue;
                toVisit.add(chunk);
            }
        }
        HashSet<ChunkPos> outsideChunks = new HashSet<ChunkPos>(toVisit);
        while (!toVisit.isEmpty()) {
            ChunkPos chunk = (ChunkPos)toVisit.remove();
            for (ChunkPosDirection dir : ChunkPosDirection.values()) {
                ChunkPos offsetPos = dir.add(chunk);
                if (offsetPos.f_45578_ < minChunk.f_45578_ || offsetPos.f_45578_ > maxChunk.f_45578_ || offsetPos.f_45579_ < minChunk.f_45579_ || offsetPos.f_45579_ > maxChunk.f_45579_ || chunks.contains(offsetPos) || !outsideChunks.add(offsetPos)) continue;
                toVisit.add(offsetPos);
            }
        }
        return ChunkPos.m_45599_((ChunkPos)minChunk, (ChunkPos)maxChunk).filter(c -> !chunks.contains(c) && !outsideChunks.contains(c)).collect(Collectors.toSet());
    }

    private static Vector2d vector(BlockPos pos) {
        return new Vector2d((float)pos.m_123341_(), (float)pos.m_123343_());
    }

    private static List<Vector2d> simplifyPoints(List<Vector2d> points) {
        if (points.size() < 4) {
            return points;
        }
        ArrayList<Vector2d> result = new ArrayList<Vector2d>();
        result.add(points.get(0));
        for (int i = 1; i < points.size() - 1; ++i) {
            Vector2d last = points.get(i - 1);
            Vector2d point = points.get(i);
            Vector2d next = points.get(i + 1);
            if (point.sub(last).normalize().equals((Object)next.sub(point).normalize())) continue;
            result.add(point);
        }
        Vector2d lastPoint = points.get(points.size() - 1);
        if (!lastPoint.equals((Object)points.get(0))) {
            result.add(lastPoint);
        }
        return result;
    }

    private static ChunkPos getBound(Iterable<ChunkPos> chunks, IntSelector selector) {
        Iterator<ChunkPos> iterator = chunks.iterator();
        ChunkPos first = iterator.next();
        int x = first.f_45578_;
        int z = first.f_45579_;
        while (iterator.hasNext()) {
            ChunkPos pos = iterator.next();
            x = selector.select(x, pos.f_45578_);
            z = selector.select(z, pos.f_45579_);
        }
        return new ChunkPos(x, z);
    }

    @FunctionalInterface
    private static interface IntSelector {
        public int select(int var1, int var2);
    }
}

