/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.blocktuner;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class BlockTunerConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("blocktuner.properties");
    private static final Properties properties = new Properties();
    private static final String PLAY_MODE = "play-mode";
    private static final String KEY_TO_PIANO = "key-to-piano";
    private static final String MIDI_DEVICE = "midi-device";
    private static final String KEY_SIGNATURE = "key-signature";
    public static int keySignature = 0;
    public static boolean onBlockTunerServer = false;
    private static String midiDeviceName = "";
    private static boolean keyToPiano = false;
    private static boolean playMode = false;

    public static void save() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (OutputStream outputStream = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
            properties.store(outputStream, "BlockTuner Configuration File");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            BlockTunerConfig.save();
        }
        try (InputStream inputStream = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
            properties.load(inputStream);
            playMode = Boolean.parseBoolean(properties.getProperty(PLAY_MODE));
            keyToPiano = Boolean.parseBoolean(properties.getProperty(KEY_TO_PIANO));
            midiDeviceName = properties.getProperty(MIDI_DEVICE, "");
            try {
                keySignature = Integer.parseInt(properties.getProperty(KEY_SIGNATURE, "0"));
            }
            catch (NumberFormatException e) {
                keySignature = 0;
                properties.setProperty(KEY_SIGNATURE, String.valueOf(keySignature));
                BlockTunerConfig.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMidiDeviceName() {
        return midiDeviceName;
    }

    public static void setMidiDeviceName(String midiDeviceName) {
        BlockTunerConfig.midiDeviceName = midiDeviceName;
        properties.setProperty(MIDI_DEVICE, midiDeviceName);
    }

    public static boolean isPlayMode() {
        return playMode;
    }

    public static void togglePlayMode() {
        playMode = !playMode;
        properties.setProperty(PLAY_MODE, String.valueOf(playMode));
    }

    public static boolean isKeyToPiano() {
        return keyToPiano;
    }

    public static void toggleKeyToPiano() {
        keyToPiano = !keyToPiano;
        properties.setProperty(KEY_TO_PIANO, String.valueOf(keyToPiano));
    }

    public static int getKeySignature() {
        return keySignature;
    }

    public static void setKeySignature(int keySignature) {
        BlockTunerConfig.keySignature = keySignature >= -7 && keySignature <= 7 ? keySignature : 0;
        properties.setProperty(KEY_SIGNATURE, String.valueOf(BlockTunerConfig.keySignature));
    }

    public static void keyAddSharp() {
        keySignature = keySignature < 7 ? ++keySignature : -7;
        properties.setProperty(KEY_SIGNATURE, String.valueOf(keySignature));
    }

    public static void keyAddFlat() {
        keySignature = keySignature > -7 ? --keySignature : 7;
        properties.setProperty(KEY_SIGNATURE, String.valueOf(keySignature));
    }
}

