/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.blocktuner.display;

import io.github.lumine1909.blocktuner.BlockTuner;
import io.github.lumine1909.blocktuner.BlockTunerConfig;
import io.github.lumine1909.blocktuner.network.ServerBoundTuningPacket;
import io.github.lumine1909.blocktuner.util.InputUtil;
import io.github.lumine1909.blocktuner.util.MidiManager;
import io.github.lumine1909.blocktuner.util.NoteNames;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1268;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class TuningScreen
extends class_437 {
    protected static final class_2561 PLAY_MODE_TOGGLE_TOOLTIP = class_2561.method_43471((String)"settings.blocktuner.play_mode");
    protected static final class_2561 KEY_TO_PIANO_TOGGLE_TOOLTIP = class_2561.method_43471((String)"settings.blocktuner.key_to_piano");
    protected static final class_2561 EMPTY_MIDI_DEVICE = class_2561.method_43471((String)"midi_device.empty");
    protected static final class_2561 MIDI_DEVICE_REFRESH_TOOLTIP = class_2561.method_43471((String)"settings.blocktuner.refresh");
    static final class_2960 TEXTURE = class_2960.method_43902((String)"blocktuner", (String)"textures/gui/container/tune.png");
    private final class_2338 pos;
    private final PianoKeyWidget[] pianoKeys = new PianoKeyWidget[25];
    private final MidiManager midiManager;
    private final MidiReceiver receiver;
    protected int backgroundWidth = 256;
    protected int backgroundHeight = 112;
    protected int x;
    protected int y;
    private PianoKeyWidget pressedKey = null;
    private MidiDevice currentDevice;
    private class_2561 deviceName;
    private boolean deviceAvailable = true;
    private boolean configChanged = false;

    public TuningScreen(class_2561 title, class_2338 pos) {
        super(title);
        this.pos = pos;
        this.midiManager = MidiManager.getMidiManager();
        this.currentDevice = this.midiManager.getCurrentDevice();
        this.receiver = new MidiReceiver();
    }

    public static void sendTuningPacket(class_2338 pos, int note) {
        note = class_3532.method_15340((int)note, (int)0, (int)24);
        ClientPlayNetworking.send((class_8710)new ServerBoundTuningPacket(pos, note));
    }

    protected static int keyToNote(int scanCode) {
        return switch (scanCode) {
            case 3, 38 -> 7;
            case 4, 39 -> 9;
            case 6 -> 12;
            case 7 -> 14;
            case 8 -> 16;
            case 10 -> 19;
            case 11 -> 21;
            case 13 -> 24;
            case 16, 51 -> 6;
            case 17, 52 -> 8;
            case 18, 53 -> 10;
            case 19 -> 11;
            case 20 -> 13;
            case 21 -> 15;
            case 22 -> 17;
            case 23 -> 18;
            case 24 -> 20;
            case 25 -> 22;
            case 26 -> 23;
            case 34 -> 0;
            case 35 -> 2;
            case 36 -> 4;
            case 48 -> 1;
            case 49 -> 3;
            case 50 -> 5;
            default -> -1;
        };
    }

    protected void method_25426() {
        super.method_25426();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 16, this.y + 65, 1, 1));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 32, this.y + 65, 3, 1));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 48, this.y + 65, 5, 2));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 64, this.y + 65, 6, 0));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 80, this.y + 65, 8, 1));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 96, this.y + 65, 10, 2));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 112, this.y + 65, 11, 0));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 128, this.y + 65, 13, 1));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 144, this.y + 65, 15, 1));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 160, this.y + 65, 17, 2));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 176, this.y + 65, 18, 0));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 192, this.y + 65, 20, 1));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 208, this.y + 65, 22, 2));
        this.method_37063((class_364)new WhiteKeyWidget(this, this.x + 224, this.y + 65, 23, 0));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 8, this.y + 40, 0));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 24, this.y + 40, 2));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 40, this.y + 40, 4));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 72, this.y + 40, 7));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 88, this.y + 40, 9));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 120, this.y + 40, 12));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 136, this.y + 40, 14));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 152, this.y + 40, 16));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 184, this.y + 40, 19));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 200, this.y + 40, 21));
        this.method_37063((class_364)new BlackKeyWidget(this, this.x + 232, this.y + 40, 24));
        this.method_37063((class_364)new PlayModeToggle(this.x + 184, this.y + 8));
        this.method_37063((class_364)new KeyToPianoToggle(this.x + 200, this.y + 8));
        this.method_37063((class_364)new MidiSwitch(this.x + 216, this.y + 8));
        this.method_37063((class_364)new MidiDeviceRefreshButton(this.x + 232, this.y + 8));
        this.method_37060(new KeySignature(this.x + 112, this.y + 8));
        this.method_37063((class_364)new KeyAddSharpButton(this.x + 144, this.y + 8));
        this.method_37063((class_364)new KeyAddFlatButton(this.x + 144, this.y + 16));
        if (this.currentDevice != null && !this.currentDevice.isOpen()) {
            this.openCurrentDevice();
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void method_25393() {
        if (this.field_22787 == null || this.field_22787.field_1687 == null || this.field_22787.field_1687.method_8320(this.pos).method_26204() != class_2246.field_10179) {
            this.close();
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25420(graphics, mouseX, mouseY, delta);
        this.drawBackground(graphics, delta, mouseX, mouseY);
    }

    protected void drawBackground(class_332 graphics, float delta, int mouseX, int mouseY) {
        assert (this.field_22787 != null);
        int i = (this.field_22789 - this.backgroundWidth) / 2;
        int j = (this.field_22790 - this.backgroundHeight) / 2;
        graphics.method_25290(class_10799.field_56883, TEXTURE, i, j, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 256, 256);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25406(class_11909 event) {
        this.method_25398(false);
        if (this.pressedKey != null) {
            return this.pressedKey.method_25406(event);
        }
        return super.method_25406(event);
    }

    public boolean method_25404(class_11908 event) {
        if (BlockTunerConfig.isKeyToPiano() && event.comp_4795() != 256) {
            int note = TuningScreen.keyToNote(event.comp_4796());
            if (note >= 0 && note <= 24 && !this.pianoKeys[note].played) {
                this.pianoKeys[note].method_25348(InputUtil.DUMMY_EVENT, false);
            }
            return true;
        }
        if (event.comp_4795() == 69) {
            this.close();
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_16803(class_11908 event) {
        int note = TuningScreen.keyToNote(event.comp_4796());
        if (note >= 0 && note <= 24) {
            this.pianoKeys[note].method_25357(InputUtil.DUMMY_EVENT);
        }
        return super.method_16803(event);
    }

    public void close() {
        if (this.currentDevice != null && this.currentDevice.isOpen()) {
            this.currentDevice.close();
        }
        this.receiver.close();
        if (this.configChanged) {
            BlockTunerConfig.save();
        }
        super.method_25419();
    }

    protected void openCurrentDevice() {
        try {
            this.currentDevice.open();
            this.deviceAvailable = true;
            this.currentDevice.getTransmitter().setReceiver(this.receiver);
        }
        catch (MidiUnavailableException e) {
            this.deviceAvailable = false;
            BlockTuner.LOGGER.info("[BlockTuner] MIDI device \"" + this.currentDevice.getDeviceInfo().getName() + "\" is currently unavailable. Is it busy or unplugged?");
        }
    }

    abstract class PianoKeyWidget
    extends class_339 {
        private final int note;
        protected boolean played;

        protected PianoKeyWidget(int x, int y, int width, int height, int note) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.note = note;
            TuningScreen.this.pianoKeys[note] = this;
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            if (!this.field_22764) {
                return;
            }
            if (this.field_22762) {
                graphics.method_51438(TuningScreen.this.field_22793, (class_2561)class_2561.method_43470((String)NoteNames.get(this.note)), TuningScreen.this.x - 8, TuningScreen.this.y - 2);
            }
        }

        public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
            TuningScreen.this.pressedKey = this;
            this.played = true;
            if (TuningScreen.this.field_22787 != null && ((TuningScreen)TuningScreen.this).field_22787.field_1724 != null && TuningScreen.this.field_22787.method_1562() != null) {
                TuningScreen.sendTuningPacket(TuningScreen.this.pos, this.note);
                ((TuningScreen)TuningScreen.this).field_22787.field_1724.method_6104(class_1268.field_5808);
            }
            if (!BlockTunerConfig.isPlayMode()) {
                TuningScreen.this.close();
            }
        }

        public void method_25357(class_11909 mouseButtonEvent) {
            this.played = false;
            TuningScreen.this.pressedKey = null;
        }

        public boolean method_25402(class_11909 event, boolean bl) {
            boolean b;
            if (this.field_22763 && this.field_22764 && this.method_25351(event.comp_4800()) && (b = this.method_25405(event.comp_4798(), event.comp_4799()))) {
                this.method_25348(event, bl);
                return true;
            }
            return false;
        }

        public boolean method_25405(double d, double e) {
            return this.field_22763 && this.field_22764 && this.field_22762;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }

    class MidiReceiver
    implements Receiver {
        @Override
        public void send(MidiMessage msg, long timeStamp) {
            byte[] message = msg.getMessage();
            if (message.length == 3 && message[0] <= -97 && message[1] >= 54 && message[1] <= 78) {
                assert (TuningScreen.this.field_22787 != null);
                if (message[0] >= -112 && message[2] != 0) {
                    TuningScreen.this.field_22787.execute(() -> TuningScreen.this.pianoKeys[message[1] - 54].method_25348(InputUtil.DUMMY_EVENT, false));
                } else {
                    TuningScreen.this.field_22787.execute(() -> TuningScreen.this.pianoKeys[message[1] - 54].method_25357(InputUtil.DUMMY_EVENT));
                }
            }
        }

        @Override
        public void close() {
        }
    }

    class WhiteKeyWidget
    extends PianoKeyWidget {
        private final int keyShape;

        public WhiteKeyWidget(TuningScreen this$0, int x, int y, int note, int keyShape) {
            super(x, y, 16, 38, note);
            this.keyShape = keyShape;
        }

        @Override
        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            boolean mask = mouseX >= this.method_46426() + 8 - 8 * this.keyShape && mouseY >= this.method_46427() && mouseX < this.method_46426() + 24 - 8 * this.keyShape && mouseY < this.method_46427() + 13;
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
            this.field_22762 = this.field_22762 && !mask;
            int status = 0;
            if (this.played) {
                status = 1;
            } else if (this.method_49606()) {
                status = 2;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(16 * status + 48 * this.keyShape + 48), 112.0f, 16, 38, 256, 256);
        }

        @Override
        public boolean method_25405(double d, double e) {
            return this.field_22763 && this.field_22764 && this.field_22762;
        }
    }

    class BlackKeyWidget
    extends PianoKeyWidget {
        public BlackKeyWidget(TuningScreen this$0, int x, int y, int note) {
            super(x, y, 16, 38, note);
        }

        @Override
        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
            int status = 0;
            if (this.played) {
                status = 1;
            } else if (this.method_49606()) {
                status = 2;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(16 * status), 112.0f, 16, 38, 256, 256);
        }
    }

    class PlayModeToggle
    extends class_339 {
        public PlayModeToggle(int x, int y) {
            super(x, y, 16, 16, (class_2561)class_2561.method_43473());
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            int status = 0;
            if (BlockTunerConfig.isPlayMode()) {
                status = 2;
            }
            if (this.method_49606()) {
                ++status;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(192 + 16 * status), 112.0f, 16, 16, 256, 256);
            if (this.method_49606()) {
                graphics.method_51438(TuningScreen.this.field_22793, PLAY_MODE_TOGGLE_TOOLTIP, TuningScreen.this.x - 8, TuningScreen.this.y - 2);
            }
        }

        public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
            BlockTunerConfig.togglePlayMode();
            TuningScreen.this.configChanged = true;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }

    class KeyToPianoToggle
    extends class_339 {
        public KeyToPianoToggle(int x, int y) {
            super(x, y, 16, 16, (class_2561)class_2561.method_43473());
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            int status = 0;
            if (BlockTunerConfig.isKeyToPiano()) {
                status = 2;
            }
            if (this.method_49606()) {
                ++status;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(192 + 16 * status), 128.0f, 16, 16, 256, 256);
            if (this.method_49606()) {
                graphics.method_51438(TuningScreen.this.field_22793, KEY_TO_PIANO_TOGGLE_TOOLTIP, TuningScreen.this.x - 8, TuningScreen.this.y - 2);
            }
        }

        public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
            BlockTunerConfig.toggleKeyToPiano();
            TuningScreen.this.configChanged = true;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }

    class MidiSwitch
    extends class_339 {
        public MidiSwitch(int x, int y) {
            super(x, y, 16, 16, (class_2561)class_2561.method_43473());
            TuningScreen.this.deviceName = TuningScreen.this.currentDevice == null ? EMPTY_MIDI_DEVICE : class_2561.method_43470((String)TuningScreen.this.currentDevice.getDeviceInfo().getName());
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            int status = 0;
            if (TuningScreen.this.midiManager.getDeviceIndex() > 0) {
                status = 2;
            }
            if (this.method_49606()) {
                ++status;
            }
            if (!TuningScreen.this.deviceAvailable) {
                status += 4;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(192 + 16 * (status % 4)), (float)(144 + 16 * (status / 4)), 16, 16, 256, 256);
            if (this.method_49606()) {
                graphics.method_51438(TuningScreen.this.field_22793, (class_2561)class_2561.method_43469((String)"settings.blocktuner.midi_device", (Object[])new Object[]{TuningScreen.this.deviceName}), TuningScreen.this.x - 8, TuningScreen.this.y - 2);
            }
        }

        public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
            if (TuningScreen.this.currentDevice != null && TuningScreen.this.currentDevice.isOpen()) {
                TuningScreen.this.currentDevice.close();
            }
            TuningScreen.this.midiManager.loopDeviceIndex();
            TuningScreen.this.currentDevice = TuningScreen.this.midiManager.getCurrentDevice();
            if (TuningScreen.this.currentDevice != null) {
                BlockTunerConfig.setMidiDeviceName(TuningScreen.this.currentDevice.getDeviceInfo().getName());
                TuningScreen.this.deviceName = class_2561.method_43470((String)BlockTunerConfig.getMidiDeviceName());
                TuningScreen.this.openCurrentDevice();
            } else {
                BlockTunerConfig.setMidiDeviceName("");
                TuningScreen.this.deviceName = EMPTY_MIDI_DEVICE;
            }
            TuningScreen.this.configChanged = true;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }

    class MidiDeviceRefreshButton
    extends class_339 {
        public MidiDeviceRefreshButton(int x, int y) {
            super(x, y, 16, 16, (class_2561)class_2561.method_43473());
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            int status = 0;
            if (this.method_49606()) {
                ++status;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(192 + 16 * status), 176.0f, 16, 16, 256, 256);
            if (this.method_49606()) {
                graphics.method_51438(TuningScreen.this.field_22793, MIDI_DEVICE_REFRESH_TOOLTIP, TuningScreen.this.x - 8, TuningScreen.this.y - 2);
            }
        }

        public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
            TuningScreen.this.midiManager.refreshMidiDevice();
            if (TuningScreen.this.currentDevice != null) {
                TuningScreen.this.openCurrentDevice();
            }
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }

    static class KeySignature
    implements class_4068 {
        public int x;
        public int y;

        public KeySignature(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void method_25394(class_332 guiGraphics, int i, int j, float f) {
            int keySignature = BlockTunerConfig.getKeySignature();
            guiGraphics.method_25290(class_10799.field_56883, TEXTURE, this.x, this.y, (float)((keySignature + 8) % 8 * 32), (float)((keySignature + 8) / 8 * 16 + 224), 32, 16, 256, 256);
        }
    }

    class KeyAddSharpButton
    extends class_339 {
        public KeyAddSharpButton(int x, int y) {
            super(x, y, 8, 8, (class_2561)class_2561.method_43473());
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            int status = 0;
            if (this.method_49606()) {
                ++status;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(8 * status), 152.0f, 8, 8, 256, 256);
        }

        public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
            BlockTunerConfig.keyAddSharp();
            TuningScreen.this.configChanged = true;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }

    class KeyAddFlatButton
    extends class_339 {
        public KeyAddFlatButton(int x, int y) {
            super(x, y, 8, 8, (class_2561)class_2561.method_43473());
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            int status = 0;
            if (this.method_49606()) {
                ++status;
            }
            graphics.method_25290(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), (float)(8 * status + 16), 152.0f, 8, 8, 256, 256);
        }

        public void method_25348(class_11909 mouseButtonEvent, boolean bl) {
            BlockTunerConfig.keyAddFlat();
            TuningScreen.this.configChanged = true;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }
}

