/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.blocktuner.util;

import io.github.lumine1909.blocktuner.BlockTunerConfig;
import java.util.Objects;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import org.jetbrains.annotations.Nullable;

public class MidiManager {
    public static final Vector<MidiDevice> transmitters = new Vector(0, 1);
    private static final MidiManager midiManager = new MidiManager();
    static int deviceIndex = 0;

    private MidiManager() {
    }

    public static MidiManager getMidiManager() {
        return midiManager;
    }

    public int getDeviceIndex() {
        return deviceIndex;
    }

    public void loopDeviceIndex() {
        if (deviceIndex == 0) {
            this.refreshMidiDevice();
        }
        if (deviceIndex < transmitters.size() - 1) {
            ++deviceIndex;
        } else {
            deviceIndex = 0;
            BlockTunerConfig.setMidiDeviceName("");
        }
    }

    @Nullable
    public MidiDevice getCurrentDevice() {
        return transmitters.get(deviceIndex);
    }

    public void refreshMidiDevice() {
        MidiDevice.Info[] infos;
        transmitters.clear();
        transmitters.add(null);
        deviceIndex = 0;
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                if (device.getMaxTransmitters() == 0 || Objects.equals(info.getVendor(), "Oracle Corporation")) {
                    return;
                }
                transmitters.add(device);
                if (!info.getName().equals(BlockTunerConfig.getMidiDeviceName())) continue;
                deviceIndex = transmitters.size() - 1;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
    }
}

