/*
 * Decompiled with CFR 0.152.
 */
package gg.emopedia.cloudboard;

import gg.emopedia.cloudboard.ScoreboardCommand;
import gg.emopedia.cloudboard.ScoreboardManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Cloudboard
extends JavaPlugin
implements Listener {
    private ScoreboardManager scoreboardManager;
    private boolean placeholderAPIEnabled = false;

    public void onEnable() {
        this.saveDefaultConfig();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderAPIEnabled = true;
            this.getLogger().info("PlaceholderAPI found. Conditional scoreboards are enabled.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found! Placeholder-based conditions will be disabled.");
        }
        this.scoreboardManager = new ScoreboardManager(this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        String commandName = this.getConfig().getString("scoreboard.toggle-command", "sb");
        ScoreboardCommand commandExecutor = new ScoreboardCommand(this);
        if (this.getCommand(commandName) != null) {
            this.getCommand(commandName).setExecutor((CommandExecutor)commandExecutor);
        }
        if (this.getCommand("cloudboard") != null) {
            this.getCommand("cloudboard").setExecutor((CommandExecutor)commandExecutor);
        }
        this.getLogger().info("Cloudboard upgraded enabled (1.20+).");
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("Cloudboard upgraded disabled.");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.getConfig().getBoolean("scoreboard.enabled", true)) {
            this.scoreboardManager.handlePlayerJoin(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.scoreboardManager.handlePlayerQuit(event.getPlayer());
    }

    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }
}

