/*
 * Decompiled with CFR 0.152.
 */
package gg.emopedia.cloudboard;

import gg.emopedia.cloudboard.Cloudboard;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ScoreboardCommand
implements CommandExecutor {
    private final Cloudboard plugin;

    public ScoreboardCommand(Cloudboard plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("cloudboard.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload Cloudboard.");
                return true;
            }
            this.plugin.reloadConfig();
            this.plugin.getScoreboardManager().reloadProfiles();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Cloudboard configuration reloaded.");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getConfig().getBoolean("scoreboard.enabled", true)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The scoreboard feature is currently disabled on this server.");
            return true;
        }
        boolean newState = this.plugin.getScoreboardManager().toggleScoreboard(player);
        if (newState) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Scoreboard enabled.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Scoreboard hidden.");
        }
        return true;
    }
}

