/*
 * Decompiled with CFR 0.152.
 */
package gg.emopedia.cloudboard;

import gg.emopedia.cloudboard.Cloudboard;
import gg.emopedia.cloudboard.ScoreboardProfile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardManager {
    private final Cloudboard plugin;
    private final List<ScoreboardProfile> profiles = new ArrayList<ScoreboardProfile>();
    private final Map<UUID, Boolean> scoreboardVisible = new HashMap<UUID, Boolean>();
    private final Map<UUID, String> activeProfile = new HashMap<UUID, String>();
    private final boolean useNumbers;

    public ScoreboardManager(Cloudboard plugin) {
        this.plugin = plugin;
        this.useNumbers = plugin.getConfig().getBoolean("scoreboard.use-numbers", false);
        this.loadProfilesFromConfig();
        this.startUpdateTask();
    }

    public boolean toggleScoreboard(Player player) {
        UUID uuid = player.getUniqueId();
        boolean isVisible = this.scoreboardVisible.getOrDefault(uuid, !this.plugin.getConfig().getBoolean("scoreboard.hidden-by-default", false));
        if (isVisible) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard()));
            this.scoreboardVisible.put(uuid, false);
            this.activeProfile.remove(uuid);
        } else {
            this.scoreboardVisible.put(uuid, true);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateScoreboard(player));
        }
        return !isVisible;
    }

    public void reloadProfiles() {
        this.loadProfilesFromConfig();
    }

    private void loadProfilesFromConfig() {
        this.profiles.clear();
        if (!this.plugin.getConfig().isConfigurationSection("scoreboard.scoreboards")) {
            this.plugin.getLogger().warning("No 'scoreboard.scoreboards' section found in config.yml. Scoreboard feature is inactive.");
            return;
        }
        Set keys = this.plugin.getConfig().getConfigurationSection("scoreboard.scoreboards").getKeys(false);
        for (String key : keys) {
            String path = "scoreboard.scoreboards." + key + ".";
            String condition = this.plugin.getConfig().getString(path + "display-condition", "");
            String title = this.plugin.getConfig().getString(path + "title", "Cloudboard");
            List lines = this.plugin.getConfig().getStringList(path + "lines");
            ScoreboardProfile profile = new ScoreboardProfile(key, condition == null ? "" : condition.trim(), title == null ? "" : title, lines == null ? new ArrayList() : lines);
            this.profiles.add(profile);
            this.plugin.getLogger().info("Loaded scoreboard profile: " + key + " (condition='" + condition + "')");
        }
    }

    public ScoreboardProfile findMatchingProfile(Player player) {
        for (ScoreboardProfile profile : this.profiles) {
            if (!this.checkCondition(player, profile.getDisplayCondition())) continue;
            return profile;
        }
        return null;
    }

    private boolean checkCondition(Player player, String conditionString) {
        String[] parts;
        if (conditionString == null || conditionString.trim().isEmpty()) {
            return true;
        }
        block22: for (String rawPart : parts = conditionString.split(";")) {
            String part = rawPart.trim();
            if (part.isEmpty()) continue;
            if (part.toLowerCase().startsWith("permission:")) {
                String perm = part.substring("permission:".length()).trim();
                if (player.hasPermission(perm)) continue;
                return false;
            }
            if (part.toLowerCase().startsWith("world:")) {
                String regex;
                String worldValue = ScoreboardManager.stripQuotes(part.substring("world:".length()).trim());
                String playerWorld = player.getWorld().getName();
                if (worldValue.startsWith("^")) {
                    String prefix = worldValue.substring(1);
                    if (playerWorld.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                    return false;
                }
                if (!(worldValue.contains("*") ? !playerWorld.matches("(?i)" + (regex = worldValue.replace("*", ".*"))) : !playerWorld.equalsIgnoreCase(worldValue))) continue;
                return false;
            }
            String operator = ScoreboardManager.findOperator(part);
            if (operator == null) {
                this.plugin.getLogger().warning("Invalid condition (no operator): " + part);
                return false;
            }
            String[] sides = part.split(Pattern.quote(operator), 2);
            if (sides.length != 2) {
                this.plugin.getLogger().warning("Invalid condition (split failed): " + part);
                return false;
            }
            String leftRaw = sides[0].trim();
            String rightRaw = ScoreboardManager.stripQuotes(sides[1].trim());
            String leftExpanded = leftRaw;
            if (this.plugin.isPlaceholderAPIEnabled() && (leftRaw.contains("%") || leftRaw.startsWith("%") && leftRaw.endsWith("%"))) {
                try {
                    leftExpanded = PlaceholderAPI.setPlaceholders((Player)player, (String)leftRaw);
                }
                catch (Throwable t) {
                    leftExpanded = "";
                }
            } else if (this.plugin.isPlaceholderAPIEnabled() && leftRaw.startsWith("%") && leftRaw.endsWith("%")) {
                leftExpanded = PlaceholderAPI.setPlaceholders((Player)player, (String)leftRaw);
            }
            if (leftExpanded == null) {
                leftExpanded = "";
            }
            if (ScoreboardManager.isNumeric(leftExpanded) && ScoreboardManager.isNumeric(rightRaw) && (operator.equals(">") || operator.equals("<") || operator.equals(">=") || operator.equals("<="))) {
                double a = Double.parseDouble(leftExpanded);
                double b = Double.parseDouble(rightRaw);
                switch (operator) {
                    case ">": {
                        if (a > b) break;
                        return false;
                    }
                    case "<": {
                        if (a < b) break;
                        return false;
                    }
                    case ">=": {
                        if (a >= b) break;
                        return false;
                    }
                    case "<=": {
                        if (a <= b) break;
                        return false;
                    }
                }
                continue;
            }
            switch (operator) {
                case "=": {
                    if (leftExpanded.equalsIgnoreCase(rightRaw)) continue block22;
                    return false;
                }
                case "!=": {
                    if (!leftExpanded.equalsIgnoreCase(rightRaw)) continue block22;
                    return false;
                }
                default: {
                    this.plugin.getLogger().warning("Unsupported operator or non-numeric compare for: " + part);
                    return false;
                }
            }
        }
        return true;
    }

    private static String stripQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String findOperator(String s) {
        String[] ops;
        for (String op : ops = new String[]{">=", "<=", "!=", ">", "<", "="}) {
            if (!s.contains(op)) continue;
            return op;
        }
        return null;
    }

    private static boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void updateScoreboard(Player player) {
        Objective objective;
        boolean recreate;
        UUID uuid = player.getUniqueId();
        if (!this.scoreboardVisible.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        ScoreboardProfile profile = this.findMatchingProfile(player);
        if (profile == null) {
            player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
            this.activeProfile.remove(uuid);
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        boolean bl = recreate = !profile.getName().equals(this.activeProfile.get(uuid)) || scoreboard == Bukkit.getScoreboardManager().getMainScoreboard();
        if (recreate) {
            scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            String title = this.setPlaceholdersForPlayer(player, profile.getTitle());
            objective = scoreboard.registerNewObjective("cloudboard", "dummy", this.applyColors(title));
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
            player.setScoreboard(scoreboard);
            this.activeProfile.put(uuid, profile.getName());
        } else {
            objective = scoreboard.getObjective(DisplaySlot.SIDEBAR);
            if (objective == null) {
                String title = this.setPlaceholdersForPlayer(player, profile.getTitle());
                objective = scoreboard.registerNewObjective("cloudboard", "dummy", this.applyColors(title));
                objective.setDisplaySlot(DisplaySlot.SIDEBAR);
            } else {
                objective.setDisplayName(this.applyColors(this.setPlaceholdersForPlayer(player, profile.getTitle())));
            }
        }
        this.updateLines(player, objective, profile);
    }

    private void updateLines(Player player, Objective objective, ScoreboardProfile profile) {
        Scoreboard scoreboard = objective.getScoreboard();
        List<String> rawLines = profile.getLines();
        HashSet<CallSite> managedEntries = new HashSet<CallSite>();
        int visualIndex = 0;
        int maxLines = Math.min(rawLines.size(), 15);
        for (int i = 0; i < rawLines.size() && visualIndex < 15; ++i) {
            boolean rawExplicitEmpty;
            String raw = rawLines.get(i);
            if (raw == null) {
                raw = "";
            }
            String lineCondition = null;
            String content = raw;
            if (raw.startsWith("{") && raw.contains("}")) {
                int end = raw.indexOf(125);
                lineCondition = raw.substring(1, end).trim();
                content = raw.substring(end + 1);
            }
            if (lineCondition != null && !this.checkCondition(player, lineCondition)) continue;
            String left = content;
            String right = null;
            if (content.contains("||")) {
                String[] parts = content.split("\\|\\|", 2);
                left = parts[0];
                right = parts[1];
            }
            left = left == null ? "" : left;
            right = right == null ? null : right;
            String leftExpanded = this.setPlaceholdersForPlayer(player, left);
            String rightExpanded = right == null ? null : this.setPlaceholdersForPlayer(player, right);
            boolean leftEmpty = leftExpanded == null || leftExpanded.trim().isEmpty();
            boolean rightEmpty = rightExpanded == null || rightExpanded.trim().isEmpty();
            boolean bl = rawExplicitEmpty = raw.equals("") || raw.equals("\"\"");
            if (leftEmpty && (right == null || rightEmpty) && !rawExplicitEmpty) continue;
            String entryName = ChatColor.values()[visualIndex % ChatColor.values().length].toString() + String.valueOf(ChatColor.RESET);
            String teamName = "line_" + visualIndex;
            Team team = scoreboard.getTeam(teamName);
            if (team == null) {
                team = scoreboard.registerNewTeam(teamName);
                if (!team.getEntries().contains(entryName)) {
                    team.addEntry(entryName);
                }
            } else if (!team.getEntries().contains(entryName)) {
                team.addEntry(entryName);
            }
            team.setPrefix(this.applyColors(leftExpanded == null ? "" : leftExpanded));
            team.setSuffix(this.applyColors(rightExpanded == null ? "" : rightExpanded));
            int lineScore = this.useNumbers ? rawLines.size() - i : 15 - visualIndex;
            objective.getScore(entryName).setScore(lineScore);
            managedEntries.add((CallSite)((Object)entryName));
            ++visualIndex;
        }
        for (String entry : new ArrayList(scoreboard.getEntries())) {
            if (managedEntries.contains(entry)) continue;
            scoreboard.resetScores(entry);
        }
    }

    public void handlePlayerJoin(Player player) {
        long delayMs = this.plugin.getConfig().getLong("scoreboard.delay-on-join-milliseconds", 0L);
        boolean hiddenByDefault = this.plugin.getConfig().getBoolean("scoreboard.hidden-by-default", false);
        boolean rememberChoice = this.plugin.getConfig().getBoolean("scoreboard.remember-toggle-choice", false);
        if (!rememberChoice) {
            this.scoreboardVisible.put(player.getUniqueId(), !hiddenByDefault);
        } else {
            this.scoreboardVisible.putIfAbsent(player.getUniqueId(), !hiddenByDefault);
        }
        if (this.scoreboardVisible.get(player.getUniqueId()).booleanValue()) {
            long ticks = Math.max(1L, delayMs / 50L);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    this.updateScoreboard(player);
                }
            }, ticks);
        }
    }

    public void handlePlayerQuit(Player player) {
        if (!this.plugin.getConfig().getBoolean("scoreboard.remember-toggle-choice", false)) {
            this.scoreboardVisible.remove(player.getUniqueId());
        }
        this.activeProfile.remove(player.getUniqueId());
    }

    private void startUpdateTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (!this.plugin.getConfig().getBoolean("scoreboard.enabled", true)) {
                return;
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.scoreboardVisible.getOrDefault(player.getUniqueId(), false).booleanValue()) continue;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (player.isOnline()) {
                        this.updateScoreboard(player);
                    }
                });
            }
        }, 20L, 20L);
    }

    private String setPlaceholdersForPlayer(Player player, String input) {
        if (input == null) {
            return "";
        }
        String expanded = input;
        if (this.plugin.isPlaceholderAPIEnabled()) {
            try {
                expanded = PlaceholderAPI.setPlaceholders((Player)player, (String)input);
            }
            catch (Throwable t) {
                expanded = input;
            }
        }
        return expanded;
    }

    private String applyColors(String input) {
        if (input == null) {
            return "";
        }
        String text = ChatColor.translateAlternateColorCodes((char)'&', (String)input);
        Pattern hexPattern = Pattern.compile("&#([0-9A-Fa-f]{6})");
        Matcher matcher = hexPattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            matcher.appendReplacement(buffer, String.valueOf(net.md_5.bungee.api.ChatColor.of((String)("#" + hex))));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

