/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.client;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import jugglestruggle.timechangerstruggle.client.Commands;
import jugglestruggle.timechangerstruggle.client.Keybindings;
import jugglestruggle.timechangerstruggle.client.screen.TimeChangerScreen;
import jugglestruggle.timechangerstruggle.config.Configuration;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBuilder;
import jugglestruggle.timechangerstruggle.daynight.type.LowToHighHeightTime;
import jugglestruggle.timechangerstruggle.daynight.type.MovingTime;
import jugglestruggle.timechangerstruggle.daynight.type.RandomizedTime;
import jugglestruggle.timechangerstruggle.daynight.type.StaticTime;
import jugglestruggle.timechangerstruggle.daynight.type.SystemTime;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class TimeChangerStruggleClient
implements ClientModInitializer {
    private static final Map<String, DayNightCycleBuilder> CYCLE_BUILDERS;
    public static boolean worldTime;
    public static boolean dateOverTicks;
    public static boolean smoothButterCycle;
    public static boolean disableNightVisionEffect;
    public static boolean applyOnPropertyListValueUpdate;
    private static DayNightCycleBasis timeChanger;
    private static String timeChangerKey;
    private static String timeChangerKeyFirst;
    private static String timeChangerKeyLast;
    public static boolean commandsCommandFeedbackOnLessImportant;
    public static boolean commandsDisableWorldTimeOnCycleUsage;
    public static boolean allowWorldChangeCyclesToWriteToDisk;
    public static Configuration config;
    private static Commands commands;
    private static boolean worldExistedPreviously;

    public static <B extends DayNightCycleBuilder> void registerCycleBuilder(B builder) {
        String key = builder.getKeyName();
        if (CYCLE_BUILDERS.containsKey(key)) {
            return;
        }
        if (timeChangerKeyFirst == null) {
            timeChangerKeyFirst = key;
        }
        timeChangerKeyLast = key;
        CYCLE_BUILDERS.put(key, builder);
    }

    public static final DayNightCycleBasis getTimeChanger() {
        return timeChanger;
    }

    public static final String getTimeChangerKey() {
        return timeChangerKey;
    }

    public static final void setTimeChanger(DayNightCycleBasis timeToChange) {
        timeChanger = timeToChange;
        Optional cachedCycleBuilder = timeToChange == null ? Optional.empty() : TimeChangerStruggleClient.getCachedCycleBuilderByClass(timeToChange.getBuilderClass());
        timeChangerKey = cachedCycleBuilder.isPresent() ? ((DayNightCycleBuilder)cachedCycleBuilder.get()).getKeyName() : null;
    }

    public static final void setTimeChanger(String cycleType) {
        if (!TimeChangerStruggleClient.cachedCycleTypeExists(cycleType)) {
            return;
        }
        timeChanger = CYCLE_BUILDERS.get(cycleType).create();
        timeChangerKey = cycleType;
    }

    public static final boolean useWorldTime() {
        return worldTime || timeChanger == null;
    }

    public static final Collection<DayNightCycleBuilder> getCachedCycleTypeBuilders() {
        return CYCLE_BUILDERS.values();
    }

    public static final int getCachedCycleTypeSize() {
        return CYCLE_BUILDERS.size();
    }

    public static final boolean cachedCycleTypeExists(String cycleTypeToCheck) {
        return cycleTypeToCheck != null && !cycleTypeToCheck.isEmpty() && CYCLE_BUILDERS.containsKey(cycleTypeToCheck);
    }

    public static final void quickSwitchCachedCycleType(boolean backwards) {
        if (timeChangerKey == null) {
            if (backwards) {
                TimeChangerStruggleClient.setTimeChanger(timeChangerKeyLast);
            } else {
                TimeChangerStruggleClient.setTimeChanger(timeChangerKeyFirst);
            }
        } else {
            Iterator<String> cycleKeys = CYCLE_BUILDERS.keySet().iterator();
            String previousKey = null;
            while (cycleKeys.hasNext()) {
                String key = cycleKeys.next();
                if (timeChangerKey.equals(key)) {
                    if (backwards) {
                        TimeChangerStruggleClient.setTimeChanger(previousKey == null ? timeChangerKeyLast : previousKey);
                        break;
                    }
                    TimeChangerStruggleClient.setTimeChanger(cycleKeys.hasNext() ? cycleKeys.next() : timeChangerKeyFirst);
                    break;
                }
                previousKey = key;
            }
        }
    }

    public static final Optional<DayNightCycleBuilder> getCachedCycleBuilderByClass(Class<?> builderClass) {
        Class<?>[] builderClassInterfaces;
        if (builderClass != null && (builderClassInterfaces = builderClass.getInterfaces()) != null && builderClassInterfaces.length == 1 && DayNightCycleBuilder.class.equals(builderClassInterfaces[0])) {
            return CYCLE_BUILDERS.values().stream().filter(b -> builderClass.equals(b.getClass())).findFirst();
        }
        return Optional.empty();
    }

    public static Optional<DayNightCycleBuilder> getCurrentCycleBuilder() {
        if (timeChanger != null && timeChangerKey != null) {
            return Optional.ofNullable(CYCLE_BUILDERS.get(timeChangerKey));
        }
        return Optional.empty();
    }

    public static final boolean isCycleTypeCurrentCycle(String cycleTypeToCheck) {
        if (cycleTypeToCheck == null || cycleTypeToCheck.isEmpty()) {
            return false;
        }
        Optional<DayNightCycleBuilder> builder = TimeChangerStruggleClient.getCurrentCycleBuilder();
        return builder.isPresent() && builder.get().getKeyName().equals(cycleTypeToCheck);
    }

    public void onInitializeClient() {
        Keybindings.registerKeybindings();
        File config = new File(class_310.method_1551().field_1697, "config");
        if (!config.exists()) {
            config.mkdir();
        }
        config = new File(config, "DaylightChangerStruggle.json");
        TimeChangerStruggleClient.config = new Configuration(config);
        commands = new Commands();
        commands.registerCommands();
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientTickEvents.END_WORLD_TICK.register(this::onWorldTick);
        TimeChangerStruggleClient.config.read();
    }

    private void onClientTick(class_310 client) {
        if (client.field_1755 == null && client.field_1687 != null) {
            if (Keybindings.timeChangerMenuKey.method_1434()) {
                client.method_1507((class_437)new TimeChangerScreen());
            }
            boolean previousWorldTime = worldTime;
            while (Keybindings.toggleWorldTimeKey.method_1436()) {
                worldTime = !previousWorldTime;
            }
        }
    }

    private void onWorldTick(class_638 world) {
        if (TimeChangerStruggleClient.useWorldTime()) {
            return;
        }
        timeChanger.tick();
    }

    public static void onWorldChanged(class_310 client, class_638 world) {
        if (!TimeChangerStruggleClient.useWorldTime() && worldExistedPreviously && timeChanger.saveOnWorldChange()) {
            config.createOrModifyDaylightCycleConfig(timeChanger, true);
            if (allowWorldChangeCyclesToWriteToDisk) {
                config.writeIfModified();
            }
        }
        worldExistedPreviously = world != null;
    }

    static {
        worldTime = true;
        dateOverTicks = false;
        smoothButterCycle = true;
        disableNightVisionEffect = false;
        applyOnPropertyListValueUpdate = false;
        timeChanger = null;
        timeChangerKey = null;
        timeChangerKeyFirst = null;
        timeChangerKeyLast = null;
        commandsCommandFeedbackOnLessImportant = true;
        commandsDisableWorldTimeOnCycleUsage = true;
        allowWorldChangeCyclesToWriteToDisk = true;
        worldExistedPreviously = false;
        CYCLE_BUILDERS = new LinkedHashMap<String, DayNightCycleBuilder>(5);
        TimeChangerStruggleClient.registerCycleBuilder(new SystemTime.Builder());
        TimeChangerStruggleClient.registerCycleBuilder(new StaticTime.Builder());
        TimeChangerStruggleClient.registerCycleBuilder(new MovingTime.Builder());
        TimeChangerStruggleClient.registerCycleBuilder(new RandomizedTime.Builder());
        TimeChangerStruggleClient.registerCycleBuilder(new LowToHighHeightTime.Builder());
    }
}

