/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.client.config.widget;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import jugglestruggle.timechangerstruggle.client.config.widget.WidgetConfigInterface;
import jugglestruggle.timechangerstruggle.client.widget.WidgetPositionedTooltip;
import jugglestruggle.timechangerstruggle.config.property.BaseNumber;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import jugglestruggle.timechangerstruggle.util.SimpleCharacterVisitor;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_5481;

public class NumericFieldWidgetConfig<N extends Number>
extends class_342
implements WidgetConfigInterface<BaseNumber<N>, N>,
WidgetPositionedTooltip {
    protected final BaseNumber<N> property;
    protected N initialNumber;
    private int tooltipWidth;
    private int tooltipHeight;
    private List<class_5481> compiledTooltipText;
    protected Consumer<String> textChangedListener;
    private boolean isNewTextValid;

    public NumericFieldWidgetConfig(class_327 textRenderer, int width, int height, BaseNumber<N> property) {
        super(textRenderer, 18, 18, width, height, (class_2561)class_2561.method_43473());
        this.property = property;
        this.isNewTextValid = true;
        this.method_1863(null);
        this.method_1890(null);
        this.method_1852(this.property.get().toString());
        this.initialNumber = this.property.get();
        this.method_1870(false);
    }

    public void method_1863(Consumer<String> changedListener) {
        this.textChangedListener = changedListener;
        super.method_1863(this::onTextChanged);
    }

    public void method_1890(Predicate<String> textPredicate) {
        super.method_1890(text -> text.isBlank() ? true : NumericFieldWidgetConfig.canParseString((Number)this.property.getDefaultValue(), text));
    }

    @Override
    public BaseNumber<N> getProperty() {
        return this.property;
    }

    @Override
    public boolean isValid() {
        if (!this.isNewTextValid || this.property.get() == null) {
            return false;
        }
        if (this.property.getMin() == null || this.property.getMax() == null) {
            return true;
        }
        return this.property.isWithinRange();
    }

    @Override
    public N getInitialValue() {
        return this.initialNumber;
    }

    @Override
    public void setInitialValue(N value) {
        this.initialNumber = value;
    }

    @Override
    public void forceSetWidgetValueToDefault(boolean justInitial) {
        if (justInitial) {
            this.method_1852(String.valueOf(this.initialNumber == null ? "0" : this.initialNumber));
        } else {
            Number defaultNumber = (Number)this.property.getDefaultValue();
            this.method_1852(String.valueOf(defaultNumber == null ? "0" : defaultNumber));
        }
    }

    @Override
    public void setPropertyValueToDefault(boolean justInitial) {
        if (justInitial) {
            this.property.set(this.initialNumber == null ? this.getZero() : this.initialNumber);
        } else {
            Number defaultNumber = (Number)this.property.getDefaultValue();
            this.property.set((Number)(defaultNumber == null ? this.getZero() : defaultNumber));
        }
    }

    @Override
    public boolean isDefaultValue() {
        return this.property.get().equals(this.property.getDefaultValue());
    }

    private N getZero() {
        return (N)NumericFieldWidgetConfig.parseString((Number)this.property.getDefaultValue(), "0");
    }

    private void onTextChanged(String newText) {
        boolean valid;
        boolean bl = valid = !newText.isEmpty() && !newText.isBlank();
        if (valid) {
            Number parsedNumber = NumericFieldWidgetConfig.parseString((Number)this.property.getDefaultValue(), newText);
            if (parsedNumber == null) {
                valid = false;
            } else {
                boolean tempNewTextValid = this.isNewTextValid;
                Object previousNumber = this.property.get();
                this.isNewTextValid = true;
                this.property.set(parsedNumber);
                valid = this.isValid();
                this.property.set(previousNumber);
                this.isNewTextValid = tempNewTextValid;
            }
            if (valid) {
                BaseProperty.ValueConsumer<BaseNumber<N>, Number> consumer = this.property.getConsumer();
                if (consumer != null) {
                    consumer.consume(this.property, parsedNumber, DayNightCycleBasis.PropertyWriterSource.USER);
                }
                this.property.set(parsedNumber);
            }
        }
        this.isNewTextValid = valid;
        this.method_1868(valid ? -2039584 : 0xE06060);
        if (this.textChangedListener != null) {
            this.textChangedListener.accept(newText);
        }
    }

    @Override
    public int getTooltipWidth() {
        return this.tooltipWidth;
    }

    @Override
    public int getTooltipHeight() {
        return this.tooltipHeight;
    }

    @Override
    public void setTooltipWidth(int width) {
        this.tooltipWidth = width;
    }

    @Override
    public void setTooltipHeight(int height) {
        this.tooltipHeight = height;
    }

    @Override
    public List<class_5481> getOrderedTooltip() {
        return this.compiledTooltipText;
    }

    @Override
    public void setOrderedTooltip(List<class_5481> textToSet) {
        this.compiledTooltipText = textToSet;
    }

    protected class_5250 method_25360() {
        class_5250 mt = SimpleCharacterVisitor.asMutableText(0, -1, this.compiledTooltipText);
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{mt, super.method_1882()});
    }

    protected static final boolean canParseString(Number n, String val) {
        return NumericFieldWidgetConfig.parseString(n, val) != null;
    }

    protected static final <N> N parseString(N n, String val) {
        if (n == null || val == null) {
            return null;
        }
        try {
            if (n instanceof Integer) {
                return (N)Integer.valueOf(Integer.parseInt(val));
            }
            if (n instanceof Long) {
                return (N)Long.valueOf(Long.parseLong(val));
            }
            if (n instanceof Double) {
                return (N)Double.valueOf(Double.parseDouble(val));
            }
            if (n instanceof Float) {
                return (N)Float.valueOf(Float.parseFloat(val));
            }
            if (n instanceof Byte) {
                return (N)Byte.valueOf(Byte.parseByte(val));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }
}

