/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.client.config.widget;

import java.util.List;
import java.util.function.Consumer;
import jugglestruggle.timechangerstruggle.client.config.widget.WidgetConfigInterface;
import jugglestruggle.timechangerstruggle.client.widget.WidgetPositionedTooltip;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import jugglestruggle.timechangerstruggle.config.property.StringValue;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class TextFieldWidgetConfig
extends class_342
implements WidgetConfigInterface<StringValue, String>,
WidgetPositionedTooltip {
    String initialText;
    final StringValue property;
    protected boolean allowEmptyText;
    private int tooltipWidth;
    private int tooltipHeight;
    private List<class_5481> compiledTooltipText;
    private Consumer<String> textChangedListener;

    public TextFieldWidgetConfig(class_327 textRenderer, int width, int height, StringValue property, boolean allowEmptyText) {
        super(textRenderer, 0, 0, width, height, (class_2561)class_2561.method_43473());
        this.property = property;
        this.allowEmptyText = allowEmptyText;
        this.initialText = (String)property.get();
        this.method_1852(this.initialText);
        this.method_1863(null);
        this.method_1870(false);
    }

    @Override
    public boolean isValid() {
        return this.allowEmptyText ? true : !this.method_1882().isBlank();
    }

    @Override
    public StringValue getProperty() {
        return this.property;
    }

    @Override
    public String getInitialValue() {
        return this.initialText;
    }

    @Override
    public void setInitialValue(String value) {
        this.initialText = value;
    }

    @Override
    public boolean isDefaultValue() {
        return ((String)this.property.getDefaultValue()).equals(this.property.get());
    }

    @Override
    public void forceSetWidgetValueToDefault(boolean justInitial) {
        if (justInitial) {
            super.method_1852(this.initialText == null ? "" : this.initialText);
        } else {
            String def = (String)this.property.getDefaultValue();
            super.method_1852(def == null ? "" : def);
        }
    }

    @Override
    public void setPropertyValueToDefault(boolean justInitial) {
        if (justInitial) {
            this.property.set(this.initialText == null ? "" : this.initialText);
        } else {
            String def = (String)this.property.getDefaultValue();
            this.property.set(def == null ? "" : def);
        }
    }

    public void method_1863(Consumer<String> changedListener) {
        this.textChangedListener = changedListener;
        super.method_1863(this::onTextChanged);
    }

    private void onTextChanged(String newText) {
        BaseProperty.ValueConsumer<StringValue, String> consumer = this.property.getConsumer();
        if (consumer != null) {
            consumer.consume(this.property, newText, DayNightCycleBasis.PropertyWriterSource.USER);
        }
        this.property.set(newText);
        if (this.textChangedListener != null) {
            this.textChangedListener.accept(newText);
        }
    }

    @Override
    public int getTooltipWidth() {
        return this.tooltipWidth;
    }

    @Override
    public int getTooltipHeight() {
        return this.tooltipHeight;
    }

    @Override
    public void setTooltipWidth(int width) {
        this.tooltipWidth = width;
    }

    @Override
    public void setTooltipHeight(int height) {
        this.tooltipHeight = height;
    }

    @Override
    public List<class_5481> getOrderedTooltip() {
        return this.compiledTooltipText;
    }

    @Override
    public void setOrderedTooltip(List<class_5481> textToSet) {
        this.compiledTooltipText = textToSet;
    }
}

