/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.client.util.color;

import jugglestruggle.timechangerstruggle.client.util.color.AbstractRGB;
import jugglestruggle.timechangerstruggle.util.EasingType;
import jugglestruggle.timechangerstruggle.util.Easings;

public class RainbowRGB
extends AbstractRGB {
    public Easings interpolation;
    public EasingType easingType;
    public int ticks;
    public int ticksForNextUpdate;
    private byte targetColor;
    public boolean reverseTargetColor;
    private int previousChromaColor;
    private int currentChromaColor;

    public static RainbowRGB[] createColors(int ... startingColors) {
        if (startingColors == null || startingColors.length <= 0) {
            throw new NullPointerException("Cannot create colors with an empty parameter");
        }
        RainbowRGB[] chromaColors = new RainbowRGB[startingColors.length];
        for (int i = 0; i < startingColors.length; ++i) {
            chromaColors[i] = new RainbowRGB(startingColors[i]);
        }
        return chromaColors;
    }

    public RainbowRGB(int startingColor) {
        this(startingColor, Easings.QUAD, EasingType.BETWEEN, 20, 0);
    }

    public RainbowRGB(int startingColor, Easings interpolation, EasingType easingType, int ticksForNextUpdate, byte targetColor) {
        this.previousColor = this.color = startingColor;
        this.currentChromaColor = this.color;
        this.previousChromaColor = this.color;
        this.interpolation = interpolation;
        this.easingType = easingType;
        this.ticksForNextUpdate = ticksForNextUpdate;
        this.setTargetColor(targetColor);
        this.tickSelf(true);
    }

    public RainbowRGB setTicks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public RainbowRGB setTicksForNextUpdate(int ticks) {
        this.ticksForNextUpdate = ticks;
        return this;
    }

    @Override
    public void tick() {
        this.tickSelf(false);
    }

    public void tickSelf(boolean forceNextUpdate) {
        if (this.ticks >= this.ticksForNextUpdate || forceNextUpdate) {
            boolean exitLoop;
            this.ticks = 0;
            this.previousChromaColor = this.currentChromaColor;
            int a = this.currentChromaColor >> 24 & 0xFF;
            int r = this.currentChromaColor >> 16 & 0xFF;
            int g = this.currentChromaColor >> 8 & 0xFF;
            int b = this.currentChromaColor & 0xFF;
            int tries = 0;
            do {
                exitLoop = true;
                byte previousTargetColor = this.targetColor;
                switch (this.targetColor) {
                    case 0: {
                        if (r >= 255) {
                            if (g >= 128 || b >= 128) {
                                this.targetColor = (byte)3;
                            }
                            ++tries;
                            exitLoop = false;
                            break;
                        }
                        r = 255;
                        break;
                    }
                    case 1: {
                        if (b <= 0) {
                            if (g < 128 || r < 128) {
                                this.targetColor = (byte)4;
                            }
                            ++tries;
                            exitLoop = false;
                            break;
                        }
                        b = 0;
                        break;
                    }
                    case 2: {
                        if (g >= 255) {
                            if (r >= 128 || b >= 128) {
                                this.targetColor = (byte)5;
                            }
                            ++tries;
                            exitLoop = false;
                            break;
                        }
                        g = 255;
                        break;
                    }
                    case 3: {
                        if (r <= 0) {
                            if (g < 128 || b < 128) {
                                this.targetColor = 0;
                            }
                            ++tries;
                            exitLoop = false;
                            break;
                        }
                        r = 0;
                        break;
                    }
                    case 4: {
                        if (b >= 255) {
                            if (r >= 128 || g >= 128) {
                                this.targetColor = 1;
                            }
                            ++tries;
                            exitLoop = false;
                            break;
                        }
                        b = 255;
                        break;
                    }
                    case 5: {
                        if (g <= 0) {
                            if (r < 128 || b < 128) {
                                this.targetColor = (byte)2;
                            }
                            ++tries;
                            exitLoop = false;
                            break;
                        }
                        g = 0;
                    }
                }
                if (this.targetColor != previousTargetColor) continue;
                if (this.reverseTargetColor) {
                    if (this.targetColor <= 0) {
                        this.targetColor = (byte)5;
                        continue;
                    }
                    this.targetColor = (byte)(this.targetColor - 1);
                    continue;
                }
                this.targetColor = this.targetColor >= 5 ? (byte)0 : (byte)(this.targetColor + 1);
            } while (!exitLoop && tries <= 3);
            this.currentChromaColor = a << 24 | r << 16 | g << 8 | b;
            this.previousColor = this.color;
            this.color = this.previousChromaColor;
        } else {
            this.previousColor = this.color;
            float delta = (float)this.ticks / (float)this.ticksForNextUpdate;
            float result = (float)this.interpolation.value(this.easingType, delta);
            this.color = AbstractRGB.getInterpolatedColor(this.previousChromaColor, this.currentChromaColor, result);
            ++this.ticks;
        }
    }

    public void setTargetColor(byte targetColor) {
        this.targetColor = targetColor < 0 ? (byte)0 : (targetColor > 5 ? (byte)5 : targetColor);
    }
}

