/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import jugglestruggle.timechangerstruggle.client.config.property.FancySectionProperty;
import jugglestruggle.timechangerstruggle.client.config.widget.NumericFieldWidgetConfig;
import jugglestruggle.timechangerstruggle.client.config.widget.WidgetConfigInterface;
import jugglestruggle.timechangerstruggle.client.screen.TimeChangerScreen;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import jugglestruggle.timechangerstruggle.config.property.StringValue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class BaseNumber<N extends Number>
extends BaseProperty<BaseNumber<N>, N> {
    protected N min;
    protected N max;
    protected N softMin;
    protected N softMax;

    protected BaseNumber(String propertyName, N defaultValue, N min, N max) {
        super(propertyName, defaultValue);
        this.min = min;
        this.max = max;
        this.softMin = min;
        this.softMax = max;
    }

    @Override
    public N get() {
        return (N)((Number)this.value);
    }

    @Override
    public void set(N value) {
        this.value = value;
    }

    public abstract boolean isWithinRange();

    public abstract N parseStringNumber(String var1);

    public N getMin() {
        return this.min;
    }

    public N getMax() {
        return this.max;
    }

    public N getSoftMin() {
        return this.softMin;
    }

    public N getSoftMax() {
        return this.softMax;
    }

    @Override
    public void readFromJson(JsonElement elem) {
        if (!elem.isJsonPrimitive()) {
            return;
        }
        JsonPrimitive prim = elem.getAsJsonPrimitive();
        if (prim.isNumber()) {
            Number n = prim.getAsNumber();
            boolean expectedNumber = n.getClass().equals(((Number)this.getDefaultValue()).getClass());
            if (!expectedNumber && (prim.isString() || n instanceof LazilyParsedNumber)) {
                n = n instanceof LazilyParsedNumber ? this.parseStringNumber(n.toString()) : this.parseStringNumber(prim.getAsString());
                expectedNumber = true;
            }
            if (expectedNumber) {
                this.set((N)n);
            }
        }
    }

    @Override
    public JsonElement writeToJson() {
        Object value = this.get();
        return new JsonPrimitive((Number)(value == null ? (Number)this.getDefaultValue() : value));
    }

    @Override
    public WidgetConfigInterface<BaseNumber<N>, N> createConfigElement(TimeChangerScreen screen, FancySectionProperty owningSection) {
        NumericFieldWidgetConfig n = new NumericFieldWidgetConfig(screen.method_64506(), 18, 18, this);
        StringValue.onCreateConfigElementAddTooltips(this, n, screen, owningSection);
        return n;
    }
}

