/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.google.gson.JsonElement;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import jugglestruggle.timechangerstruggle.client.config.property.FancySectionProperty;
import jugglestruggle.timechangerstruggle.client.config.widget.WidgetConfigInterface;
import jugglestruggle.timechangerstruggle.client.screen.TimeChangerScreen;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

@Environment(value=EnvType.CLIENT)
public abstract class BaseProperty<B extends BaseProperty<B, V>, V> {
    protected final String propertyKey;
    protected V value;
    protected V defaultValue;
    protected ValueConsumer<B, V> consumer;

    public BaseProperty(String property, V value) {
        this(property, value, value);
    }

    public BaseProperty(String property, V value, V defaultValue) {
        this.propertyKey = property;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    public final String property() {
        return this.propertyKey;
    }

    public V get() {
        return this.value;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public abstract void set(V var1);

    public abstract WidgetConfigInterface<B, V> createConfigElement(TimeChangerScreen var1, FancySectionProperty var2);

    public abstract ArgumentType<V> onCommandOptionGetArgType();

    public abstract int onCommandOptionWithValueExecute(CommandContext<FabricClientCommandSource> var1);

    public boolean onCommandOptionNoValueShouldBeExecuted() {
        return false;
    }

    public int onCommandOptionNoValueExecute(CommandContext<FabricClientCommandSource> ctx) {
        return 0;
    }

    public abstract void readFromJson(JsonElement var1);

    public abstract JsonElement writeToJson();

    public ValueConsumer<B, V> getConsumer() {
        return this.consumer;
    }

    public BaseProperty<B, V> consumer(ValueConsumer<B, V> consumer) {
        this.consumer = consumer;
        return this;
    }

    public BaseProperty<B, V> consumer(DayNightCycleBasis cycle) {
        if (cycle != null) {
            this.consumer = (prop, val, wr) -> cycle.writePropertyValueToCycle(prop, wr);
        }
        return this;
    }

    public final BaseProperty<B, V> consumerOnlyIfNotExists(DayNightCycleBasis cycle) {
        if (cycle != null && this.consumer == null) {
            this.consumer((B prop, V val, DayNightCycleBasis.PropertyWriterSource wr) -> cycle.writePropertyValueToCycle(prop, wr));
        }
        return this;
    }

    public final BaseProperty<B, V> consumerOnlyIfNotExists(TimeChangerScreen screen) {
        if (screen != null && this.consumer == null) {
            this.consumer(screen::consumeChangedProperty);
        }
        return this;
    }

    public static interface ValueConsumer<B extends BaseProperty<B, V>, V> {
        public void consume(B var1, V var2, DayNightCycleBasis.PropertyWriterSource var3);
    }
}

