/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import jugglestruggle.timechangerstruggle.client.config.property.FancySectionProperty;
import jugglestruggle.timechangerstruggle.client.config.widget.CyclingWidgetConfig;
import jugglestruggle.timechangerstruggle.client.config.widget.WidgetConfigInterface;
import jugglestruggle.timechangerstruggle.client.screen.TimeChangerScreen;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import jugglestruggle.timechangerstruggle.util.InterchangeableFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5676;

@Environment(value=EnvType.CLIENT)
public class EnumValue<EV extends Enum<EV>>
extends BaseProperty<EnumValue<EV>, EV> {
    protected final EV[] enumValues;
    protected Function<EV, class_2561> valueToTextFunc;
    protected Predicate<EV> validatePredicate;
    protected InterchangeableFunction<EV, String> readableFunc;
    private final class_5676.class_5678<EV> callback = (button, value) -> {
        if (this.consumer != null) {
            this.consumer.consume(this, (Enum)value, DayNightCycleBasis.PropertyWriterSource.USER);
        }
    };

    public EnumValue(String property, EV value2, EV defaultValue, EV[] values) {
        super(property, value2, defaultValue);
        assert (values != null && values.length > 0);
        this.enumValues = values;
        this.readableFunc = defaultValue instanceof InterchangeableFunction ? (InterchangeableFunction)defaultValue : null;
    }

    @Override
    public void set(EV value) {
        if (this.validatePredicate == null || this.validatePredicate.test(value)) {
            this.value = value;
        }
    }

    public EV[] getEnumValues() {
        return this.enumValues;
    }

    public Function<EV, class_2561> getVTT() {
        return this.valueToTextFunc;
    }

    public Predicate<EV> getEnumValidation() {
        return this.validatePredicate;
    }

    public EnumValue<EV> setVTT(Function<EV, class_2561> func) {
        this.valueToTextFunc = func;
        return this;
    }

    @Deprecated
    public EnumValue<EV> setSaveLoadEnumFunction(InterchangeableFunction<EV, String> func) {
        this.readableFunc = func;
        return this;
    }

    public EnumValue<EV> setEnumValidation(Predicate<EV> predicate) {
        this.validatePredicate = predicate;
        return this;
    }

    @Override
    public WidgetConfigInterface<EnumValue<EV>, EV> createConfigElement(TimeChangerScreen screen, FancySectionProperty owningSection) {
        class_2561 sectionText;
        CyclingWidgetConfig.WidgetConfigBuilderEnum builder = CyclingWidgetConfig.enumCycle(this);
        class_2561 optionText = null;
        if (owningSection != null && (sectionText = (class_2561)owningSection.get()) != null && sectionText.method_10851() instanceof class_2588) {
            optionText = class_2561.method_43471((String)String.format("%1$s.%2$s", ((class_2588)sectionText.method_10851()).method_11022(), this.property().toLowerCase(Locale.ROOT)));
        }
        if (optionText == null) {
            optionText = class_2561.method_30163((String)this.property());
        }
        return builder.build(20, 20, optionText, this.callback);
    }

    @Override
    public void readFromJson(JsonElement elem) {
        if (!elem.isJsonPrimitive()) {
            return;
        }
        JsonPrimitive prim = elem.getAsJsonPrimitive();
        if (!prim.isString()) {
            return;
        }
        String valueName = prim.getAsString();
        Enum obtainedValue = null;
        if (this.readableFunc == null) {
            for (EV value : this.enumValues) {
                if (!valueName.equals(((Enum)value).name())) continue;
                obtainedValue = value;
                break;
            }
        } else {
            obtainedValue = (Enum)this.readableFunc.applyLeft(valueName);
        }
        if (obtainedValue != null) {
            this.set((EV)obtainedValue);
        }
    }

    @Override
    public JsonElement writeToJson() {
        String namedProp;
        Enum enumToWriteTo = this.validatePredicate == null || this.validatePredicate.test((Enum)this.get()) ? (Enum)this.get() : (Enum)this.getDefaultValue();
        if (this.readableFunc != null && (namedProp = this.readableFunc.applyRight(enumToWriteTo)) != null && !namedProp.isEmpty() && !namedProp.isBlank()) {
            return new JsonPrimitive(namedProp);
        }
        return new JsonPrimitive(enumToWriteTo.name());
    }

    @Override
    public ArgumentType<EV> onCommandOptionGetArgType() {
        return new EnumValueArgType(this);
    }

    @Override
    public int onCommandOptionWithValueExecute(CommandContext<FabricClientCommandSource> ctx) {
        return 0;
    }

    static class EnumValueArgType<EV extends Enum<EV>>
    implements ArgumentType<EV> {
        private final Set<EV> enums;
        private final InterchangeableFunction<EV, String> readableFunc;

        private EnumValueArgType(EnumValue<EV> prop) {
            this.readableFunc = prop.readableFunc;
            this.enums = ImmutableSet.copyOf((Object[])prop.getEnumValues());
        }

        public EV parse(StringReader reader) throws CommandSyntaxException {
            int beginningArg = reader.getCursor();
            if (!reader.canRead()) {
                reader.skip();
            }
            while (reader.canRead() && reader.peek() != ' ') {
                reader.skip();
            }
            String val = reader.getString().substring(beginningArg, reader.getCursor());
            String valLow = val.toLowerCase(Locale.ROOT);
            Optional<Enum> enumFound = this.readableFunc == null ? this.enums.stream().filter(enumerator -> enumerator.name().toLowerCase(Locale.ROOT).equals(valLow)).findFirst() : this.enums.stream().filter(enumerator -> this.readableFunc.applyRight(enumerator).equals(val)).findFirst();
            if (enumFound.isPresent()) {
                return (EV)enumFound.get();
            }
            return null;
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            String startingText = builder.getRemainingLowerCase();
            if (this.readableFunc == null) {
                this.enums.stream().filter(enumerator -> enumerator.name().toLowerCase(Locale.ROOT).startsWith(startingText)).forEach(enumerator -> builder.suggest(enumerator.name().toLowerCase(Locale.ROOT)));
            } else {
                this.enums.stream().filter(enumerator -> this.readableFunc.applyRight(enumerator).startsWith(startingText)).forEach(enumerator -> builder.suggest(this.readableFunc.applyRight(enumerator)));
            }
            return builder.buildFuture();
        }
    }
}

