/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import jugglestruggle.timechangerstruggle.config.property.BaseNumber;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class IntValue
extends BaseNumber<Integer> {
    public IntValue(String propertyName, int defaultValue, Integer min, Integer max) {
        super(propertyName, defaultValue, min, max);
    }

    @Override
    public boolean isWithinRange() {
        Integer value = (Integer)this.get();
        return value != null && value >= (Integer)this.getMin() && value <= (Integer)this.getMax();
    }

    @Override
    public Integer parseStringNumber(String toParse) {
        try {
            return Integer.parseInt(toParse);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public ArgumentType<Integer> onCommandOptionGetArgType() {
        if (this.min == null || this.max == null) {
            return IntegerArgumentType.integer();
        }
        return IntegerArgumentType.integer((int)((Integer)this.min), (int)((Integer)this.max));
    }

    @Override
    public int onCommandOptionWithValueExecute(CommandContext<FabricClientCommandSource> ctx) {
        this.set(IntegerArgumentType.getInteger(ctx, (String)"value"));
        return 3;
    }
}

