/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import jugglestruggle.timechangerstruggle.config.property.BaseNumber;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class LongValue
extends BaseNumber<Long> {
    public LongValue(String propertyName, long defaultValue, Long min, Long max) {
        super(propertyName, defaultValue, min, max);
    }

    @Override
    public boolean isWithinRange() {
        Long v = (Long)this.get();
        return v != null && v >= (Long)this.getMin() && v <= (Long)this.getMax();
    }

    @Override
    public Long parseStringNumber(String toParse) {
        try {
            return Long.parseLong(toParse);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public ArgumentType<Long> onCommandOptionGetArgType() {
        if (this.min == null || this.max == null) {
            return LongArgumentType.longArg();
        }
        return LongArgumentType.longArg((long)((Long)this.min), (long)((Long)this.max));
    }

    @Override
    public int onCommandOptionWithValueExecute(CommandContext<FabricClientCommandSource> ctx) {
        this.set(LongArgumentType.getLong(ctx, (String)"value"));
        return 3;
    }
}

