/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.Locale;
import jugglestruggle.timechangerstruggle.client.config.property.FancySectionProperty;
import jugglestruggle.timechangerstruggle.client.config.widget.TextFieldWidgetConfig;
import jugglestruggle.timechangerstruggle.client.config.widget.WidgetConfigInterface;
import jugglestruggle.timechangerstruggle.client.screen.TimeChangerScreen;
import jugglestruggle.timechangerstruggle.client.widget.WidgetPositionedTooltip;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

@Environment(value=EnvType.CLIENT)
public class StringValue
extends BaseProperty<StringValue, String> {
    protected boolean allowEmptyText;

    public StringValue(String propertyName, String value) {
        super(propertyName, value);
    }

    public StringValue(String propertyName, String value, String defaultValue) {
        super(propertyName, value, defaultValue);
    }

    @Override
    public void set(String value) {
        if (this.isEmptyTextAllowed()) {
            if (value == null) {
                this.value = "";
                return;
            }
        } else if (value == null || !value.isEmpty() && !value.isBlank()) {
            return;
        }
        this.value = value;
    }

    public boolean isEmptyTextAllowed() {
        return this.allowEmptyText;
    }

    public StringValue setEmptyTextAllowance(boolean allow) {
        this.allowEmptyText = allow;
        return this;
    }

    @Override
    public void readFromJson(JsonElement elem) {
        JsonPrimitive prim;
        if (elem instanceof JsonPrimitive && (prim = (JsonPrimitive)elem).isString()) {
            String s = prim.getAsString();
            if (this.isEmptyTextAllowed() || !s.isEmpty() && !s.isBlank()) {
                this.set(s);
            }
        }
    }

    @Override
    public JsonElement writeToJson() {
        String s = (String)this.get();
        if (this.isEmptyTextAllowed()) {
            return new JsonPrimitive(s == null ? "" : s);
        }
        if (!s.isEmpty() && !s.isBlank()) {
            return new JsonPrimitive(s);
        }
        return new JsonPrimitive((String)this.getDefaultValue());
    }

    @Override
    public WidgetConfigInterface<StringValue, String> createConfigElement(TimeChangerScreen screen, FancySectionProperty owningSection) {
        TextFieldWidgetConfig s = new TextFieldWidgetConfig(screen.method_64506(), 18, 18, this, this.allowEmptyText);
        StringValue.onCreateConfigElementAddTooltips(this, s, screen, owningSection);
        return s;
    }

    public static <B extends BaseProperty<B, V>, V> void onCreateConfigElementAddTooltips(B property, WidgetConfigInterface<B, V> widget, TimeChangerScreen screen, FancySectionProperty owningSection) {
        if (widget instanceof WidgetPositionedTooltip) {
            class_7417 class_74172;
            WidgetPositionedTooltip wpt = (WidgetPositionedTooltip)((Object)widget);
            if (owningSection != null && owningSection.get() != null && (class_74172 = ((class_2561)owningSection.get()).method_10851()) instanceof class_2588) {
                class_2588 ttc = (class_2588)class_74172;
                class_5250 tooltipDescText = class_2561.method_43471((String)String.format("%1$s.%2$s", ttc.method_11022(), property.property().toLowerCase(Locale.ROOT)));
                wpt.updateTooltip((class_2561)tooltipDescText, null, screen.method_64506());
            }
        }
    }

    @Override
    public ArgumentType<String> onCommandOptionGetArgType() {
        return StringArgumentType.string();
    }

    @Override
    public int onCommandOptionWithValueExecute(CommandContext<FabricClientCommandSource> ctx) {
        this.set(StringArgumentType.getString(ctx, (String)"value"));
        return 3;
    }
}

