/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import jugglestruggle.timechangerstruggle.client.TimeChangerStruggleClient;
import jugglestruggle.timechangerstruggle.client.screen.TimeChangerScreen;
import jugglestruggle.timechangerstruggle.config.property.LongValue;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBuilder;
import jugglestruggle.timechangerstruggle.daynight.type.MovingTime;
import jugglestruggle.timechangerstruggle.daynight.type.StaticTime;
import jugglestruggle.timechangerstruggle.util.DaylightUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_2245;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7157;

@Environment(value=EnvType.CLIENT)
public class Commands {
    private boolean commandsRegistered;

    public void registerCommands() {
        if (this.commandsRegistered) {
            return;
        }
        ClientCommandRegistrationCallback.EVENT.register(this::register);
    }

    private void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        LiteralCommandNode baseCommand = dispatcher.register(this.getBaseCommand());
        for (String alias : this.getAliases()) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)alias).redirect((CommandNode)baseCommand));
        }
        this.commandsRegistered = true;
    }

    public LiteralArgumentBuilder<FabricClientCommandSource> getBaseCommand() {
        LiteralArgumentBuilder base = ClientCommandManager.literal((String)"daylightchanger");
        base.executes(this::displayWorldTime);
        base.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"worldtime").executes((Command)new WorldTimeCommand(true))).then(ClientCommandManager.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes((Command)new WorldTimeCommand(false))));
        base.then(this.generateCycleSubcommand());
        base.then(this.generateOptionSubcommand());
        base.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"time").executes(this::displayWorldTime)).then(StaticTimeSetCommand.addSubtimeCommands(StaticTimeMode.ADD))).then(StaticTimeSetCommand.addSubtimeCommands(StaticTimeMode.SET))).then(StaticTimeSetCommand.addSubtimeCommands(StaticTimeMode.REMOVE)));
        return base;
    }

    public Set<String> getAliases() {
        return ImmutableSet.of((Object)"dcs", (Object)"tcs", (Object)"timechanger");
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> generateCycleSubcommand() {
        LiteralArgumentBuilder cycleSubcommand = ClientCommandManager.literal((String)"cycle");
        cycleSubcommand.executes(ctx -> {
            TimeChangerStruggleClient.getCachedCycleTypeBuilders().forEach(cycle -> {
                class_5250 options = class_2561.method_43470((String)"[\u26a1]");
                class_5250 useCycle = class_2561.method_43470((String)"[\u2192]");
                String baseName = cycle.getKeyName();
                class_2561 displayName = cycle.getTranslatableName();
                boolean isCurrentCycle = TimeChangerStruggleClient.isCycleTypeCurrentCycle(baseName);
                useCycle.method_27694(style -> style.method_36139(isCurrentCycle ? 0xFF5511 : 0x55FF11).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tcs cycle " + baseName)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"jugglestruggle.tcs.cmd.cycle.listing.use", (Object[])new Object[]{displayName}))).method_10982(Boolean.valueOf(true)));
                options.method_27694(style -> {
                    class_2583 currentStyle = style.method_10982(Boolean.valueOf(true)).method_36139(cycle.hasOptionsToEdit() ? 0xFFDD00 : 0x666666);
                    if (cycle.hasOptionsToEdit()) {
                        currentStyle = currentStyle.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"jugglestruggle.tcs.cmd.cycle.listing.option", (Object[])new Object[]{displayName}))).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tcs cycle " + baseName + " option"));
                    }
                    return currentStyle;
                });
                class_5250 displayNameAsDisplay = displayName.method_27661();
                displayNameAsDisplay.method_27694(style -> {
                    class_2561 displayDesc = cycle.getTranslatableDescription();
                    if (displayDesc == null) {
                        return style;
                    }
                    return style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)displayDesc));
                });
                Commands.sendTextToChat((CommandContext<FabricClientCommandSource>)ctx, (class_2561)class_2561.method_43469((String)"%1$s %2$s %3$s", (Object[])new Object[]{options, useCycle, displayNameAsDisplay}));
            });
            return 1;
        });
        cycleSubcommand.then(ClientCommandManager.literal((String)"remove").executes(ctx -> {
            if (TimeChangerStruggleClient.getTimeChanger() == null) {
                Commands.sendTextToChat((CommandContext<FabricClientCommandSource>)ctx, style -> style.method_36139(0xFF2222).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.cycle.remove.use.error", new Object[0]);
                return 0;
            }
            Optional<DayNightCycleBuilder> previousCycle = TimeChangerStruggleClient.getCurrentCycleBuilder();
            TimeChangerStruggleClient.setTimeChanger((DayNightCycleBasis)null);
            TimeChangerStruggleClient.config.writeIfModified();
            class_5250 cycleRemovedText = class_2561.method_43469((String)"jugglestruggle.tcs.cmd.cycle.cycle", (Object[])new Object[]{previousCycle.isPresent() ? previousCycle.get().getTranslatableName() : "??"});
            class_5250 worldTimeText = class_2561.method_43471((String)"jugglestruggle.tcs.screen.toggleworldtime");
            cycleRemovedText.method_27694(style -> style.method_36139(0xFFDD33));
            worldTimeText.method_27694(style -> style.method_36139(0xFFCC22));
            Commands.sendTextToChat((CommandContext<FabricClientCommandSource>)ctx, style -> style.method_36139(0x22FF22).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.cycle.remove.use", cycleRemovedText, worldTimeText);
            return 1;
        }));
        for (DayNightCycleBuilder cycle : TimeChangerStruggleClient.getCachedCycleTypeBuilders()) {
            String cycleName = cycle.getKeyName();
            if (cycleName.toLowerCase(Locale.ROOT).equals("remove")) continue;
            LiteralArgumentBuilder cycleArg = ClientCommandManager.literal((String)cycleName);
            cycleArg.executes((Command)new CycleUseCommand(cycle));
            cycleArg.then(ClientCommandManager.literal((String)"use").executes((Command)new CycleUseCommand(cycle)));
            if (cycle.hasOptionsToEdit()) {
                LiteralArgumentBuilder cycleOptionArg = ClientCommandManager.literal((String)"option");
                cycleOptionArg.executes(ctx -> {
                    ((FabricClientCommandSource)ctx.getSource()).getClient().method_1507((class_437)new TimeChangerScreen(cycle));
                    return 1;
                });
                cycleArg.then((ArgumentBuilder)cycleOptionArg);
            }
            cycleSubcommand.then((ArgumentBuilder)cycleArg);
        }
        return cycleSubcommand;
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> generateOptionSubcommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"option").then(this.generateOptionSubcommandBoolAction("dateOverTicks", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.screen.toggledate"), () -> TimeChangerStruggleClient.dateOverTicks, currentValue -> {
            TimeChangerStruggleClient.dateOverTicks = currentValue;
            return TimeChangerStruggleClient.dateOverTicks;
        }))).then(this.generateOptionSubcommandBoolAction("butterySmoothCycle", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.screen.togglesmoothbutterdaylightcycle"), () -> TimeChangerStruggleClient.smoothButterCycle, currentValue -> {
            TimeChangerStruggleClient.smoothButterCycle = currentValue;
            return TimeChangerStruggleClient.smoothButterCycle;
        }))).then(this.generateOptionSubcommandBoolAction("disableNightVisionEffect", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.cmd.option.disablenightvision"), () -> TimeChangerStruggleClient.disableNightVisionEffect, currentValue -> {
            TimeChangerStruggleClient.disableNightVisionEffect = currentValue;
            return TimeChangerStruggleClient.disableNightVisionEffect;
        }))).then(this.generateOptionSubcommandBoolAction("disableWorldTimeOnCycleUsage", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.cmd.option.disableworldtimeoncycleusage"), () -> TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage, currentValue -> {
            TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage = currentValue;
            return TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage;
        }))).then(this.generateOptionSubcommandBoolAction("commandFeedbackOnLessImportant", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.cmd.option.commandfeedbackonlessimportant"), () -> TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant, currentValue -> {
            TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant = currentValue;
            return TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant;
        }))).then(this.generateOptionSubcommandBoolAction("allowWorldChangeCyclesToWriteToDisk", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.cmd.option.allowworldchangecyclestowritetodisk"), () -> TimeChangerStruggleClient.allowWorldChangeCyclesToWriteToDisk, currentValue -> {
            TimeChangerStruggleClient.allowWorldChangeCyclesToWriteToDisk = currentValue;
            return TimeChangerStruggleClient.allowWorldChangeCyclesToWriteToDisk;
        }));
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> generateOptionSubcommandBoolAction(String subcommandName, class_2561 displayName, BooleanSupplier suppliedValue, UnaryOperator<Boolean> onApplyConsumer) {
        LiteralArgumentBuilder subcommand = ClientCommandManager.literal((String)subcommandName);
        subcommand.executes(ctx -> {
            boolean newValue = (Boolean)onApplyConsumer.apply(!suppliedValue.getAsBoolean());
            TimeChangerStruggleClient.config.writeIfModified();
            Commands.sendTextToChat((CommandContext<FabricClientCommandSource>)ctx, "jugglestruggle.tcs.cmd.option.set", displayName, class_5244.method_36134((boolean)newValue));
            return 1;
        });
        subcommand.then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean newValue;
            boolean previousValue = suppliedValue.getAsBoolean();
            boolean prevAndNewValueEquals = previousValue == (newValue = ((Boolean)onApplyConsumer.apply(BoolArgumentType.getBool((CommandContext)ctx, (String)"enable"))).booleanValue());
            Commands.sendTextToChat((CommandContext<FabricClientCommandSource>)ctx, "jugglestruggle.tcs.cmd.option.set" + (prevAndNewValueEquals ? ".error.equals" : ""), displayName, class_5244.method_36134((boolean)newValue));
            if (prevAndNewValueEquals) {
                return 0;
            }
            TimeChangerStruggleClient.config.writeIfModified();
            return 1;
        }));
        return subcommand;
    }

    private int displayWorldTime(CommandContext<FabricClientCommandSource> ctx) {
        class_638 w = ((FabricClientCommandSource)ctx.getSource()).getWorld();
        Commands.sendTextToChat(ctx, s -> s.method_36139(0xFFDD22), "jugglestruggle.tcs.cmd.time.use", w.method_8532(), DaylightUtils.getParsedTime((class_1937)w, true));
        return 1;
    }

    public static void sendTextToChat(CommandContext<FabricClientCommandSource> ctx, String key, Object ... args) {
        Commands.sendTextToChat(ctx, null, key, args);
    }

    public static void sendTextToChat(CommandContext<FabricClientCommandSource> ctx, UnaryOperator<class_2583> styleUpdater, String key, Object ... args) {
        class_5250 text;
        class_5250 class_52502 = text = args == null || args.length <= 0 ? class_2561.method_43471((String)key) : class_2561.method_43469((String)key, (Object[])args);
        if (styleUpdater != null) {
            text.method_27694(styleUpdater);
        }
        Commands.sendTextToChat(ctx, (class_2561)text);
    }

    public static void sendTextToChat(CommandContext<FabricClientCommandSource> ctx, class_2561 text) {
        ((FabricClientCommandSource)ctx.getSource()).getClient().field_1705.method_1743().method_1812(text);
    }

    static void cycleSetAndWeNeedToKnowIfWeCanDisableWorldTime() {
        if (TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage) {
            TimeChangerStruggleClient.worldTime = false;
        }
    }

    static String getStarterCommand(CommandContext<FabricClientCommandSource> ctx) {
        return ctx.getLastChild().getInput().split(" ", 2)[0];
    }

    private class WorldTimeCommand
    implements Command<FabricClientCommandSource> {
        final boolean toggleMode;

        public WorldTimeCommand(boolean toggleMode) {
            this.toggleMode = toggleMode;
        }

        public int run(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
            boolean setWorldTime;
            boolean bl = this.toggleMode ? !TimeChangerStruggleClient.worldTime : (setWorldTime = BoolArgumentType.getBool(ctx, (String)"enabled"));
            if (setWorldTime == TimeChangerStruggleClient.worldTime) {
                return 0;
            }
            TimeChangerStruggleClient.worldTime = setWorldTime;
            if (TimeChangerStruggleClient.useWorldTime() && !setWorldTime) {
                String starterCommand = Commands.getStarterCommand(ctx);
                String realCmd = String.format("/%1$s cycle", starterCommand);
                String langCmd = "jugglestruggle.tcs.cmd.worldtime.set.warn";
                class_5250 clickableText = class_2561.method_43470((String)realCmd);
                clickableText.method_27694(style -> style.method_36139(0xDD44FF).method_30938(Boolean.valueOf(true)).method_10982(Boolean.valueOf(false)).method_10958(new class_2558(class_2558.class_2559.field_11750, realCmd)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"jugglestruggle.tcs.cmd.worldtime.set.warn.hover"))));
                Commands.sendTextToChat(ctx, style -> style.method_36139(0xFFDD00).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.worldtime.set.warn", clickableText);
            } else if (TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant) {
                Commands.sendTextToChat(ctx, style -> style.method_36139(0x44FF00).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.worldtime.set", class_5244.method_36134((boolean)TimeChangerStruggleClient.worldTime));
            }
            return 1;
        }
    }

    public static enum StaticTimeMode {
        SET,
        ADD,
        REMOVE;

    }

    static class StaticTimeSetCommand
    implements Command<FabricClientCommandSource> {
        final Long timeToSet;
        final StaticTimeMode mode;

        public static LiteralArgumentBuilder<FabricClientCommandSource> addSubtimeCommands(StaticTimeMode mode) {
            LiteralArgumentBuilder base = (LiteralArgumentBuilder)ClientCommandManager.literal((String)mode.name().toLowerCase(Locale.ROOT)).then(ClientCommandManager.argument((String)"time", (ArgumentType)class_2245.method_9489()).executes((Command)new StaticTimeSetCommand(null, mode)));
            Lists.newArrayList((Object[])StaticTime.PresetSetTimes.values()).stream().filter(presetTime -> presetTime.shouldShowInCommand()).forEach(presetTime -> base.then(ClientCommandManager.literal((String)presetTime.name().toLowerCase(Locale.ROOT)).executes((Command)new StaticTimeSetCommand(presetTime.getTime(), mode))));
            return base;
        }

        public StaticTimeSetCommand(Long timeToSet, StaticTimeMode mode) {
            this.timeToSet = timeToSet;
            this.mode = mode;
        }

        public int run(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
            long timeTicks;
            long l = timeTicks = this.timeToSet == null ? (long)IntegerArgumentType.getInteger(ctx, (String)"time") : this.timeToSet;
            if (TimeChangerStruggleClient.cachedCycleTypeExists("statictime") || TimeChangerStruggleClient.cachedCycleTypeExists("movingtime")) {
                long timeToActuallySet;
                long totalTimeOfDay;
                boolean isMovingTime = TimeChangerStruggleClient.isCycleTypeCurrentCycle("movingtime");
                if (!TimeChangerStruggleClient.isCycleTypeCurrentCycle("statictime") && !isMovingTime) {
                    Optional<DayNightCycleBuilder> cycleBuilder = TimeChangerStruggleClient.getCurrentCycleBuilder();
                    if (TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant) {
                        Commands.sendTextToChat(ctx, style -> style.method_36139(0xFFDD44), "jugglestruggle.tcs.cmd.time.replacedto", cycleBuilder.isPresent() ? cycleBuilder.get().getTranslatableName() : class_2561.method_43471((String)"jugglestruggle.tcs.screen.switchcyclemenu.desc.using.none"), class_2561.method_43471((String)"jugglestruggle.tcs.dnt.statictime"));
                    }
                    TimeChangerStruggleClient.setTimeChanger("statictime");
                }
                StaticTime staticTime = isMovingTime ? null : (StaticTime)TimeChangerStruggleClient.getTimeChanger();
                MovingTime movingTime = isMovingTime ? (MovingTime)TimeChangerStruggleClient.getTimeChanger() : null;
                class_638 w = ((FabricClientCommandSource)ctx.getSource()).getWorld();
                long previousTimeOfDay = w.method_8532();
                switch (this.mode) {
                    case SET: {
                        totalTimeOfDay = 0L;
                        timeToActuallySet = timeTicks;
                        break;
                    }
                    case ADD: {
                        timeToActuallySet = totalTimeOfDay = (isMovingTime ? movingTime.getCachedTime() : staticTime.timeSet) + timeTicks;
                        break;
                    }
                    case REMOVE: {
                        timeToActuallySet = totalTimeOfDay = (isMovingTime ? movingTime.getCachedTime() : staticTime.timeSet) - timeTicks;
                        break;
                    }
                    default: {
                        totalTimeOfDay = 0L;
                        long l2 = timeToActuallySet = isMovingTime ? movingTime.getCachedTime() : staticTime.timeSet;
                    }
                }
                if (isMovingTime) {
                    movingTime.writePropertyValueToCycle(new LongValue("cachedTime", timeToActuallySet, null, null), DayNightCycleBasis.PropertyWriterSource.USER);
                } else {
                    staticTime.writePropertyValueToCycle(new LongValue("worldtime", timeToActuallySet, null, null), DayNightCycleBasis.PropertyWriterSource.USER);
                }
                Commands.cycleSetAndWeNeedToKnowIfWeCanDisableWorldTime();
                TimeChangerStruggleClient.config.createOrModifyDaylightCycleConfig(isMovingTime ? movingTime : staticTime, true);
                TimeChangerStruggleClient.config.writeIfModified();
                if (TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant) {
                    String starterCommand = Commands.getStarterCommand(ctx);
                    String langCmd = "jugglestruggle.tcs.cmd.time.";
                    String modeName = this.mode.name().toLowerCase(Locale.ROOT);
                    class_5250 myTimeTicks = class_2561.method_43469((String)"jugglestruggle.tcs.cmd.time.ticks", (Object[])new Object[]{timeTicks});
                    class_5250 totalTicks = class_2561.method_43469((String)"jugglestruggle.tcs.cmd.time.ticks", (Object[])new Object[]{totalTimeOfDay});
                    class_5250 prevTicks = class_2561.method_43469((String)"jugglestruggle.tcs.cmd.time.ticks", (Object[])new Object[]{previousTimeOfDay});
                    myTimeTicks.method_27694(style -> style.method_36139(0xFFDD22).method_10982(Boolean.valueOf(false)).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/%1$s time %2$s %3$s", starterCommand, modeName, timeTicks))));
                    totalTicks.method_27694(style -> style.method_36139(0xFF22DD).method_10982(Boolean.valueOf(false)).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/%1$s time set %2$s", starterCommand, totalTimeOfDay))));
                    prevTicks.method_27694(style -> style.method_36139(0x22DDFF).method_10982(Boolean.valueOf(false)).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/%1$s time set %2$s", starterCommand, previousTimeOfDay))));
                    Commands.sendTextToChat(ctx, style -> style.method_36139(0x22FF22).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.time." + modeName, myTimeTicks, totalTicks, prevTicks);
                }
                return 1;
            }
            Commands.sendTextToChat(ctx, style -> style.method_36139(0xFF2222).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.time.error.statictimenotfound", new Object[0]);
            return 0;
        }
    }

    private class CycleUseCommand
    implements Command<FabricClientCommandSource> {
        final DayNightCycleBuilder cycleToUse;

        public CycleUseCommand(DayNightCycleBuilder cycle) {
            this.cycleToUse = cycle;
        }

        public int run(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
            String langCmd = "jugglestruggle.tcs.cmd.cycle.";
            Optional<DayNightCycleBuilder> previousCycle = TimeChangerStruggleClient.getCurrentCycleBuilder();
            if (previousCycle.isPresent() && previousCycle.get().getKeyName().equals(this.cycleToUse.getKeyName())) {
                class_5250 cycleText = class_2561.method_43469((String)"jugglestruggle.tcs.cmd.cycle.cycle", (Object[])new Object[]{this.cycleToUse.getTranslatableName().method_27661().method_27694(style -> style.method_36139(0xFF22FF))});
                Commands.sendTextToChat(ctx, style -> style.method_36139(0xFF2222).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.cycle.use.error.inuse", cycleText);
                return 0;
            }
            DayNightCycleBasis createdCycle = this.cycleToUse.create();
            TimeChangerStruggleClient.setTimeChanger(createdCycle);
            TimeChangerStruggleClient.config.createOrModifyDaylightCycleConfig(createdCycle, false);
            Commands.cycleSetAndWeNeedToKnowIfWeCanDisableWorldTime();
            TimeChangerStruggleClient.config.writeIfModified();
            if (TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant) {
                class_5250 cycleText = class_2561.method_43469((String)"jugglestruggle.tcs.cmd.cycle.cycle", (Object[])new Object[]{this.cycleToUse.getTranslatableName().method_27661().method_27694(style -> style.method_36139(0xFFFF22))});
                Commands.sendTextToChat(ctx, style -> style.method_36139(0x22FF22).method_10982(Boolean.valueOf(true)), "jugglestruggle.tcs.cmd.cycle.use.success", cycleText);
            }
            return 1;
        }
    }
}

