/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.client.util.color;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractRGB {
    protected int color;
    protected int previousColor;

    public void tick() {
    }

    public int getInterpolatedColor(float delta) {
        return AbstractRGB.getInterpolatedColor(this.previousColor, this.color, delta);
    }

    public int getColor() {
        return this.color;
    }

    public int getPrevColor() {
        return this.previousColor;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setPrevColor(int color) {
        this.previousColor = color;
    }

    public static int getInterpolatedColor(int prevColor, int color, float delta) {
        int currA = color >> 24 & 0xFF;
        int currR = color >> 16 & 0xFF;
        int currG = color >> 8 & 0xFF;
        int currB = color & 0xFF;
        int prevA = prevColor >> 24 & 0xFF;
        int prevR = prevColor >> 16 & 0xFF;
        int prevG = prevColor >> 8 & 0xFF;
        int prevB = prevColor & 0xFF;
        int a = (int)((float)prevA + ((float)currA - (float)prevA) * delta);
        int r = (int)((float)prevR + ((float)currR - (float)prevR) * delta);
        int g = (int)((float)prevG + ((float)currG - (float)prevG) * delta);
        int b = (int)((float)prevB + ((float)currB - (float)prevB) * delta);
        if (a < 0) {
            a = 0;
        } else if (a > 255) {
            a = 255;
        }
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }
}

