/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jugglestruggle.timechangerstruggle.client.TimeChangerStruggleClient;
import jugglestruggle.timechangerstruggle.client.config.property.FancySectionProperty;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBuilder;
import org.apache.commons.compress.utils.IOUtils;

public class Configuration {
    private JsonObject configData;
    private File configFile;
    private Gson configDataBaseGson;

    public Configuration(File configFile) {
        this.configFile = configFile;
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().setLenient();
        this.configDataBaseGson = builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        block14: {
            boolean shouldPopulate;
            FileReader reader;
            block12: {
                block13: {
                    boolean populateConfig = false;
                    boolean populateNewFile = false;
                    if (this.configFile == null) {
                        populateConfig = true;
                    } else {
                        try {
                            populateConfig = !this.configFile.exists() || !this.configFile.canRead();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            populateConfig = true;
                        }
                    }
                    if (!populateConfig) break block13;
                    this.checkAndPopulateConfigData();
                    if (populateNewFile) {
                        this.write();
                    }
                    break block14;
                }
                reader = null;
                shouldPopulate = false;
                try {
                    reader = new FileReader(this.configFile);
                    JsonElement parsedElement = JsonParser.parseReader((Reader)reader);
                    if (parsedElement != null && parsedElement.isJsonObject()) {
                        String activeDaylightChangerText;
                        this.configData = parsedElement.getAsJsonObject();
                        this.checkAndPopulateConfigData();
                        TimeChangerStruggleClient.dateOverTicks = this.configData.get("dateOverTicks").getAsBoolean();
                        TimeChangerStruggleClient.worldTime = this.configData.get("worldTime").getAsBoolean();
                        TimeChangerStruggleClient.smoothButterCycle = this.configData.get("smoothButterCycle").getAsBoolean();
                        TimeChangerStruggleClient.disableNightVisionEffect = this.configData.get("disableNightVisionEffect").getAsBoolean();
                        TimeChangerStruggleClient.applyOnPropertyListValueUpdate = this.configData.get("applyOnPropertyListValueUpdate").getAsBoolean();
                        TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant = this.configData.get("commandFeedbackOnLessImportant").getAsBoolean();
                        TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage = this.configData.get("disableWorldTimeOnCycleUsage").getAsBoolean();
                        TimeChangerStruggleClient.allowWorldChangeCyclesToWriteToDisk = this.configData.get("allowWorldChangeCyclesToWriteToDisk").getAsBoolean();
                        JsonElement elem = this.configData.get("activeDaylightChanger");
                        if (elem != null && elem.isJsonPrimitive() && !(activeDaylightChangerText = elem.getAsString()).isEmpty() && !activeDaylightChangerText.isBlank()) {
                            TimeChangerStruggleClient.setTimeChanger(elem.getAsString());
                            this.createOrModifyDaylightCycleConfig(TimeChangerStruggleClient.getTimeChanger(), false);
                        }
                        break block12;
                    }
                    shouldPopulate = true;
                }
                catch (FileNotFoundException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)reader);
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
            if (shouldPopulate) {
                this.checkAndPopulateConfigData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        block7: {
            this.configData.addProperty("worldTime", Boolean.valueOf(TimeChangerStruggleClient.worldTime));
            this.configData.addProperty("dateOverTicks", Boolean.valueOf(TimeChangerStruggleClient.dateOverTicks));
            this.configData.addProperty("smoothButterCycle", Boolean.valueOf(TimeChangerStruggleClient.smoothButterCycle));
            this.configData.addProperty("disableNightVisionEffect", Boolean.valueOf(TimeChangerStruggleClient.disableNightVisionEffect));
            this.configData.addProperty("applyOnPropertyListValueUpdate", Boolean.valueOf(TimeChangerStruggleClient.applyOnPropertyListValueUpdate));
            this.configData.addProperty("commandFeedbackOnLessImportant", Boolean.valueOf(TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant));
            this.configData.addProperty("disableWorldTimeOnCycleUsage", Boolean.valueOf(TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage));
            this.configData.addProperty("allowWorldChangeCyclesToWriteToDisk", Boolean.valueOf(TimeChangerStruggleClient.allowWorldChangeCyclesToWriteToDisk));
            this.configData.addProperty("activeDaylightChanger", TimeChangerStruggleClient.getTimeChangerKey() == null ? "" : TimeChangerStruggleClient.getTimeChangerKey());
            if (this.configFile == null) {
                return;
            }
            FileWriter writer = null;
            JsonWriter jsonWriter = null;
            try {
                if (this.configFile.exists()) {
                    this.configFile.delete();
                }
                this.configFile.createNewFile();
                writer = new FileWriter(this.configFile);
                jsonWriter = new JsonWriter((Writer)writer);
                this.configDataBaseGson.toJson((JsonElement)this.configData, jsonWriter);
                IOUtils.closeQuietly((Closeable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly(jsonWriter);
            }
            IOUtils.closeQuietly((Closeable)jsonWriter);
        }
    }

    public void writeIfModified() {
        if (!(TimeChangerStruggleClient.worldTime && !TimeChangerStruggleClient.dateOverTicks && !TimeChangerStruggleClient.applyOnPropertyListValueUpdate && TimeChangerStruggleClient.smoothButterCycle && TimeChangerStruggleClient.disableNightVisionEffect && TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant && TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage && TimeChangerStruggleClient.allowWorldChangeCyclesToWriteToDisk && TimeChangerStruggleClient.getTimeChangerKey() == null)) {
            this.write();
        }
    }

    private void checkAndPopulateConfigData() {
        if (this.configData == null) {
            this.configData = new JsonObject();
        }
        Configuration.checkOrCreateProperty(this.configData, "worldTime", TimeChangerStruggleClient.worldTime);
        Configuration.checkOrCreateProperty(this.configData, "dateOverTicks", TimeChangerStruggleClient.dateOverTicks);
        Configuration.checkOrCreateProperty(this.configData, "smoothButterCycle", TimeChangerStruggleClient.smoothButterCycle);
        Configuration.checkOrCreateProperty(this.configData, "disableNightVisionEffect", TimeChangerStruggleClient.disableNightVisionEffect);
        Configuration.checkOrCreateProperty(this.configData, "applyOnPropertyListValueUpdate", TimeChangerStruggleClient.applyOnPropertyListValueUpdate);
        Configuration.checkOrCreateProperty(this.configData, "commandFeedbackOnLessImportant", TimeChangerStruggleClient.commandsCommandFeedbackOnLessImportant);
        Configuration.checkOrCreateProperty(this.configData, "disableWorldTimeOnCycleUsage", TimeChangerStruggleClient.commandsDisableWorldTimeOnCycleUsage);
        Configuration.checkOrCreateProperty(this.configData, "allowWorldChangeCyclesToWriteToDisk", TimeChangerStruggleClient.allowWorldChangeCyclesToWriteToDisk);
        Configuration.checkOrCreateProperty(this.configData, "activeDaylightChanger", TimeChangerStruggleClient.getTimeChangerKey() == null ? "" : TimeChangerStruggleClient.getTimeChangerKey());
        if (TimeChangerStruggleClient.getTimeChanger() != null) {
            this.createOrModifyDaylightCycleConfig(TimeChangerStruggleClient.getTimeChanger(), false);
        }
    }

    public <B extends BaseProperty<B, V>, V> void createOrModifyDaylightCycleConfig(DayNightCycleBasis cycle, boolean overrideConfigValues) {
        Optional<DayNightCycleBuilder> builder = TimeChangerStruggleClient.getCachedCycleBuilderByClass(cycle.getBuilderClass());
        if (!builder.isPresent()) {
            return;
        }
        DayNightCycleBuilder cycleBuilder = builder.get();
        String cycleKeyName = cycleBuilder.getKeyName();
        Set<BaseProperty<?, ?>> props = cycle.createProperties();
        if (props == null || props.isEmpty()) {
            JsonObject obj;
            JsonElement cyclesSection = this.configData.get("cyclesSection");
            if (cyclesSection instanceof JsonObject && (obj = (JsonObject)cyclesSection).has(cycleKeyName)) {
                obj.remove(cycleKeyName);
            }
            return;
        }
        Map.Entry<JsonObject, Boolean> cycleSectEntry = this.getOrCreateConfigSection(cycleKeyName);
        JsonObject section = cycleSectEntry.getKey();
        boolean sectionCreated = cycleSectEntry.getValue();
        for (BaseProperty<?, ?> prop : props) {
            if (prop instanceof FancySectionProperty) continue;
            String propKey = prop.property();
            boolean hasPropEntry = section.has(propKey);
            if (!overrideConfigValues && sectionCreated && hasPropEntry) {
                prop.readFromJson(section.get(propKey));
                cycle.writePropertyValueToCycle(prop, DayNightCycleBasis.PropertyWriterSource.FROM_JSON);
                continue;
            }
            JsonElement propElem = prop.writeToJson();
            if (propElem == null) {
                if (!overrideConfigValues || !hasPropEntry) continue;
                section.remove(propKey);
                continue;
            }
            section.add(propKey, propElem);
        }
    }

    public Map.Entry<JsonObject, Boolean> getOrCreateConfigSection(String propertyName) {
        JsonElement propertyElement;
        JsonElement sections = this.configData.get("cyclesSection");
        if (sections == null || !sections.isJsonObject()) {
            sections = new JsonObject();
            this.configData.add("cyclesSection", sections);
        }
        if ((propertyElement = sections.getAsJsonObject().get(propertyName)) != null && propertyElement.isJsonObject()) {
            return new AbstractMap.SimpleImmutableEntry<JsonObject, Boolean>(propertyElement.getAsJsonObject(), true);
        }
        JsonObject createdSection = new JsonObject();
        sections.getAsJsonObject().add(propertyName, (JsonElement)createdSection);
        return new AbstractMap.SimpleImmutableEntry<JsonObject, Boolean>(createdSection, false);
    }

    public static <V> void checkOrCreateProperty(JsonObject section, String propertyName, V defaultValue) {
        boolean expectingPrimitive;
        JsonElement propertyElement = section.get(propertyName);
        boolean bl = expectingPrimitive = defaultValue instanceof Number || defaultValue instanceof String || defaultValue instanceof Boolean;
        if (propertyElement == null) {
            if (expectingPrimitive) {
                Configuration.addExpectedPrimitive(section, propertyName, defaultValue);
            }
        } else if (expectingPrimitive && propertyElement.isJsonPrimitive()) {
            JsonPrimitive primitive = propertyElement.getAsJsonPrimitive();
            boolean removeAndAdd = false;
            if (primitive.isBoolean()) {
                removeAndAdd = defaultValue instanceof Number || defaultValue instanceof String;
            } else if (primitive.isNumber()) {
                removeAndAdd = defaultValue instanceof String || defaultValue instanceof Boolean;
            } else if (primitive.isString()) {
                boolean bl2 = removeAndAdd = defaultValue instanceof Boolean || defaultValue instanceof Number;
            }
            if (removeAndAdd) {
                section.remove(propertyName);
                Configuration.addExpectedPrimitive(section, propertyName, defaultValue);
            }
        }
    }

    private static <V> JsonPrimitive addExpectedPrimitive(JsonObject section, String propertyName, V value) {
        JsonPrimitive primitive = value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : new JsonPrimitive((String)value));
        section.add(propertyName, (JsonElement)primitive);
        return primitive;
    }
}

