/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import jugglestruggle.timechangerstruggle.config.property.BaseNumber;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class DoubleValue
extends BaseNumber<Double> {
    public DoubleValue(String propertyName, double defaultValue, Double min, Double max) {
        super(propertyName, defaultValue, min, max);
    }

    @Override
    public boolean isWithinRange() {
        Double value = (Double)this.get();
        return value != null && value >= (Double)this.getMin() && value <= (Double)this.getMax();
    }

    @Override
    public Double parseStringNumber(String toParse) {
        try {
            return Double.parseDouble(toParse);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public ArgumentType<Double> onCommandOptionGetArgType() {
        if (this.min == null || this.max == null) {
            return DoubleArgumentType.doubleArg();
        }
        return DoubleArgumentType.doubleArg((double)((Double)this.min), (double)((Double)this.max));
    }

    @Override
    public int onCommandOptionWithValueExecute(CommandContext<FabricClientCommandSource> ctx) {
        this.set(DoubleArgumentType.getDouble(ctx, (String)"value"));
        return 3;
    }
}

