/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.config.property;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import jugglestruggle.timechangerstruggle.config.property.BaseNumber;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class FloatValue
extends BaseNumber<Float> {
    public FloatValue(String propertyName, float defaultValue, Float min, Float max) {
        super(propertyName, Float.valueOf(defaultValue), min, max);
    }

    @Override
    public boolean isWithinRange() {
        Float value = (Float)this.get();
        return value != null && value.floatValue() >= ((Float)this.getMin()).floatValue() && value.floatValue() <= ((Float)this.getMax()).floatValue();
    }

    @Override
    public Float parseStringNumber(String toParse) {
        try {
            return Float.valueOf(Float.parseFloat(toParse));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public ArgumentType<Float> onCommandOptionGetArgType() {
        if (this.min == null || this.max == null) {
            return FloatArgumentType.floatArg();
        }
        return FloatArgumentType.floatArg((float)((Float)this.min).floatValue(), (float)((Float)this.max).floatValue());
    }

    @Override
    public int onCommandOptionWithValueExecute(CommandContext<FabricClientCommandSource> ctx) {
        this.set(Float.valueOf(FloatArgumentType.getFloat(ctx, (String)"value")));
        return 3;
    }
}

