/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.daynight.type;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import jugglestruggle.timechangerstruggle.client.config.property.FancySectionProperty;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import jugglestruggle.timechangerstruggle.config.property.EnumValue;
import jugglestruggle.timechangerstruggle.config.property.LongValue;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import jugglestruggle.timechangerstruggle.daynight.DayNightGetterType;
import jugglestruggle.timechangerstruggle.util.EasingType;
import jugglestruggle.timechangerstruggle.util.Easings;
import net.minecraft.class_2561;
import net.minecraft.class_638;

public abstract class MovingTimeBasis
implements DayNightCycleBasis {
    protected static final String PROPERTIES_BASIS_KEY = "jugglestruggle.tcs.dnt.movingtimebasis.properties.";
    protected long cachedTime = 0L;
    protected long previousCachedTime = 0L;
    protected long previousInterpolatedTime = 0L;
    protected long nextInterpolatedTime = 0L;
    protected long ticksPassed = 1L;
    protected long ticksUntilNextCall = 40L;
    protected Easings easingBetweenTicks = Easings.LINEAR;
    protected EasingType easingType = EasingType.BETWEEN;

    public abstract void updateInterpolation();

    @Override
    public void tick() {
        if (this.ticksPassed >= this.ticksUntilNextCall) {
            this.ticksPassed = 0L;
            this.updateCall();
        } else {
            if (this.easingBetweenTicks != null) {
                double animationDelta = (double)this.ticksPassed / (double)this.ticksUntilNextCall;
                double result = this.easingBetweenTicks.value(this.easingType, animationDelta);
                this.previousCachedTime = this.cachedTime;
                this.cachedTime = (long)((double)this.previousInterpolatedTime + ((double)this.nextInterpolatedTime - (double)this.previousInterpolatedTime) * result);
            }
            ++this.ticksPassed;
        }
    }

    public void updateCall() {
        this.previousInterpolatedTime = this.nextInterpolatedTime;
        this.updateInterpolation();
        this.previousCachedTime = this.cachedTime;
        this.cachedTime = this.previousInterpolatedTime;
    }

    @Override
    public long getModifiedTime(class_638 world, DayNightGetterType executor, boolean previous) {
        return previous ? this.previousCachedTime : this.cachedTime;
    }

    @Override
    public long getCachedTime() {
        return this.cachedTime;
    }

    protected Set<BaseProperty<?, ?>> createSnapshotProperties(boolean withEasings) {
        ImmutableSet.Builder props = ImmutableSet.builderWithExpectedSize((int)(withEasings ? 12 : 10));
        props.add((Object)this.getMovingTimeBasisCategory());
        props.add((Object)this.getCachedTimeProp());
        props.add((Object)this.getPrevCachedTimeProp());
        props.add((Object)this.getPrevInterpolatedTimeProp());
        props.add((Object)this.getNextInterpolatedTimeProp());
        props.add((Object)this.getTicksPassedProp());
        props.add((Object)this.getTicksUntilNextCallProp());
        if (withEasings) {
            props.add(this.getEasingBetweenTicksProp());
            props.add(this.getEasingTypeBetweenTicksProp());
        }
        return props.build();
    }

    public FancySectionProperty getMovingTimeBasisCategory() {
        return new DefaultFilteredPropsSection("cached", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.dnt.movingtimebasis.properties.basis"));
    }

    protected LongValue getCachedTimeProp() {
        return new LongValue("cachedTime", this.cachedTime, null, null);
    }

    protected LongValue getPrevCachedTimeProp() {
        return new LongValue("previousCachedTime", this.previousCachedTime, null, null);
    }

    protected LongValue getPrevInterpolatedTimeProp() {
        return new LongValue("prevInterpolatedTime", this.previousInterpolatedTime, null, null);
    }

    protected LongValue getNextInterpolatedTimeProp() {
        return new LongValue("nextInterpolatedTime", this.nextInterpolatedTime, null, null);
    }

    protected LongValue getTicksPassedProp() {
        return new LongValue("ticksPassed", this.ticksPassed, 0L, Long.MAX_VALUE);
    }

    protected LongValue getTicksUntilNextCallProp() {
        return new LongValue("ticksUntilNextUpdate", this.ticksUntilNextCall, 0L, Long.MAX_VALUE);
    }

    protected EnumValue<Easings> getEasingBetweenTicksProp() {
        return new EnumValue("easingBetweenTicks", (Enum)this.easingBetweenTicks, (Enum)Easings.LINEAR, (Enum[])Easings.values()).setVTT(easing -> easing.getFormattedText());
    }

    protected EnumValue<EasingType> getEasingTypeBetweenTicksProp() {
        return new EnumValue("easingTypeBetweenTicks", (Enum)this.easingType, (Enum)EasingType.BETWEEN, (Enum[])EasingType.values()).setVTT(easing -> easing.getFormattedText());
    }

    public void writePropertyValueToCycleForBasis(BaseProperty<?, ?> property, DayNightCycleBasis.PropertyWriterSource writer) {
        String belongingKey = property.property();
        if (property instanceof LongValue) {
            LongValue prop = (LongValue)property;
            long v = (Long)prop.get();
            switch (belongingKey) {
                case "cachedTime": {
                    if (writer == DayNightCycleBasis.PropertyWriterSource.USER) {
                        this.previousCachedTime = this.cachedTime = v;
                        this.nextInterpolatedTime = this.cachedTime;
                        this.previousInterpolatedTime = this.cachedTime;
                        break;
                    }
                    this.cachedTime = v;
                    break;
                }
                case "previousCachedTime": {
                    if (writer != DayNightCycleBasis.PropertyWriterSource.FROM_JSON) break;
                    this.previousCachedTime = v;
                    break;
                }
                case "prevInterpolatedTime": {
                    if (writer != DayNightCycleBasis.PropertyWriterSource.FROM_JSON) break;
                    this.previousInterpolatedTime = v;
                    break;
                }
                case "nextInterpolatedTime": {
                    if (writer != DayNightCycleBasis.PropertyWriterSource.FROM_JSON) break;
                    this.nextInterpolatedTime = v;
                    break;
                }
                case "ticksPassed": {
                    this.ticksPassed = v;
                    break;
                }
                case "ticksUntilNextUpdate": {
                    this.ticksUntilNextCall = v;
                }
            }
        } else if (property instanceof EnumValue) {
            EnumValue prop = (EnumValue)property;
            if (prop.getDefaultValue() instanceof Easings) {
                if (belongingKey == "easingBetweenTicks") {
                    this.easingBetweenTicks = (Easings)prop.get();
                }
            } else if (prop.getDefaultValue() instanceof EasingType && belongingKey == "easingTypeBetweenTicks") {
                this.easingType = (EasingType)prop.get();
            }
        }
    }

    protected class DefaultFilteredPropsSection
    extends FancySectionProperty {
        public DefaultFilteredPropsSection(String property, class_2561 value) {
            super(property, value);
        }

        @Override
        public boolean shouldCreatePropertyConfigElem(int sectionPropIndex, BaseProperty<?, ?> prop) {
            return prop.property().equals("cachedTime") || prop.property().equals("previousCachedTime");
        }
    }
}

