/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.daynight.type;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import jugglestruggle.timechangerstruggle.client.config.property.FancySectionProperty;
import jugglestruggle.timechangerstruggle.client.config.property.WidgetOnlyProperty;
import jugglestruggle.timechangerstruggle.client.config.widget.WidgetConfigInterface;
import jugglestruggle.timechangerstruggle.client.screen.TimeChangerScreen;
import jugglestruggle.timechangerstruggle.client.widget.ButtonWidgetEx;
import jugglestruggle.timechangerstruggle.config.property.BaseProperty;
import jugglestruggle.timechangerstruggle.config.property.BooleanValue;
import jugglestruggle.timechangerstruggle.config.property.EnumValue;
import jugglestruggle.timechangerstruggle.config.property.LongValue;
import jugglestruggle.timechangerstruggle.config.property.StringValue;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBuilder;
import jugglestruggle.timechangerstruggle.daynight.type.MovingTimeBasis;
import jugglestruggle.timechangerstruggle.util.EasingType;
import jugglestruggle.timechangerstruggle.util.Easings;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class RandomizedTime
extends MovingTimeBasis {
    static final String PROPERTIES_KEY = "jugglestruggle.tcs.dnt.randomizer.properties.";
    public String startingSeed;
    public long minimumRandomTime = 0L;
    public long maximumRandomTime = 24000L;
    public boolean randomizeTicksUntilNextRNG = false;
    public long ticksUntilNextRNGMin = 1L;
    public long ticksUntilNextRNGMax = 24000L;
    public boolean randomizeEasingBetweenTicks = false;
    public boolean randomizeEasingTypeBetweenTicks = false;
    public long ticksUntilNextRNGBasis = 40L;
    public Easings easingBetweenTicksBasis = Easings.LINEAR;
    public EasingType easingTypeBetweenTicksBasis = EasingType.BETWEEN;
    public Random rng;
    protected boolean hasTickUpdateOccured = false;

    public RandomizedTime(String startingSeed, boolean applyRNG) {
        this.createRNG(startingSeed, applyRNG);
    }

    private void createRNG(String startingSeed, boolean applyRNG) {
        if (startingSeed == null || startingSeed.length() == 0) {
            this.rng = new Random(System.currentTimeMillis());
        } else {
            int seed = 0;
            try {
                seed = Integer.parseInt(startingSeed);
            }
            catch (Exception e) {
                seed = startingSeed.hashCode();
            }
            this.rng = new Random(seed);
            this.startingSeed = startingSeed;
        }
        if (applyRNG) {
            this.updateCall();
            this.updateCall();
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.hasTickUpdateOccured = true;
    }

    @Override
    public void updateInterpolation() {
        this.genNextRandomTime();
        if (this.randomizeTicksUntilNextRNG) {
            this.genTicksUntilNextRNG();
        }
        if (this.randomizeEasingBetweenTicks) {
            this.genRandomizedEasing();
        }
        if (this.randomizeEasingTypeBetweenTicks) {
            this.genRandomizedEasingType();
        }
    }

    private long genNextLongRNG(Random rng, long minRand, long maxRand) {
        if (minRand < 0L) {
            minRand = 0L;
        }
        if (maxRand < 0L) {
            maxRand = 1L;
        } else if (maxRand != Long.MAX_VALUE) {
            ++maxRand;
        }
        return rng.nextLong(minRand, maxRand);
    }

    private void shouldGenTicksUntilNextRNG() {
        if (this.ticksUntilNextCall < this.ticksUntilNextRNGMin || this.ticksUntilNextCall > this.ticksUntilNextRNGMax) {
            this.genTicksUntilNextRNG();
        }
    }

    private void genNextRandomTime() {
        this.nextInterpolatedTime = this.genNextLongRNG(this.rng, this.minimumRandomTime, this.maximumRandomTime);
    }

    private void genTicksUntilNextRNG() {
        this.ticksUntilNextCall = this.genNextLongRNG(this.rng, this.ticksUntilNextRNGMin, this.ticksUntilNextRNGMax);
    }

    private void genRandomizedEasing() {
        Easings easingToUse = (Easings)this.genRandomizedEnum(Easings.values(), easing -> easing.canBeRandomlyUsed());
        if (easingToUse != null) {
            this.easingBetweenTicks = easingToUse;
        }
    }

    private void genRandomizedEasingType() {
        EasingType easingToUse = (EasingType)this.genRandomizedEnum(EasingType.values(), null);
        if (easingToUse != null) {
            this.easingType = easingToUse;
        }
    }

    private <E extends Enum<E>> E genRandomizedEnum(E[] types, Predicate<E> canBeUsedIfSelected) {
        Object typeToUse = null;
        int typesSize = types.length;
        for (int tries = 0; tries <= 5; tries = (int)((byte)(tries + 1))) {
            int index = this.rng.nextInt(typesSize);
            if (index < 0 || index >= typesSize) continue;
            typeToUse = types[index];
            if (canBeUsedIfSelected == null || canBeUsedIfSelected.test(typeToUse)) break;
        }
        return (E)typeToUse;
    }

    @Override
    public Class<?> getBuilderClass() {
        return Builder.class;
    }

    @Override
    public boolean saveOnWorldChange() {
        return true;
    }

    @Override
    public Set<BaseProperty<?, ?>> createProperties() {
        ImmutableSet.Builder props = ImmutableSet.builderWithExpectedSize((int)12);
        props.add((Object)new SeedSectionProperty());
        props.add((Object)new StringValue("startingSeed", this.startingSeed == null ? "" : this.startingSeed).setEmptyTextAllowance(true));
        props.add((Object)new WidgetOnlyProperty("resetSeedToInitial", this::onResetSeedToInitialCreateButton));
        props.add((Object)new FancySectionProperty("daylightrandomtime", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.dnt.randomizer.properties.daylightrandomtime")));
        props.add((Object)new LongValue("minimumRandomTime", this.minimumRandomTime, 0L, Long.MAX_VALUE));
        props.add((Object)new LongValue("maximumRandomTime", this.maximumRandomTime, 0L, Long.MAX_VALUE));
        props.add((Object)new FancySectionProperty("ticksuntilnextrng", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.dnt.randomizer.properties.ticksuntilnextrng")));
        props.add((Object)new BooleanValue("randomizeTicksUntilNextRNG", this.randomizeTicksUntilNextRNG));
        props.add((Object)new LongValue("ticksUntilNextRNG", this.ticksUntilNextRNGBasis, 1L, Long.MAX_VALUE));
        props.add((Object)new LongValue("ticksUntilNextRNGMin", this.ticksUntilNextRNGMin, 1L, Long.MAX_VALUE));
        props.add((Object)new LongValue("ticksUntilNextRNGMax", this.ticksUntilNextRNGMax, 1L, Long.MAX_VALUE));
        props.add((Object)new FancySectionProperty("easings", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.dnt.randomizer.properties.easings")));
        props.add((Object)new BooleanValue("randomizeEasingBetweenTicks", this.randomizeEasingBetweenTicks));
        props.add(new EnumValue("easingBetweenTicks", (Enum)this.easingBetweenTicksBasis, (Enum)Easings.LINEAR, (Enum[])Easings.values()).setVTT(easing -> easing.getFormattedText()));
        props.add((Object)new BooleanValue("randomizeEasingTypeBetweenTicks", this.randomizeEasingTypeBetweenTicks));
        props.add(new EnumValue("easingTypeBetweenTicks", (Enum)this.easingTypeBetweenTicksBasis, (Enum)EasingType.BETWEEN, (Enum[])EasingType.values()).setVTT(easing -> easing.getFormattedText()));
        props.addAll(this.createSnapshotProperties(false));
        return props.build();
    }

    @Override
    public void writePropertyValueToCycle(BaseProperty<?, ?> property, DayNightCycleBasis.PropertyWriterSource writer) {
        String belongingKey = property.property();
        if (property instanceof StringValue) {
            StringValue prop = (StringValue)property;
            if (belongingKey.equals("startingSeed")) {
                this.startingSeed = (String)prop.get();
                if (!this.hasTickUpdateOccured) {
                    this.createRNG(this.startingSeed, true);
                }
                return;
            }
        } else if (property instanceof LongValue) {
            LongValue prop = (LongValue)property;
            switch (belongingKey) {
                case "minimumRandomTime": {
                    this.minimumRandomTime = (Long)prop.get();
                    return;
                }
                case "maximumRandomTime": {
                    this.maximumRandomTime = (Long)prop.get();
                    return;
                }
                case "ticksUntilNextRNG": {
                    this.ticksUntilNextRNGBasis = (Long)prop.get();
                    if (!this.randomizeTicksUntilNextRNG) {
                        this.ticksUntilNextCall = this.ticksUntilNextRNGBasis;
                    }
                    return;
                }
                case "ticksUntilNextRNGMin": 
                case "ticksUntilNextRNGMax": {
                    if (belongingKey.equals("ticksUntilNextRNGMax")) {
                        this.ticksUntilNextRNGMax = (Long)prop.get();
                    } else {
                        this.ticksUntilNextRNGMin = (Long)prop.get();
                    }
                    if (this.randomizeTicksUntilNextRNG) {
                        this.shouldGenTicksUntilNextRNG();
                    } else {
                        this.easingBetweenTicks = this.easingBetweenTicksBasis;
                    }
                    return;
                }
            }
        } else if (property instanceof BooleanValue) {
            BooleanValue prop = (BooleanValue)property;
            switch (belongingKey) {
                case "randomizeTicksUntilNextRNG": {
                    this.randomizeTicksUntilNextRNG = (Boolean)prop.get();
                    if (this.randomizeTicksUntilNextRNG) {
                        this.shouldGenTicksUntilNextRNG();
                    } else {
                        this.ticksUntilNextCall = this.ticksUntilNextRNGBasis;
                    }
                    return;
                }
                case "randomizeEasingBetweenTicks": {
                    this.randomizeEasingBetweenTicks = (Boolean)prop.get();
                    if (this.randomizeEasingBetweenTicks) {
                        this.genRandomizedEasing();
                    } else {
                        this.easingBetweenTicks = this.easingBetweenTicksBasis;
                    }
                    return;
                }
                case "randomizeEasingTypeBetweenTicks": {
                    this.randomizeEasingTypeBetweenTicks = (Boolean)prop.get();
                    if (this.randomizeEasingTypeBetweenTicks) {
                        this.genRandomizedEasingType();
                    } else {
                        this.easingType = this.easingTypeBetweenTicksBasis;
                    }
                    return;
                }
            }
        } else if (property instanceof EnumValue) {
            EnumValue prop = (EnumValue)property;
            if (prop.getDefaultValue() instanceof Easings) {
                switch (belongingKey) {
                    case "easingBetweenTicks": {
                        this.easingBetweenTicksBasis = (Easings)prop.get();
                        if (!this.randomizeEasingBetweenTicks) {
                            this.easingBetweenTicks = this.easingBetweenTicksBasis;
                        }
                        return;
                    }
                }
            } else if (prop.getDefaultValue() instanceof EasingType) {
                switch (belongingKey) {
                    case "easingTypeBetweenTicks": {
                        this.easingTypeBetweenTicksBasis = (EasingType)prop.get();
                        if (!this.randomizeEasingTypeBetweenTicks) {
                            this.easingType = this.easingTypeBetweenTicksBasis;
                        }
                        return;
                    }
                }
            }
        }
        this.writePropertyValueToCycleForBasis(property, writer);
    }

    @Override
    public WidgetConfigInterface<?, ?>[][] rearrangeSectionElements(Map.Entry<FancySectionProperty, List<WidgetConfigInterface<?, ?>>> entry, int elementsPerRow) {
        WidgetConfigInterface<?, ?>[][] widgetConfigInterfaceArray;
        List<WidgetConfigInterface<?, ?>> elements = entry.getValue();
        switch (entry.getKey().property()) {
            case "ticksuntilnextrng": {
                WidgetConfigInterface[][] widgetConfigInterfaceArrayArray = new WidgetConfigInterface[2][];
                widgetConfigInterfaceArrayArray[0] = new WidgetConfigInterface[]{elements.get(0), elements.get(1)};
                widgetConfigInterfaceArray = widgetConfigInterfaceArrayArray;
                widgetConfigInterfaceArrayArray[1] = new WidgetConfigInterface[]{elements.get(2), elements.get(3)};
                break;
            }
            default: {
                widgetConfigInterfaceArray = super.rearrangeSectionElements(entry, elementsPerRow);
            }
        }
        return widgetConfigInterfaceArray;
    }

    protected ResetSeedButton onResetSeedToInitialCreateButton(TimeChangerScreen screen, FancySectionProperty section, WidgetOnlyProperty prop) {
        return new ResetSeedButton(this, screen, prop);
    }

    protected void onResetSeedPropClicked(class_4185 b) {
        this.createRNG(this.startingSeed, true);
    }

    public static class Builder
    implements DayNightCycleBuilder {
        @Override
        public DayNightCycleBasis create() {
            return new RandomizedTime(null, false);
        }

        @Override
        public String getKeyName() {
            return "randomizers";
        }

        @Override
        public class_2561 getTranslatableName() {
            return class_2561.method_43471((String)"jugglestruggle.tcs.dnt.randomizer");
        }

        @Override
        public class_2561 getTranslatableDescription() {
            return class_2561.method_43471((String)"jugglestruggle.tcs.dnt.randomizer.description");
        }

        @Override
        public boolean hasOptionsToEdit() {
            return true;
        }
    }

    class SeedSectionProperty
    extends FancySectionProperty {
        public SeedSectionProperty() {
            super("seed", (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.dnt.randomizer.properties.seed"));
        }

        @Override
        public boolean shouldCreatePropertyConfigElem(int sectionPropIndex, BaseProperty<?, ?> prop) {
            return !prop.property().equals("currentRngSeed");
        }
    }

    protected class ResetSeedButton
    extends ButtonWidgetEx
    implements WidgetOnlyProperty.WidgetInterface {
        final RandomizedTime instance;
        final WidgetOnlyProperty prop;

        public ResetSeedButton(RandomizedTime instance, TimeChangerScreen screen, WidgetOnlyProperty prop) {
            super(18, 18, (class_2561)class_2561.method_43471((String)"jugglestruggle.tcs.dnt.randomizer.properties.seed.resettoinitial"), screen.getTextRenderer(), instance::onResetSeedPropClicked);
            this.instance = instance;
            this.prop = prop;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public WidgetOnlyProperty getProperty() {
            return this.prop;
        }

        @Override
        public Object getInitialValue() {
            return this.prop.getDefaultValue();
        }

        @Override
        public void setInitialValue(Object value) {
        }

        @Override
        public void forceSetWidgetValueToDefault(boolean justInitial) {
        }

        @Override
        public void setPropertyValueToDefault(boolean justInitial) {
        }

        @Override
        public boolean isDefaultValue() {
            return true;
        }
    }
}

