/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jugglestruggle.timechangerstruggle.client.TimeChangerStruggleClient;
import jugglestruggle.timechangerstruggle.daynight.DayNightCycleBasis;
import net.minecraft.class_1937;

public final class DaylightUtils {
    public static final double ONE_HOUR = 1000.0;
    public static final double ONE_MINUTE = 16.666666666666668;
    public static final double ONE_SECOND = 0.2777777777777778;
    public static final double ONE_DAY = 24000.0;
    public static final double ONE_WEEK = 168000.0;
    public static final double ONE_LUNAR_CYCLE = 192000.0;
    public static final double ONE_YEAR = 8760000.0;
    public static final int SUNRISE = 0;
    public static final int MIDDAY = 6000;
    public static final int SUNSET = 12000;
    public static final int MIDNIGHT = 18000;
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("DD yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    public static Date minecraftTicksToDate(long ticks, boolean addDay) {
        long newTicks = ticks - 18000L + 24000L;
        long days = newTicks / 24000L;
        newTicks = (long)((double)newTicks - (double)days * 24000.0);
        int hours = (int)(newTicks / 1000L);
        newTicks = (long)((double)newTicks - (double)hours * 1000.0);
        int minutes = (int)(newTicks / 16L);
        newTicks = (long)((double)newTicks - (double)minutes * 16.666666666666668);
        int seconds = (int)((double)newTicks / 0.2777777777777778);
        Calendar cal = Calendar.getInstance(Locale.ENGLISH);
        cal.setLenient(true);
        if (addDay) {
            ++days;
        }
        cal.set(0, 0, (int)days, hours, minutes, seconds);
        return cal.getTime();
    }

    public static String getParsedTime(class_1937 world, boolean dateOverTicks) {
        boolean addDay;
        long ticksToParse;
        if (TimeChangerStruggleClient.useWorldTime()) {
            ticksToParse = world.method_8532();
            addDay = true;
        } else {
            DayNightCycleBasis cycle = TimeChangerStruggleClient.getTimeChanger();
            ticksToParse = cycle.getCachedTime();
            addDay = cycle.shouldAddDayForDateDisplay();
        }
        return dateOverTicks ? DATE_FORMAT.format(DaylightUtils.minecraftTicksToDate(ticksToParse, addDay)) : "" + ticksToParse;
    }
}

