/*
 * Decompiled with CFR 0.152.
 */
package jugglestruggle.timechangerstruggle.util;

import java.util.Locale;
import jugglestruggle.timechangerstruggle.util.EasingType;
import jugglestruggle.timechangerstruggle.util.InterchangeableFunction;
import net.minecraft.class_2561;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Easings implements InterchangeableFunction<Easings, String>
{
    LINEAR{

        @Override
        public double value(EasingType type, double delta) {
            return delta;
        }
    }
    ,
    FLOOR{

        @Override
        public double value(EasingType type, double delta) {
            return Math.floor(delta);
        }
    }
    ,
    CEILING{

        @Override
        public double value(EasingType type, double delta) {
            return Math.ceil(delta);
        }
    }
    ,
    SINE{

        @Override
        public double value(EasingType type, double delta) {
            delta *= Math.PI;
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> 1.0 - Math.cos(delta / 2.0);
                case EasingType.OUT -> Math.sin(delta / 2.0);
                case EasingType.BETWEEN -> -(Math.cos(delta / 2.0) - 1.0) / 2.0;
            };
        }
    }
    ,
    QUAD{

        @Override
        public double value(EasingType type, double delta) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> delta * delta;
                case EasingType.OUT -> 1.0 - (1.0 - delta) * (1.0 - delta);
                case EasingType.BETWEEN -> delta < 0.5 ? 2.0 * delta * delta : 1.0 - Math.pow(-2.0 * delta + 2.0, 2.0) / 2.0;
            };
        }
    }
    ,
    CUBIC{

        @Override
        public double value(EasingType type, double delta) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> delta * delta * delta;
                case EasingType.OUT -> 1.0 - Math.pow(1.0 - delta, 3.0);
                case EasingType.BETWEEN -> delta < 0.5 ? 4.0 * delta * delta * delta : 1.0 - Math.pow(-2.0 * delta + 2.0, 3.0) / 2.0;
            };
        }
    }
    ,
    QUART{

        @Override
        public double value(EasingType type, double delta) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> delta * delta * delta * delta;
                case EasingType.OUT -> 1.0 - Math.pow(1.0 - delta, 4.0);
                case EasingType.BETWEEN -> delta < 0.5 ? 8.0 * delta * delta * delta * delta : 1.0 - Math.pow(-2.0 * delta + 2.0, 4.0) / 2.0;
            };
        }
    }
    ,
    QUINT{

        @Override
        public double value(EasingType type, double delta) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> delta * delta * delta * delta * delta;
                case EasingType.OUT -> 1.0 - Math.pow(1.0 - delta, 5.0);
                case EasingType.BETWEEN -> delta < 0.5 ? 16.0 * delta * delta * delta * delta * delta : 1.0 - Math.pow(-2.0 * delta + 2.0, 5.0) / 2.0;
            };
        }
    }
    ,
    EXPO{

        @Override
        public double value(EasingType type, double delta) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> {
                    if (delta == 0.0) {
                        yield 0.0;
                    }
                    yield Math.pow(2.0, 10.0 * delta - 10.0);
                }
                case EasingType.OUT -> {
                    if (delta == 1.0) {
                        yield 1.0;
                    }
                    yield 1.0 - Math.pow(2.0, -10.0 * delta);
                }
                case EasingType.BETWEEN -> delta == 0.0 ? 0.0 : (delta == 1.0 ? 1.0 : (delta < 0.5 ? Math.pow(2.0, 20.0 * delta - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * delta + 10.0)) / 2.0));
            };
        }
    }
    ,
    CIRCLE{

        @Override
        public double value(EasingType type, double delta) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> 1.0 - Math.sqrt(1.0 - Math.pow(delta, 2.0));
                case EasingType.OUT -> Math.sqrt(1.0 - Math.pow(delta - 1.0, 2.0));
                case EasingType.BETWEEN -> delta < 0.5 ? 1.0 - Math.sqrt(1.0 - Math.pow(2.0 * delta, 2.0)) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * delta + 2.0, 2.0)) + 1.0) / 2.0;
            };
        }
    }
    ,
    BACK{

        @Override
        public double value(EasingType type, double delta) {
            double ebb = 1.70158;
            double ebbP1 = 2.70158;
            double ebbP2 = 2.5949095;
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> 2.70158 * delta * delta * delta - 1.70158 * delta * delta;
                case EasingType.OUT -> 1.0 + 2.70158 * Math.pow(delta - 1.0, 3.0) + 1.70158 * Math.pow(delta - 1.0, 2.0);
                case EasingType.BETWEEN -> delta < 0.5 ? Math.pow(2.0 * delta, 2.0) * (7.189819 * delta - 2.5949095) / 2.0 : (Math.pow(2.0 * delta - 2.0, 2.0) * (3.5949095 * (delta * 2.0 - 2.0) + 2.5949095) + 2.0) / 2.0;
            };
        }
    }
    ,
    ELASTIC{

        @Override
        public double value(EasingType type, double delta) {
            double ebb = 2.0943951023931953;
            double ebbT = 1.3962634015954636;
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> {
                    if (delta == 0.0) {
                        yield 0.0;
                    }
                    if (delta == 1.0) {
                        yield 1.0;
                    }
                    yield -Math.pow(2.0, 10.0 * delta - 10.0) * Math.sin((delta * 10.0 - 10.75) * 2.0943951023931953);
                }
                case EasingType.OUT -> {
                    if (delta == 0.0) {
                        yield 0.0;
                    }
                    if (delta == 1.0) {
                        yield 1.0;
                    }
                    yield Math.pow(2.0, -10.0 * delta) * Math.sin((delta * 10.0 - 0.75) * 2.0943951023931953) + 1.0;
                }
                case EasingType.BETWEEN -> delta == 0.0 ? 0.0 : (delta == 1.0 ? 1.0 : (delta < 0.5 ? -(Math.pow(2.0, 20.0 * delta - 10.0) * Math.sin((20.0 * delta - 11.125) * 1.3962634015954636)) / 2.0 : Math.pow(2.0, -20.0 * delta + 10.0) * Math.sin((20.0 * delta - 11.125) * 1.3962634015954636) / 2.0 + 1.0));
            };
        }
    }
    ,
    BOUNCE{

        @Override
        public double value(EasingType type, double delta) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EasingType.IN -> 1.0 - this.easeOutBounce(1.0 - delta);
                case EasingType.OUT -> this.easeOutBounce(delta);
                case EasingType.BETWEEN -> delta < 0.5 ? (1.0 - this.easeOutBounce(1.0 - 2.0 * delta)) / 2.0 : (1.0 + this.easeOutBounce(2.0 * delta - 1.0)) / 2.0;
            };
        }

        private double easeOutBounce(double delta) {
            double ebbN = 7.5625;
            double ebbD = 2.75;
            if (delta < 0.36363636363636365) {
                return 7.5625 * delta * delta;
            }
            if (delta < 0.7272727272727273) {
                return 7.5625 * (delta -= 0.5454545454545454) * delta + 0.75;
            }
            if (delta < 0.9090909090909091) {
                return 7.5625 * (delta -= 0.8181818181818182) * delta + 0.9375;
            }
            return 7.5625 * (delta -= 0.9545454545454546) * delta + 0.984375;
        }
    };


    public abstract double value(EasingType var1, double var2);

    public final double easingInValue(double delta) {
        return this.value(EasingType.IN, delta);
    }

    public final double easingOutValue(double delta) {
        return this.value(EasingType.OUT, delta);
    }

    public final double easingBetweenValue(double delta) {
        return this.value(EasingType.BETWEEN, delta);
    }

    public final String toValueString() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public final class_2561 getFormattedText() {
        return class_2561.method_43469((String)String.format("jugglestruggle.tcs.easings.%1$s", this.toValueString()), (Object[])new Object[0]);
    }

    public boolean canBeRandomlyUsed() {
        return true;
    }

    @Override
    public Easings applyLeft(String value) {
        return Easings.parseFromString(value);
    }

    @Override
    public String applyRight(Easings value) {
        return value.toValueString();
    }

    public static final Easings parseFromString(String name) {
        if (name == null || name.isEmpty() || name.isBlank()) {
            return null;
        }
        return switch (name.toLowerCase(Locale.ROOT)) {
            case "linear" -> LINEAR;
            case "floor" -> FLOOR;
            case "ceiling" -> CEILING;
            case "sine" -> SINE;
            case "quad" -> QUAD;
            case "cubic" -> CUBIC;
            case "quart" -> QUART;
            case "quint" -> QUINT;
            case "expo" -> EXPO;
            case "circle" -> CIRCLE;
            case "back" -> BACK;
            case "elastic" -> ELASTIC;
            case "bounce" -> BOUNCE;
            default -> null;
        };
    }
}

