/*
 * Decompiled with CFR 0.152.
 */
package com.ender.staffAuth;

import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ender/staffAuth/PasswordHashing;", "", "()V", "passwordEncoder", "Lorg/springframework/security/crypto/bcrypt/BCryptPasswordEncoder;", "checkPassword", "", "password", "", "hashedPassword", "hashIp", "ip", "salt", "hashPassword", "StaffAuth"})
@SourceDebugExtension(value={"SMAP\nPasswordHashing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordHashing.kt\ncom/ender/staffAuth/PasswordHashing\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,23:1\n12734#2,3:24\n*S KotlinDebug\n*F\n+ 1 PasswordHashing.kt\ncom/ender/staffAuth/PasswordHashing\n*L\n21#1:24,3\n*E\n"})
public final class PasswordHashing {
    @NotNull
    public static final PasswordHashing INSTANCE = new PasswordHashing();
    @NotNull
    private static final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    private PasswordHashing() {
    }

    @NotNull
    public final String hashPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter(password, "password");
        String string = passwordEncoder.encode(password);
        Intrinsics.checkNotNullExpressionValue(string, "encode(...)");
        return string;
    }

    public final boolean checkPassword(@NotNull String password, @NotNull String hashedPassword) {
        Intrinsics.checkNotNullParameter(password, "password");
        Intrinsics.checkNotNullParameter(hashedPassword, "hashedPassword");
        return passwordEncoder.matches(password, hashedPassword);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String hashIp(@NotNull String ip, @NotNull String salt) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(ip, "ip");
        Intrinsics.checkNotNullParameter(salt, "salt");
        String string = ip + salt;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(bytes);
        Intrinsics.checkNotNull(digest);
        byte[] byArray2 = digest;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var13_13 = element$iv = $this$fold$iv[i];
            String str = accumulator$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(str);
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            accumulator$iv = stringBuilder.append(string3).toString();
        }
        return accumulator$iv;
    }
}

