/*
 * Decompiled with CFR 0.152.
 */
package com.ender.staffAuth;

import com.ender.staffAuth.DataManager;
import com.ender.staffAuth.StaffAuth;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0019H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ender/staffAuth/PlayerListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/ender/staffAuth/StaffAuth;", "(Lcom/ender/staffAuth/StaffAuth;)V", "isNotAuthenticated", "", "player", "Lorg/bukkit/entity/Player;", "isStaff", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "onBlockPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onCommandPreprocess", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "onPlayerChat", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "StaffAuth"})
public final class PlayerListener
implements Listener {
    @NotNull
    private final StaffAuth plugin;

    public PlayerListener(@NotNull StaffAuth plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    private final boolean isStaff(Player player) {
        return player.hasPermission("staffauth.use");
    }

    private final boolean isNotAuthenticated(Player player) {
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return !this.plugin.isAuthenticated(uUID);
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (!this.isStaff(player2)) {
            return;
        }
        DataManager dataManager = this.plugin.getDataManager();
        String string = player2.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        if (dataManager.isPlayerRegistered(string)) {
            player2.sendMessage(this.plugin.getMessage("messages.prompt-login"));
        } else {
            player2.sendMessage(this.plugin.getMessage("messages.prompt-register"));
        }
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        if (!this.isStaff(player)) {
            return;
        }
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.plugin.setAuthenticated(uUID, false);
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (this.isStaff(player2) && this.isNotAuthenticated(player2)) {
            Location location = event.getFrom();
            Intrinsics.checkNotNullExpressionValue(location, "getFrom(...)");
            Location from = location;
            Location to = event.getTo();
            if (!(to == null || from.getX() == to.getX() && from.getZ() == to.getZ())) {
                event.setCancelled(true);
                from.setPitch(to.getPitch());
                from.setYaw(to.getYaw());
                player2.teleport(from);
            }
        }
    }

    @EventHandler
    public final void onPlayerChat(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (this.isStaff(player2) && this.isNotAuthenticated(player2)) {
            event.setCancelled(true);
            player2.sendMessage(this.plugin.getMessage("messages.must-be-logged-in-chat"));
        }
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (this.isStaff(player2) && this.isNotAuthenticated(player2)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onBlockPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (this.isStaff(player2) && this.isNotAuthenticated(player2)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onCommandPreprocess(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (this.isStaff(player2) && this.isNotAuthenticated(player2)) {
            String string = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
            String[] stringArray = new String[]{" "};
            String string2 = ((String)StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null).get(0)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            String command = string2;
            if (!(Intrinsics.areEqual(command, "/register") || Intrinsics.areEqual(command, "/login") || Intrinsics.areEqual(command, "/resetpassword"))) {
                event.setCancelled(true);
                player2.sendMessage(this.plugin.getMessage("messages.must-be-logged-in-commands"));
            }
        }
    }
}

