/*
 * Decompiled with CFR 0.152.
 */
package com.ender.staffAuth;

import com.ender.staffAuth.PasswordHashing;
import com.ender.staffAuth.StaffAuth;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ender/staffAuth/RegisterCommand;", "Lorg/bukkit/command/CommandExecutor;", "plugin", "Lcom/ender/staffAuth/StaffAuth;", "(Lcom/ender/staffAuth/StaffAuth;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "StaffAuth"})
public final class RegisterCommand
implements CommandExecutor {
    @NotNull
    private final StaffAuth plugin;

    public RegisterCommand(@NotNull StaffAuth plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args2) {
        String string;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args2, "args");
        if (!(sender instanceof Player)) {
            return true;
        }
        if (!sender.hasPermission("staffauth.use")) {
            sender.sendMessage(this.plugin.getMessage("messages.no-permission"));
            return true;
        }
        String string2 = ((Player)sender).getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String uuid = string2;
        if (this.plugin.getDataManager().isPlayerRegistered(uuid)) {
            sender.sendMessage(this.plugin.getMessage("messages.already-registered"));
            return true;
        }
        if (args2.length != 2) {
            return false;
        }
        String password = args2[0];
        if (!Intrinsics.areEqual(password, args2[1])) {
            sender.sendMessage(this.plugin.getMessage("messages.passwords-do-not-match"));
            return true;
        }
        Serializable serializable = ((Player)sender).getAddress();
        if ((serializable != null && (serializable = ((InetSocketAddress)serializable).getAddress()) != null ? ((InetAddress)serializable).getHostAddress() : (string = null)) == null) {
            string = "unknown";
        }
        String ip = string;
        String ipHash = PasswordHashing.INSTANCE.hashIp(ip, uuid);
        String hashedPassword = PasswordHashing.INSTANCE.hashPassword(password);
        this.plugin.getDataManager().registerPlayer(uuid, hashedPassword, ipHash);
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.plugin.setAuthenticated(uUID, true);
        sender.sendMessage(this.plugin.getMessage("messages.register-success"));
        return true;
    }
}

