/*
 * Decompiled with CFR 0.152.
 */
package com.ender.staffAuth;

import com.ender.staffAuth.DataManager;
import com.ender.staffAuth.LoginCommand;
import com.ender.staffAuth.PlayerListener;
import com.ender.staffAuth.RegisterCommand;
import com.ender.staffAuth.ResetPasswordCommand;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0011R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/ender/staffAuth/StaffAuth;", "Lorg/bukkit/plugin/java/JavaPlugin;", "()V", "authenticatedPlayers", "", "Ljava/util/UUID;", "getAuthenticatedPlayers", "()Ljava/util/Set;", "<set-?>", "Lcom/ender/staffAuth/DataManager;", "dataManager", "getDataManager", "()Lcom/ender/staffAuth/DataManager;", "getMessage", "", "path", "isAuthenticated", "", "playerUuid", "onDisable", "", "onEnable", "setAuthenticated", "authenticated", "StaffAuth"})
public final class StaffAuth
extends JavaPlugin {
    private DataManager dataManager;
    @NotNull
    private final Set<UUID> authenticatedPlayers = new LinkedHashSet();

    @NotNull
    public final DataManager getDataManager() {
        DataManager dataManager = this.dataManager;
        if (dataManager != null) {
            return dataManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("dataManager");
        return null;
    }

    @NotNull
    public final Set<UUID> getAuthenticatedPlayers() {
        return this.authenticatedPlayers;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.dataManager = new DataManager(this);
        this.getDataManager().loadDatabase();
        PluginCommand pluginCommand = this.getCommand("register");
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)new RegisterCommand(this));
        }
        PluginCommand pluginCommand2 = this.getCommand("login");
        if (pluginCommand2 != null) {
            pluginCommand2.setExecutor((CommandExecutor)new LoginCommand(this));
        }
        PluginCommand pluginCommand3 = this.getCommand("resetpassword");
        if (pluginCommand3 != null) {
            pluginCommand3.setExecutor((CommandExecutor)new ResetPasswordCommand(this));
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getLogger().info("StaffAuth has been enabled!");
    }

    public void onDisable() {
        this.getDataManager().closeConnection();
        this.getLogger().info("StaffAuth has been disabled!");
    }

    public final boolean isAuthenticated(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        return this.authenticatedPlayers.contains(playerUuid);
    }

    public final void setAuthenticated(@NotNull UUID playerUuid, boolean authenticated) {
        Intrinsics.checkNotNullParameter(playerUuid, "playerUuid");
        if (authenticated) {
            this.authenticatedPlayers.add(playerUuid);
        } else {
            this.authenticatedPlayers.remove(playerUuid);
        }
    }

    @NotNull
    public final String getMessage(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        String string = this.getConfig().getString(path);
        if (string == null) {
            string = "&cMessage not found: " + path;
        }
        String string2 = string;
        Intrinsics.checkNotNull(string2);
        String message = string2;
        String string3 = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Intrinsics.checkNotNullExpressionValue(string3, "translateAlternateColorCodes(...)");
        return string3;
    }
}

