/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge;

import appeng.api.ids.AECreativeTabIds;
import com.buuz135.replication.block.MatterPipeBlock;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.unfamily.repae2bridge.Config;
import net.unfamily.repae2bridge.block.ModBlocks;
import net.unfamily.repae2bridge.item.ModItems;
import org.slf4j.Logger;

@Mod(value="rep_ae2_bridge")
public class RepAE2Bridge {
    public static final String MOD_ID = "rep_ae2_bridge";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean networksFixed = false;
    public static volatile boolean worldUnloading = false;

    public RepAE2Bridge() {
        LOGGER.info("RepAE2Bridge: Main constructor called");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        modEventBus.register(Config.class);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        LOGGER.info("RepAE2Bridge: Bridge energy consumption set to {} AE/t", (Object)Config.bridgeEnergyConsumption);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void patchNetworkBlockEntityClass() {
        try {
            if (networksFixed) {
                return;
            }
            LOGGER.info("RepAE2Bridge: Applying patch to fix NetworkBlockEntity.getNetwork");
            networksFixed = true;
            LOGGER.info("RepAE2Bridge: NetworkBlockEntity patch applied successfully");
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge: Failed to patch NetworkBlockEntity: {}", (Object)e.getMessage());
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            boolean ae2Loaded;
            boolean replicationLoaded = ModList.get().isLoaded("replication");
            boolean bl = ae2Loaded = ModList.get().isLoaded("appliedenergistics2") || ModList.get().isLoaded("ae2");
            if (replicationLoaded && ae2Loaded) {
                LOGGER.info("Replication and AE2 mods detected - using existing network infrastructure");
            } else {
                LOGGER.warn("Replication or AE2 mod not detected - bridge functionality may be limited");
            }
        });
        event.enqueueWork(() -> this.registerWithReplicationMod());
        event.enqueueWork(this::patchNetworkBlockEntityClass);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == AECreativeTabIds.MAIN) {
            event.accept(ModBlocks.REP_AE2_BRIDGE_ITEM);
            LOGGER.info("Added RepAE2Bridge to AE2 creative tab");
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("RepAE2Bridge: Server starting");
        worldUnloading = false;
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("RepAE2Bridge: Server stopping - setting worldUnloading flag");
        worldUnloading = true;
    }

    private void registerWithReplicationMod() {
        try {
            Field field = MatterPipeBlock.class.getDeclaredField("ALLOWED_CONNECTION_BLOCKS");
            field.setAccessible(true);
            Object list = field.get(null);
            if (list != null) {
                Method addMethod = list.getClass().getMethod("add", Object.class);
                addMethod.invoke(list, block -> block.getClass().getName().contains(MOD_ID));
                LOGGER.info("RepAE2Bridge: Registered with Replication mod");
            }
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge: Failed to register with Replication mod: {}", (Object)e.getMessage());
        }
    }

    @Mod.EventBusSubscriber(modid="rep_ae2_bridge", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

