/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.block.entity;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.capabilities.Capabilities;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.ProcessingPatternItem;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.helpers.MachineSource;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.PriorityMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.unfamily.repae2bridge.Config;
import net.unfamily.repae2bridge.RepAE2Bridge;
import net.unfamily.repae2bridge.block.ModBlocks;
import net.unfamily.repae2bridge.block.custom.RepAE2BridgeBlock;
import net.unfamily.repae2bridge.item.ModItems;
import org.slf4j.Logger;

public class RepAE2BridgeBlockEntity
extends ReplicationMachine<RepAE2BridgeBlockEntity>
implements IGridConnectedBlockEntity,
IStorageProvider,
ICraftingProvider,
IPriorityHost {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INITIALIZATION_DELAY = 60;
    private static final int REQUEST_ACCUMULATION_TICKS = 100;
    private static final int WARNING_COOLDOWN = 600;
    @Save
    private int initialized = 0;
    @Save
    private int initializationTicks = 0;
    @Save
    private int priority = 0;
    private final IManagedGridNode mainNode;
    private final MatterItemsStorage matterItemsStorage = new MatterItemsStorage();
    @Save
    private InventoryComponent<RepAE2BridgeBlockEntity> output;
    private final Map<UUID, Map<ItemWithSourceId, Integer>> requestCounters = new HashMap<UUID, Map<ItemWithSourceId, Integer>>();
    private int requestCounterTicks = 0;
    private final Map<UUID, Map<String, TaskSourceInfo>> activeTasks = new HashMap<UUID, Map<String, TaskSourceInfo>>();
    private final Map<String, Long> lastMatterWarnings = new HashMap<String, Long>();
    private final UUID blockId = UUID.randomUUID();

    public RepAE2BridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BasicTileBlock)((RepAE2BridgeBlock)((Object)ModBlocks.REP_AE2_BRIDGE_BLOCK.get())), (BlockEntityType)ModBlocks.REP_AE2_BRIDGE_BLOCK_ENTITY.get(), pos, state);
        this.output = new InventoryComponent("output", 11, 131, 18).setRange(9, 2).setComponentHarness((IComponentHarness)this).setInputFilter((stack, slot) -> true);
        this.addInventory(this.output);
        this.mainNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)new BlockEntityNodeListener()).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage((double)Config.bridgeEnergyConsumption).setInWorldNode(true).setTagName("ae2_grid_node").addService(IStorageProvider.class, (IGridNodeService)this).addService(ICraftingProvider.class, (IGridNodeService)this);
    }

    @Nonnull
    public RepAE2BridgeBlockEntity getSelf() {
        return this;
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void saveChanges() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.m_6596_();
            if (reason == IGridNodeListener.State.GRID_BOOT) {
                ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
            }
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, RepAE2BridgeBlockEntity blockEntity) {
        super.serverTick(level, pos, state, (NetworkBlockEntity)blockEntity);
        if (this.initialized == 0) {
            ++this.initializationTicks;
            if (this.initializationTicks >= 60) {
                if (this.mainNode != null && !this.mainNode.isReady()) {
                    this.mainNode.create(level, pos);
                }
                this.initialized = 1;
                this.syncObject(this.initialized);
                this.syncObject(this.initializationTicks);
                if (Config.enableDebugLogging) {
                    LOGGER.info("Bridge at {}: Networks initialized successfully", (Object)pos);
                }
                IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
            }
            return;
        }
        if (this.initialized != 1) {
            return;
        }
        if (level.m_46467_() % 20L == 0L) {
            this.transferItemsToAE2();
        }
        ++this.requestCounterTicks;
        if (this.requestCounterTicks >= 100) {
            this.processAccumulatedRequests();
            this.requestCounterTicks = 0;
        }
    }

    public void clientTick(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull RepAE2BridgeBlockEntity blockEntity) {
        super.clientTick(level, pos, state, (BlockEntity)blockEntity);
    }

    private void transferItemsToAE2() {
        if (this.mainNode == null || !this.mainNode.isActive()) {
            return;
        }
        IGridNode node = this.mainNode.getNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        IStorageService storageService = grid.getStorageService();
        if (storageService == null) {
            return;
        }
        for (int i = 0; i < this.output.getSlots(); ++i) {
            ItemStack stack = this.output.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            long inserted = storageService.getInventory().insert((AEKey)key, (long)stack.m_41613_(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
            if (inserted <= 0L) continue;
            stack.m_41774_((int)inserted);
            this.output.setStackInSlot(i, stack);
        }
    }

    public List<IPatternDetails> getAvailablePatterns() {
        if (this.initialized != 1) {
            return List.of();
        }
        ArrayList<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
        MatterNetwork network = this.getNetwork();
        if (network == null) {
            if (Config.enableDebugLogging) {
                LOGGER.warn("Bridge: getAvailablePatterns called but network is null");
            }
            return patterns;
        }
        for (NetworkElement chipSupplier : network.getChipSuppliers()) {
            BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
            if (!(tile instanceof ChipStorageBlockEntity)) continue;
            ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
            for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                if (pattern.getStack().m_41619_() || pattern.getCompletion() != 1.0f) continue;
                try {
                    MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                    if (matterCompound == null) continue;
                    ArrayList<GenericStack> inputsList = new ArrayList<GenericStack>();
                    for (MatterValue matterValue : matterCompound.getValues().values()) {
                        IMatterType matterType = matterValue.getMatter();
                        long matterAmount = (long)Math.ceil(matterValue.getAmount());
                        Item matterItem = this.getItemForMatterType(matterType);
                        if (matterItem == null) continue;
                        inputsList.add(new GenericStack((AEKey)AEItemKey.of((ItemLike)matterItem), matterAmount));
                    }
                    ArrayList<GenericStack> outputsList = new ArrayList<GenericStack>();
                    outputsList.add(new GenericStack((AEKey)AEItemKey.of((ItemLike)pattern.getStack().m_41720_()), 1L));
                    GenericStack[] inputs = inputsList.toArray(new GenericStack[0]);
                    GenericStack[] outputs = outputsList.toArray(new GenericStack[0]);
                    ProcessingPatternItem processingPatternItem = (ProcessingPatternItem)AEItems.PROCESSING_PATTERN.m_5456_();
                    ItemStack patternStack = processingPatternItem.encode(inputs, outputs);
                    AEProcessingPattern aePattern = new AEProcessingPattern(AEItemKey.of((ItemStack)patternStack));
                    patterns.add((IPatternDetails)aePattern);
                }
                catch (Exception exception) {}
            }
        }
        return patterns;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        Object object;
        if (this.initialized != 1) {
            return false;
        }
        MatterNetwork network = this.getNetwork();
        if (network == null || !this.isActive() || patternDetails == null) {
            return false;
        }
        GenericStack primaryOutput = patternDetails.getPrimaryOutput();
        if (primaryOutput == null || !((object = primaryOutput.what()) instanceof AEItemKey)) {
            return false;
        }
        AEItemKey itemKey = (AEItemKey)object;
        for (NetworkElement chipSupplier : network.getChipSuppliers()) {
            BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
            if (!(tile instanceof ChipStorageBlockEntity)) continue;
            ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
            for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                long matterAmount;
                IMatterType matterType;
                MatterCompound matterCompound;
                if (!pattern.getStack().m_41720_().equals(itemKey.getItem()) || (matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack())) == null) continue;
                boolean hasAllMatter = true;
                for (MatterValue matterValue : matterCompound.getValues().values()) {
                    matterType = matterValue.getMatter();
                    matterAmount = (long)Math.ceil(matterValue.getAmount());
                    long available = network.calculateMatterAmount(matterType);
                    if (available >= matterAmount) continue;
                    hasAllMatter = false;
                    String warningKey = itemKey.getItem().m_5524_() + ":" + matterType.getName();
                    long currentTime = this.f_58857_.m_46467_();
                    if (this.lastMatterWarnings.containsKey(warningKey) && currentTime - this.lastMatterWarnings.get(warningKey) <= 600L) break;
                    this.lastMatterWarnings.put(warningKey, currentTime);
                    break;
                }
                if (!hasAllMatter) {
                    return false;
                }
                for (MatterValue matterValue : matterCompound.getValues().values()) {
                    matterType = matterValue.getMatter();
                    matterAmount = (long)Math.ceil(matterValue.getAmount());
                    Item matterItem = this.getItemForMatterType(matterType);
                    if (matterItem == null) continue;
                    AEItemKey matterKey = AEItemKey.of((ItemLike)matterItem);
                    this.matterItemsStorage.extract((AEKey)matterKey, matterAmount, Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
                }
                ItemStack itemStack = pattern.getStack();
                ItemWithSourceId key = new ItemWithSourceId(itemStack, this.blockId);
                Map sourceCounters = this.requestCounters.getOrDefault(this.blockId, new HashMap());
                int currentCount = sourceCounters.getOrDefault(key, 0);
                sourceCounters.put(key, currentCount + 1);
                this.requestCounters.put(this.blockId, sourceCounters);
                if (Config.enableDebugLogging) {
                    LOGGER.info("Bridge: Accepted pattern request for {}, total pending: {}", (Object)itemKey.getItem().m_5524_(), (Object)(currentCount + 1));
                }
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        boolean busy;
        MatterNetwork network = this.getNetwork();
        if (network == null) {
            return false;
        }
        boolean bl = busy = !network.getTaskManager().getPendingTasks().isEmpty();
        if (!busy && this.requestCounters.isEmpty()) {
            IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
        }
        return busy;
    }

    public int getPatternPriority() {
        return this.priority;
    }

    private void processAccumulatedRequests() {
        if (this.requestCounters.isEmpty()) {
            return;
        }
        MatterNetwork network = this.getNetwork();
        if (network == null) {
            if (Config.enableDebugLogging) {
                LOGGER.warn("Bridge: Cannot process accumulated requests - network is null");
            }
            return;
        }
        for (UUID sourceId : new HashSet<UUID>(this.requestCounters.keySet())) {
            Map<ItemWithSourceId, Integer> sourceCounters = this.requestCounters.get(sourceId);
            if (sourceCounters == null) continue;
            for (Map.Entry<ItemWithSourceId, Integer> entry : new HashMap<ItemWithSourceId, Integer>(sourceCounters).entrySet()) {
                ItemWithSourceId key = entry.getKey();
                int count = entry.getValue();
                try {
                    ReplicationTask task = new ReplicationTask(key.itemStack.m_41777_(), count, IReplicationTask.Mode.MULTIPLE, this.f_58858_);
                    String taskId = task.getUuid().toString();
                    network.getTaskManager().getPendingTasks().put(taskId, task);
                    if (Config.enableDebugLogging) {
                        LOGGER.info("Bridge: Created replication task for {} x{} (ID: {})", new Object[]{key.itemStack.m_41720_().m_5524_(), count, taskId});
                    }
                    Map sourceTasks = this.activeTasks.getOrDefault(sourceId, new HashMap());
                    sourceTasks.put(taskId, new TaskSourceInfo(key.itemStack, sourceId));
                    this.activeTasks.put(sourceId, sourceTasks);
                }
                catch (Exception e) {
                    if (!Config.enableDebugLogging) continue;
                    LOGGER.error("Bridge: Failed to create replication task: {}", (Object)e.getMessage());
                }
            }
        }
        this.requestCounters.clear();
    }

    public void mountInventories(IStorageMounts storageMounts) {
        if (this.initialized != 1) {
            return;
        }
        storageMounts.mount((MEStorage)this.matterItemsStorage, 100);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.saveChanges();
    }

    public boolean isActive() {
        return this.mainNode != null && this.mainNode.isActive() && this.mainNode.getNode() != null;
    }

    public InventoryComponent<RepAE2BridgeBlockEntity> getOutput() {
        return this.output;
    }

    private Item getItemForMatterType(IMatterType type) {
        String name = type.getName();
        if (name.equalsIgnoreCase("earth")) {
            return (Item)ModItems.EARTH_MATTER.get();
        }
        if (name.equalsIgnoreCase("nether")) {
            return (Item)ModItems.NETHER_MATTER.get();
        }
        if (name.equalsIgnoreCase("organic")) {
            return (Item)ModItems.ORGANIC_MATTER.get();
        }
        if (name.equalsIgnoreCase("ender")) {
            return (Item)ModItems.ENDER_MATTER.get();
        }
        if (name.equalsIgnoreCase("metallic")) {
            return (Item)ModItems.METALLIC_MATTER.get();
        }
        if (name.equalsIgnoreCase("precious")) {
            return (Item)ModItems.PRECIOUS_MATTER.get();
        }
        if (name.equalsIgnoreCase("living")) {
            return (Item)ModItems.LIVING_MATTER.get();
        }
        if (name.equalsIgnoreCase("quantum")) {
            return (Item)ModItems.QUANTUM_MATTER.get();
        }
        return null;
    }

    private IMatterType getMatterTypeForItem(Item item) {
        if (item == ModItems.EARTH_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.EARTH.get();
        }
        if (item == ModItems.NETHER_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.NETHER.get();
        }
        if (item == ModItems.ORGANIC_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.ORGANIC.get();
        }
        if (item == ModItems.ENDER_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.ENDER.get();
        }
        if (item == ModItems.METALLIC_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.METALLIC.get();
        }
        if (item == ModItems.PRECIOUS_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get();
        }
        if (item == ModItems.LIVING_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.LIVING.get();
        }
        if (item == ModItems.QUANTUM_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.QUANTUM.get();
        }
        return null;
    }

    private boolean isVirtualMatterItem(Item item) {
        return item == ModItems.EARTH_MATTER.get() || item == ModItems.NETHER_MATTER.get() || item == ModItems.ORGANIC_MATTER.get() || item == ModItems.ENDER_MATTER.get() || item == ModItems.METALLIC_MATTER.get() || item == ModItems.PRECIOUS_MATTER.get() || item == ModItems.LIVING_MATTER.get() || item == ModItems.QUANTUM_MATTER.get();
    }

    @Nonnull
    protected EnergyStorageComponent<RepAE2BridgeBlockEntity> createEnergyStorage() {
        return new EnergyStorageComponent(1, 0, 0);
    }

    public int getTitleColor() {
        return 49151;
    }

    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) - 16.0f;
    }

    public InteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (!this.f_58857_.m_5776_() && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            this.openGui((Player)serverPlayer);
            if (Config.enableDebugLogging) {
                LOGGER.info("Bridge: Opening priority GUI for player {}", (Object)playerIn.m_7755_().getString());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void openGui(@Nonnull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuOpener.open((MenuType)PriorityMenu.TYPE, (Player)serverPlayer, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)this));
        }
    }

    public void m_142466_(@Nonnull CompoundTag data) {
        super.m_142466_(data);
        if (this.mainNode != null) {
            this.mainNode.loadFromNBT(data);
        }
    }

    public void m_183515_(@Nonnull CompoundTag data) {
        super.m_183515_(data);
        if (this.mainNode != null) {
            this.mainNode.saveToNBT(data);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.mainNode != null) {
            this.mainNode.destroy();
        }
        if (RepAE2Bridge.worldUnloading) {
            this.initialized = 2;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.mainNode != null) {
            this.mainNode.destroy();
        }
    }

    public void m_6339_() {
        super.m_6339_();
        this.initialized = 0;
        this.initializationTicks = 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.IN_WORLD_GRID_NODE_HOST) {
            return LazyOptional.of(() -> this).cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == Direction.UP) {
            return LazyOptional.of(() -> this.output).cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)ModBlocks.REP_AE2_BRIDGE_ITEM.get());
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
    }

    private class MatterItemsStorage
    implements MEStorage {
        private MatterItemsStorage() {
        }

        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            return 0L;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            IMatterType matterType;
            MatterNetwork network;
            AEItemKey itemKey;
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return 0L;
            }
            if (what instanceof AEItemKey && RepAE2BridgeBlockEntity.this.isVirtualMatterItem((itemKey = (AEItemKey)what).getItem()) && (network = RepAE2BridgeBlockEntity.this.getNetwork()) != null && (matterType = RepAE2BridgeBlockEntity.this.getMatterTypeForItem(itemKey.getItem())) != null) {
                long available = network.calculateMatterAmount(matterType);
                long toExtract = Math.min(amount, available);
                if (mode == Actionable.SIMULATE) {
                    return toExtract;
                }
                return toExtract > 0L ? toExtract : 0L;
            }
            return 0L;
        }

        public void getAvailableStacks(KeyCounter out) {
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return;
            }
            MatterNetwork network = RepAE2BridgeBlockEntity.this.getNetwork();
            if (network != null) {
                try {
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.EARTH.get(), out, network);
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.NETHER.get(), out, network);
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.ORGANIC.get(), out, network);
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.ENDER.get(), out, network);
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.METALLIC.get(), out, network);
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.PRECIOUS.get(), out, network);
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.LIVING.get(), out, network);
                    this.addMatterToOutput((IMatterType)ReplicationRegistry.Matter.QUANTUM.get(), out, network);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void addMatterToOutput(IMatterType matterType, KeyCounter out, MatterNetwork network) {
            Item item;
            long amount = network.calculateMatterAmount(matterType);
            if (amount > 0L && (item = RepAE2BridgeBlockEntity.this.getItemForMatterType(matterType)) != null) {
                out.add((AEKey)AEItemKey.of((ItemLike)item), amount);
            }
        }

        public Component getDescription() {
            return Component.m_237113_((String)"Replication Matter Storage");
        }
    }

    private static class ItemWithSourceId {
        private final ItemStack itemStack;
        private final UUID sourceId;

        public ItemWithSourceId(ItemStack itemStack, UUID sourceId) {
            this.itemStack = itemStack.m_41777_();
            this.sourceId = sourceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemWithSourceId)) {
                return false;
            }
            ItemWithSourceId that = (ItemWithSourceId)o;
            return ItemStack.m_150942_((ItemStack)this.itemStack, (ItemStack)that.itemStack) && Objects.equals(this.sourceId, that.sourceId);
        }

        public int hashCode() {
            return Objects.hash(this.itemStack.m_41720_(), this.sourceId);
        }
    }

    private static class TaskSourceInfo {
        private final ItemStack itemStack;
        private final UUID sourceId;

        public TaskSourceInfo(ItemStack itemStack, UUID sourceId) {
            this.itemStack = itemStack.m_41777_();
            this.sourceId = sourceId;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public UUID getSourceId() {
            return this.sourceId;
        }
    }
}

