/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.block.entity;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingSimulationRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.core.definitions.AEItems;
import appeng.crafting.inv.ICraftingInventory;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.MachineSource;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.PriorityMenu;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.unfamily.repae2bridge.Config;
import net.unfamily.repae2bridge.block.ModBlocks;
import net.unfamily.repae2bridge.block.custom.RepAE2BridgeBl;
import net.unfamily.repae2bridge.block.entity.ModBlockEntities;
import net.unfamily.repae2bridge.item.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RepAE2BridgeBlockEntity
extends ReplicationMachine<RepAE2BridgeBlockEntity>
implements IInWorldGridNodeHost,
ICraftingInventory,
ICraftingProvider,
IStorageProvider,
IActionHost,
IPriorityHost {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int REQUEST_ACCUMULATION_TICKS = 100;
    private static final int INITIALIZATION_DELAY = 60;
    private byte initialized = 0;
    private int initializationTicks = 0;
    @Save
    private int priority = 0;
    private final Queue<IPatternDetails> pendingPatterns = new LinkedList<IPatternDetails>();
    private final Map<IPatternDetails, KeyCounter[]> pendingInputs = new HashMap<IPatternDetails, KeyCounter[]>();
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)new IGridNodeListener<RepAE2BridgeBlockEntity>(){

        public void onSaveChanges(RepAE2BridgeBlockEntity nodeOwner, IGridNode node) {
            nodeOwner.setChanged();
        }

        public void onStateChanged(RepAE2BridgeBlockEntity nodeOwner, IGridNode node, IGridNodeListener.State state) {
            if (nodeOwner.level != null) {
                nodeOwner.level.sendBlockUpdated(nodeOwner.worldPosition, nodeOwner.getBlockState(), nodeOwner.getBlockState(), 3);
                RepAE2BridgeBlockEntity.this.updateConnectedState();
                if (state == IGridNodeListener.State.POWER && node.isActive()) {
                    ICraftingProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
                }
            }
        }

        public void onGridChanged(RepAE2BridgeBlockEntity nodeOwner, IGridNode node) {
            if (nodeOwner.level != null) {
                nodeOwner.level.sendBlockUpdated(nodeOwner.worldPosition, nodeOwner.getBlockState(), nodeOwner.getBlockState(), 3);
                RepAE2BridgeBlockEntity.this.updateConnectedState();
                ICraftingProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
                IStorageProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
            }
        }
    }).setVisualRepresentation((ItemLike)ModBlocks.REPAE2BRIDGE.get()).setInWorldNode(true).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage((double)Config.bridgeEnergyConsumption).setExposedOnSides(EnumSet.allOf(Direction.class)).addService(ICraftingProvider.class, (IGridNodeService)this).addService(IStorageProvider.class, (IGridNodeService)this).setTagName("main");
    private boolean nodeCreated = false;
    private boolean shouldReconnect = false;
    @Save
    private InventoryComponent<RepAE2BridgeBlockEntity> output;
    @Save
    private int sortingTypeValue = 0;
    @Save
    private int sortingDirection = 1;
    @Save
    private int matterOpediaSortingTypeValue = 0;
    @Save
    private int matterOpediaSortingDirection = 1;
    private TerminalPlayerTracker terminalPlayerTracker;
    @Save
    private UUID blockId;
    private final Map<UUID, Map<ItemStack, Integer>> patternRequests = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<String, TaskSourceInfo>> activeTasks = new HashMap<UUID, Map<String, TaskSourceInfo>>();
    private final Map<UUID, Map<ItemStack, Integer>> patternRequestsBySource = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<ItemWithSourceId, Integer>> requestCounters = new HashMap<UUID, Map<ItemWithSourceId, Integer>>();
    private int requestCounterTicks = 0;
    private int patternUpdateTicks = 0;
    private static final int PATTERN_UPDATE_INTERVAL = 100;
    private Map<String, Long> lastMatterWarnings = new HashMap<String, Long>();
    private static final int WARNING_COOLDOWN = 600;
    private int debugTickCounter = 0;
    private int hiddenDebugMessages = 0;
    private static final int DEBUG_LOG_INTERVAL = 300;
    private static boolean globalShouldLogDebug = false;
    private static int globalHiddenDebugMessages = 0;
    private static final long WARNING_THROTTLE_INTERVAL = 300L;
    private static int worldUnloadingWarningsHidden = 0;
    private static int globalOperationLogsHidden = 0;
    private static boolean worldUnloading = false;
    private static final Set<RepAE2BridgeBlockEntity> activeBridges = new HashSet<RepAE2BridgeBlockEntity>();
    private final MatterItemsStorage matterItemsStorage = new MatterItemsStorage();

    public static void setWorldUnloading(boolean unloading) {
        RepAE2BridgeBlockEntity.setWorldUnloading(unloading, null, null);
    }

    public static void setWorldUnloading(boolean unloading, @Nullable Level level, @Nullable BlockPos pos) {
        if (unloading && !worldUnloading) {
            String dimensionInfo = level != null ? " [Dimension: " + String.valueOf(level.dimension().location()) + "]" : "";
            String positionInfo = pos != null ? " [Position: " + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + "]" : "";
            LOGGER.info("RepAE2Bridge: World unloading detected - All bridges will now shutdown{}{}", (Object)dimensionInfo, (Object)positionInfo);
            LOGGER.info("RepAE2Bridge: Cancelling all pending operations{}{}", (Object)dimensionInfo, (Object)positionInfo);
            RepAE2BridgeBlockEntity.cancelAllPendingOperations();
            LOGGER.info("RepAE2Bridge: Disconnecting {} active bridges from AE2 and Titanium/Replication networks", (Object)activeBridges.size());
            RepAE2BridgeBlockEntity.disconnectAllBridgesFromNetworks();
        } else if (!unloading && worldUnloading) {
            String dimensionInfo = level != null ? " [Dimension: " + String.valueOf(level.dimension().location()) + "]" : "";
            String positionInfo = pos != null ? " [Position: " + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + "]" : "";
            LOGGER.info("GLOBAL WORLD UNLOADING FLAG SET TO: false - Normal operation resumed{}{}", (Object)dimensionInfo, (Object)positionInfo);
            worldUnloadingWarningsHidden = 0;
        }
        worldUnloading = unloading;
    }

    public static boolean isWorldUnloading() {
        return worldUnloading;
    }

    private String getLocationInfo() {
        if (this.level == null) {
            return " [Dimension: unknown] [Position: " + this.worldPosition.getX() + ", " + this.worldPosition.getY() + ", " + this.worldPosition.getZ() + "]";
        }
        return " [Dimension: " + String.valueOf(this.level.dimension().location()) + "] [Position: " + this.worldPosition.getX() + ", " + this.worldPosition.getY() + ", " + this.worldPosition.getZ() + "]";
    }

    private void logNetworkState(String context) {
        block23: {
            if (!Config.enableDebugLogging) {
                return;
            }
            LOGGER.error("Bridge{}: ========== NETWORK STATE DUMP [{}] ==========", (Object)this.getLocationInfo(), (Object)context);
            LOGGER.error("Bridge{}: AE2 Node State:", (Object)this.getLocationInfo());
            if (this.mainNode == null) {
                LOGGER.error("Bridge{}: - mainNode is NULL", (Object)this.getLocationInfo());
            } else {
                LOGGER.error("Bridge{}: - mainNode exists: {}", (Object)this.getLocationInfo(), (Object)this.mainNode.getClass().getName());
                IGridNode node = this.mainNode.getNode();
                if (node == null) {
                    LOGGER.error("Bridge{}: - mainNode.getNode() is NULL", (Object)this.getLocationInfo());
                } else {
                    LOGGER.error("Bridge{}: - IGridNode exists: {}", (Object)this.getLocationInfo(), (Object)node.getClass().getName());
                    try {
                        LOGGER.error("Bridge{}: - Node active: {}", (Object)this.getLocationInfo(), (Object)node.isActive());
                        IGrid grid = node.getGrid();
                        if (grid == null) {
                            LOGGER.error("Bridge{}: - Grid is NULL", (Object)this.getLocationInfo());
                        } else {
                            LOGGER.error("Bridge{}: - Grid exists: {}", (Object)this.getLocationInfo(), (Object)grid.getClass().getName());
                            LOGGER.error("Bridge{}: - Grid node count: {}", (Object)this.getLocationInfo(), (Object)grid.getMachines(IGridNode.class).size());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Bridge{}: - Exception accessing node properties: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
                    }
                }
                LOGGER.error("Bridge{}: - mainNode.isActive(): {}", (Object)this.getLocationInfo(), (Object)this.mainNode.isActive());
            }
            LOGGER.error("Bridge{}: - nodeCreated flag: {}", (Object)this.getLocationInfo(), (Object)this.nodeCreated);
            LOGGER.error("Bridge{}: - shouldReconnect flag: {}", (Object)this.getLocationInfo(), (Object)this.shouldReconnect);
            LOGGER.error("Bridge{}: Replication Network State:", (Object)this.getLocationInfo());
            try {
                MatterNetwork network = this.getNetwork();
                if (network == null) {
                    LOGGER.error("Bridge{}: - Replication network is NULL", (Object)this.getLocationInfo());
                    break block23;
                }
                LOGGER.error("Bridge{}: - Replication network exists: {}", (Object)this.getLocationInfo(), (Object)network.getClass().getName());
                try {
                    LOGGER.error("Bridge{}: - Network ID: {}", (Object)this.getLocationInfo(), (Object)network.getId());
                    LOGGER.error("Bridge{}: - Network has task manager: {}", (Object)this.getLocationInfo(), (Object)(network.getTaskManager() != null ? 1 : 0));
                    if (network.getTaskManager() != null) {
                        LOGGER.error("Bridge{}: - Pending tasks count: {}", (Object)this.getLocationInfo(), network.getTaskManager().getPendingTasks() != null ? Integer.valueOf(network.getTaskManager().getPendingTasks().size()) : "NULL");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Bridge{}: - Exception accessing network properties: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge{}: - Exception getting Replication network: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
            }
        }
        LOGGER.error("Bridge{}: NetworkManager State:", (Object)this.getLocationInfo());
        if (this.level == null) {
            LOGGER.error("Bridge{}: - Level is NULL, cannot check NetworkManager", (Object)this.getLocationInfo());
        } else {
            try {
                NetworkManager networkManager = NetworkManager.get((Level)this.level);
                if (networkManager == null) {
                    LOGGER.error("Bridge{}: - NetworkManager is NULL", (Object)this.getLocationInfo());
                } else {
                    LOGGER.error("Bridge{}: - NetworkManager exists: {}", (Object)this.getLocationInfo(), (Object)networkManager.getClass().getName());
                    NetworkElement element = networkManager.getElement(this.worldPosition);
                    if (element == null) {
                        LOGGER.error("Bridge{}: - NetworkElement at position is NULL", (Object)this.getLocationInfo());
                    } else {
                        LOGGER.error("Bridge{}: - NetworkElement exists: {}", (Object)this.getLocationInfo(), (Object)element.getClass().getName());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge{}: - Exception accessing NetworkManager: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
            }
        }
        LOGGER.error("Bridge{}: Internal State:", (Object)this.getLocationInfo());
        LOGGER.error("Bridge{}: - initialized: {}", (Object)this.getLocationInfo(), (Object)this.initialized);
        LOGGER.error("Bridge{}: - worldUnloading (static): {}", (Object)this.getLocationInfo(), (Object)worldUnloading);
        LOGGER.error("Bridge{}: - level null: {}", (Object)this.getLocationInfo(), (Object)(this.level == null ? 1 : 0));
        LOGGER.error("Bridge{}: - level client side: {}", (Object)this.getLocationInfo(), (Object)(this.level != null && this.level.isClientSide() ? 1 : 0));
        LOGGER.error("Bridge{}: - blockId: {}", (Object)this.getLocationInfo(), (Object)this.blockId);
        LOGGER.error("Bridge{}: ========== END NETWORK STATE DUMP ==========", (Object)this.getLocationInfo());
    }

    public RepAE2BridgeBlockEntity(BlockPos pos, BlockState blockState) {
        super((BasicTileBlock)ModBlocks.REPAE2BRIDGE.get(), ModBlockEntities.REPAE2BRIDGE_BE.get(), pos, blockState);
        this.blockId = UUID.randomUUID();
        this.terminalPlayerTracker = new TerminalPlayerTracker();
        this.output = new InventoryComponent("output", 11, 131, 18).setRange(9, 2).setComponentHarness((IComponentHarness)this).setInputFilter((stack, slot) -> true);
        this.addInventory(this.output);
        activeBridges.add(this);
        LOGGER.debug("Bridge{}: Registered in active bridges registry (total: {})", (Object)this.getLocationInfo(), (Object)activeBridges.size());
    }

    @NotNull
    public RepAE2BridgeBlockEntity getSelf() {
        return this;
    }

    private boolean hasBridgeInDirection(Direction direction) {
        if (this.level != null) {
            BlockPos neighborPos = this.worldPosition.relative(direction);
            return this.level.getBlockEntity(neighborPos) instanceof RepAE2BridgeBlockEntity;
        }
        return false;
    }

    protected NetworkElement createElement(Level level, BlockPos pos) {
        try {
            return new DefaultMatterNetworkElement(this, level, pos){

                public boolean canConnectFrom(Direction direction) {
                    BlockPos neighborPos = this.pos.relative(direction);
                    if (this.level.getBlockEntity(neighborPos) instanceof RepAE2BridgeBlockEntity) {
                        return false;
                    }
                    return super.canConnectFrom(direction);
                }
            };
        }
        catch (Exception e) {
            LOGGER.error("Failed to create Replication network element: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void onLoad() {
        try {
            super.onLoad();
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && (e.getMessage().contains("Element network is null") || e.getMessage().contains("network is null"))) {
                LOGGER.warn("Bridge: Replication network not ready during onLoad, will retry later. Error: {}", (Object)e.getMessage());
                if (this.level != null && !this.level.isClientSide()) {
                    this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 60);
                }
                return;
            }
            LOGGER.error("Bridge: Unexpected error during onLoad: {}", (Object)e.getMessage(), (Object)e);
            if (this.level != null && !this.level.isClientSide()) {
                this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 100);
            }
            return;
        }
        if (!this.nodeCreated && this.level != null && !this.level.isClientSide()) {
            boolean nodeAlreadyExists;
            boolean bl = nodeAlreadyExists = this.mainNode.getNode() != null;
            if (!nodeAlreadyExists) {
                try {
                    this.mainNode.create(this.level, this.worldPosition);
                    this.nodeCreated = true;
                    this.forceNeighborUpdates();
                    this.updateConnectedState();
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to initialize AE2 node: {}", (Object)e.getMessage());
                    this.shouldReconnect = true;
                    if (this.level != null) {
                        this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 20);
                    }
                }
            } else {
                this.nodeCreated = true;
                this.forceNeighborUpdates();
                this.updateConnectedState();
                ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                LOGGER.debug("Bridge: AE2 node already exists in onLoad, skipping creation");
            }
        } else if (this.nodeCreated && this.mainNode.getNode() == null) {
            this.nodeCreated = false;
            this.shouldReconnect = true;
            if (this.level != null && !this.level.isClientSide()) {
                this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 20);
            }
        }
    }

    private void updateConnectedState() {
        BlockState currentState;
        if (this.level != null && !this.level.isClientSide() && (currentState = this.level.getBlockState(this.worldPosition)).getBlock() == ModBlocks.REPAE2BRIDGE.get()) {
            boolean isConnected;
            boolean bl = isConnected = this.isActive() && this.getNetwork() != null;
            if ((Boolean)currentState.getValue((Property)RepAE2BridgeBl.CONNECTED) != isConnected) {
                this.level.setBlock(this.worldPosition, (BlockState)currentState.setValue((Property)RepAE2BridgeBl.CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
            }
        }
    }

    private boolean hasAE2NetworkConnection() {
        if (this.level != null && !this.level.isClientSide()) {
            for (Direction direction : Direction.values()) {
                IInWorldGridNodeHost host;
                IGridNode node;
                BlockPos neighborPos = this.worldPosition.relative(direction);
                BlockEntity blockEntity = this.level.getBlockEntity(neighborPos);
                if (!(blockEntity instanceof IInWorldGridNodeHost) || (node = (host = (IInWorldGridNodeHost)blockEntity).getGridNode(direction.getOpposite())) == null || !node.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    private void forceNeighborUpdates() {
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = this.worldPosition.relative(direction);
                BlockState neighborState = this.level.getBlockState(neighborPos);
                if (neighborState.isAir()) continue;
                this.level.neighborChanged(neighborPos, this.getBlockState().getBlock(), this.worldPosition);
            }
        }
    }

    public void handleNeighborChanged(BlockPos fromPos) {
        if (this.level != null && !this.level.isClientSide()) {
            Direction directionToNeighbor = null;
            for (Direction dir : Direction.values()) {
                if (!this.worldPosition.relative(dir).equals((Object)fromPos)) continue;
                directionToNeighbor = dir;
                break;
            }
            if (directionToNeighbor != null && this.level.getBlockEntity(fromPos) instanceof RepAE2BridgeBlockEntity) {
                return;
            }
            boolean hasAE2Connection = this.hasAE2NetworkConnection();
            if (hasAE2Connection && !this.nodeCreated) {
                boolean nodeAlreadyExists;
                boolean bl = nodeAlreadyExists = this.mainNode.getNode() != null;
                if (!nodeAlreadyExists) {
                    try {
                        this.mainNode.create(this.level, this.worldPosition);
                        this.nodeCreated = true;
                        this.forceNeighborUpdates();
                        this.updateConnectedState();
                        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to initialize AE2 node: {}", (Object)e.getMessage());
                        this.shouldReconnect = true;
                    }
                } else {
                    this.nodeCreated = true;
                    this.forceNeighborUpdates();
                    this.updateConnectedState();
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    LOGGER.debug("Bridge: AE2 node already exists in handleNeighborChanged, skipping creation");
                }
            } else if (this.mainNode.getNode() != null) {
                this.forceNeighborUpdates();
            }
            this.updateConnectedState();
        }
    }

    public void disconnectFromNetworks() {
        LOGGER.info("Bridge{}: Disconnecting from AE2 and Titanium/Replication networks", (Object)this.getLocationInfo());
        if (this.level != null && !this.level.isClientSide() && this.mainNode != null) {
            try {
                this.mainNode.destroy();
                this.nodeCreated = false;
                LOGGER.info("Bridge{}: AE2 network disconnected", (Object)this.getLocationInfo());
            }
            catch (Exception e) {
                LOGGER.warn("Bridge{}: Error disconnecting from AE2 network: {}", (Object)this.getLocationInfo(), (Object)e.getMessage());
            }
        }
        try {
            NetworkElement element;
            NetworkManager networkManager;
            if (this.level != null && !this.level.isClientSide() && (networkManager = NetworkManager.get((Level)this.level)) != null && (element = networkManager.getElement(this.worldPosition)) != null) {
                LOGGER.info("Bridge{}: Removing from Titanium/Replication NetworkManager", (Object)this.getLocationInfo());
                networkManager.removeElement(this.worldPosition);
                LOGGER.info("Bridge{}: Titanium/Replication network disconnected", (Object)this.getLocationInfo());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Bridge{}: Error disconnecting from Titanium/Replication network: {}", (Object)this.getLocationInfo(), (Object)e.getMessage());
        }
        LOGGER.info("Bridge{}: Network disconnection completed", (Object)this.getLocationInfo());
    }

    private static void disconnectAllBridgesFromNetworks() {
        ArrayList<RepAE2BridgeBlockEntity> bridgesToDisconnect = new ArrayList<RepAE2BridgeBlockEntity>(activeBridges);
        LOGGER.info("RepAE2Bridge: Starting network disconnection for {} bridges", (Object)bridgesToDisconnect.size());
        int disconnected = 0;
        int failed = 0;
        for (RepAE2BridgeBlockEntity bridge : bridgesToDisconnect) {
            try {
                LOGGER.info("RepAE2Bridge: Disconnecting bridge at {}", (Object)bridge.getLocationInfo());
                bridge.disconnectFromNetworks();
                ++disconnected;
            }
            catch (Exception e) {
                LOGGER.warn("RepAE2Bridge: Failed to disconnect bridge: {}", (Object)e.getMessage());
                ++failed;
            }
        }
        activeBridges.clear();
        LOGGER.info("RepAE2Bridge: Network disconnection completed - {} successful, {} failed", (Object)disconnected, (Object)failed);
    }

    public void initializeAE2Node() {
        if (this.level != null && !this.level.isClientSide() && this.mainNode != null) {
            try {
                boolean isDedicatedServer;
                if (this.mainNode.getNode() != null) {
                    this.mainNode.destroy();
                    LOGGER.debug("Bridge: Destroyed existing AE2 node before recreation");
                }
                boolean bl = isDedicatedServer = this.level.getServer() != null && this.level.getServer().isDedicatedServer();
                if (isDedicatedServer) {
                    LOGGER.info("Bridge: Dedicated server detected, using direct node creation");
                    try {
                        this.mainNode.create(this.level, this.worldPosition);
                        this.nodeCreated = true;
                        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                        IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                        this.forceNeighborUpdates();
                        this.updateConnectedState();
                        LOGGER.info("Bridge: AE2 node successfully created and registered with the grid (direct method)");
                    }
                    catch (Exception e) {
                        LOGGER.error("Bridge: Failed to create AE2 node with direct method: {}", (Object)e.getMessage());
                    }
                } else {
                    this.level.getServer().tell((Runnable)new TickTask(0, () -> {
                        try {
                            this.mainNode.create(this.level, this.worldPosition);
                            this.nodeCreated = true;
                            ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                            IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                            this.forceNeighborUpdates();
                            this.updateConnectedState();
                            LOGGER.info("Bridge: AE2 node successfully created and registered with the grid");
                        }
                        catch (Exception e) {
                            LOGGER.error("Bridge: Failed to create AE2 node during scheduled task: {}", (Object)e.getMessage());
                        }
                    }));
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Failed to initialize AE2 node: {}", (Object)e.getMessage());
            }
        }
    }

    private boolean forceAE2GridConnection() {
        if (this.level == null || this.level.isClientSide()) {
            return false;
        }
        boolean foundAE2Component = false;
        IGrid connectedGrid = null;
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = this.worldPosition.relative(direction);
            BlockEntity neighborEntity = this.level.getBlockEntity(neighborPos);
            if (!(neighborEntity instanceof IInWorldGridNodeHost)) continue;
            foundAE2Component = true;
            IGridNode neighborNode = ((IInWorldGridNodeHost)neighborEntity).getGridNode(direction.getOpposite());
            if (neighborNode == null || !neighborNode.isActive()) continue;
            connectedGrid = neighborNode.getGrid();
            LOGGER.info("Bridge: Found active AE2 grid connection at {}", (Object)neighborPos);
            break;
        }
        if (connectedGrid != null && (this.mainNode.getNode() == null || this.mainNode.getNode().getGrid() == null)) {
            LOGGER.info("Bridge: Found AE2 grid but node not connected, forcing connection");
            this.initializeAE2Node();
            return true;
        }
        return foundAE2Component;
    }

    public void setRemoved() {
        LOGGER.error("Bridge{}: setRemoved() called - beginning cleanup", (Object)this.getLocationInfo());
        activeBridges.remove((Object)this);
        LOGGER.error("Bridge{}: Removed from active bridges registry (remaining: {})", (Object)this.getLocationInfo(), (Object)activeBridges.size());
        this.logNetworkState("BEFORE setRemoved cleanup");
        try {
            LOGGER.error("Bridge{}: Attempting to destroy AE2 node", (Object)this.getLocationInfo());
            if (this.mainNode != null) {
                this.mainNode.destroy();
                LOGGER.error("Bridge{}: AE2 node destruction completed", (Object)this.getLocationInfo());
            } else {
                LOGGER.warn("Bridge{}: AE2 node was null during setRemoved", (Object)this.getLocationInfo());
            }
        }
        catch (Exception e) {
            LOGGER.error("Bridge{}: EXCEPTION destroying AE2 node: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
        }
        this.logNetworkState("AFTER AE2 node destruction");
        try {
            LOGGER.error("Bridge{}: Calling super.setRemoved()", (Object)this.getLocationInfo());
            long startTime = System.currentTimeMillis();
            super.setRemoved();
            long duration = System.currentTimeMillis() - startTime;
            LOGGER.error("Bridge{}: super.setRemoved() completed in {} ms", (Object)this.getLocationInfo(), (Object)duration);
        }
        catch (Exception e) {
            LOGGER.error("Bridge{}: EXCEPTION in super.setRemoved(): {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
        }
        this.logNetworkState("AFTER super.setRemoved()");
        this.nodeCreated = false;
        this.shouldReconnect = false;
        LOGGER.error("Bridge{}: setRemoved() cleanup completed", (Object)this.getLocationInfo());
    }

    public void onChunkUnloaded() {
        LOGGER.error("Bridge{}: onChunkUnloaded() called - beginning cleanup", (Object)this.getLocationInfo());
        this.logNetworkState("BEFORE onChunkUnloaded cleanup");
        try {
            LOGGER.error("Bridge{}: Attempting to destroy AE2 node in onChunkUnloaded", (Object)this.getLocationInfo());
            if (this.mainNode != null) {
                this.mainNode.destroy();
                LOGGER.error("Bridge{}: AE2 node destruction in onChunkUnloaded completed", (Object)this.getLocationInfo());
            } else {
                LOGGER.warn("Bridge{}: AE2 node was null during onChunkUnloaded", (Object)this.getLocationInfo());
            }
        }
        catch (Exception e) {
            LOGGER.error("Bridge{}: EXCEPTION destroying AE2 node in onChunkUnloaded: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
        }
        this.logNetworkState("AFTER AE2 node destruction in onChunkUnloaded");
        try {
            LOGGER.error("Bridge{}: Calling super.onChunkUnloaded()", (Object)this.getLocationInfo());
            long startTime = System.currentTimeMillis();
            super.onChunkUnloaded();
            long duration = System.currentTimeMillis() - startTime;
            LOGGER.error("Bridge{}: super.onChunkUnloaded() completed in {} ms", (Object)this.getLocationInfo(), (Object)duration);
        }
        catch (Exception e) {
            LOGGER.error("Bridge{}: EXCEPTION in super.onChunkUnloaded(): {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
        }
        this.logNetworkState("AFTER super.onChunkUnloaded()");
        this.nodeCreated = false;
        this.shouldReconnect = false;
        LOGGER.error("Bridge{}: onChunkUnloaded() cleanup completed", (Object)this.getLocationInfo());
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        long duration;
        long startTime;
        if (Config.enableDebugLogging) {
            LOGGER.error("Bridge{}: saveAdditional() called", (Object)this.getLocationInfo());
            this.logNetworkState("DURING saveAdditional");
        }
        try {
            if (Config.enableDebugLogging) {
                LOGGER.error("Bridge{}: Calling super.saveAdditional()", (Object)this.getLocationInfo());
            }
            startTime = System.currentTimeMillis();
            super.saveAdditional(tag, registries);
            duration = System.currentTimeMillis() - startTime;
            if (Config.enableDebugLogging) {
                LOGGER.error("Bridge{}: super.saveAdditional() completed in {} ms", (Object)this.getLocationInfo(), (Object)duration);
            }
        }
        catch (Exception e) {
            LOGGER.error("Bridge{}: EXCEPTION in super.saveAdditional(): {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
        }
        try {
            if (Config.enableDebugLogging) {
                LOGGER.error("Bridge{}: Attempting to save AE2 node to NBT", (Object)this.getLocationInfo());
            }
            startTime = System.currentTimeMillis();
            this.mainNode.saveToNBT(tag);
            duration = System.currentTimeMillis() - startTime;
            if (Config.enableDebugLogging) {
                LOGGER.error("Bridge{}: AE2 node saved to NBT in {} ms", (Object)this.getLocationInfo(), (Object)duration);
            }
        }
        catch (Exception e) {
            LOGGER.error("Bridge{}: EXCEPTION saving AE2 node to NBT: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
        }
        tag.putBoolean("nodeCreated", this.nodeCreated);
        tag.putBoolean("shouldReconnect", this.shouldReconnect);
        if (this.blockId != null) {
            tag.putUUID("blockId", this.blockId);
        }
        if (Config.enableDebugLogging) {
            LOGGER.error("Bridge{}: saveAdditional() completed", (Object)this.getLocationInfo());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.mainNode.loadFromNBT(tag);
        if (tag.contains("nodeCreated")) {
            this.nodeCreated = tag.getBoolean("nodeCreated");
        }
        if (tag.contains("shouldReconnect")) {
            this.shouldReconnect = tag.getBoolean("shouldReconnect");
        }
        this.blockId = tag.contains("blockId") ? tag.getUUID("blockId") : UUID.randomUUID();
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        return this.mainNode.getNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Nullable
    public IGridNode getActionableNode() {
        return this.mainNode.getNode();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, RepAE2BridgeBlockEntity blockEntity) {
        NetworkManager networkManager;
        boolean isDedicatedServer;
        boolean shouldLogDebug;
        if (worldUnloading) {
            if ((long)worldUnloadingWarningsHidden == 300L) {
                LOGGER.warn("Bridge{}: EXITING serverTick early - world is unloading (+ {} similar warnings hidden in last 15s)", (Object)this.getLocationInfo(), (Object)worldUnloadingWarningsHidden);
                worldUnloadingWarningsHidden = 0;
            } else {
                ++worldUnloadingWarningsHidden;
            }
            return;
        }
        ++this.debugTickCounter;
        globalShouldLogDebug = shouldLogDebug = this.debugTickCounter % 300 == 0;
        if (shouldLogDebug) {
            LOGGER.debug("Bridge at {}: serverTick summary - {} ticks completed, {} local + {} global debug messages hidden", new Object[]{this.worldPosition, this.debugTickCounter, this.hiddenDebugMessages, globalHiddenDebugMessages});
            this.hiddenDebugMessages = 0;
            globalHiddenDebugMessages = 0;
        } else {
            this.hiddenDebugMessages += 3;
        }
        try {
            if (shouldLogDebug) {
                LOGGER.debug("Bridge at {}: Calling super.serverTick()", (Object)this.worldPosition);
            }
            super.serverTick(level, pos, state, (NetworkBlockEntity)blockEntity);
            if (shouldLogDebug) {
                LOGGER.debug("Bridge at {}: super.serverTick() completed successfully", (Object)this.worldPosition);
            }
        }
        catch (Exception e) {
            LOGGER.error("Bridge at {}: EXCEPTION in super.serverTick(): {}", new Object[]{this.worldPosition, e.getMessage(), e});
            return;
        }
        if (worldUnloading) {
            if ((long)worldUnloadingWarningsHidden == 300L) {
                LOGGER.warn("Bridge{}: World unloading detected after super.serverTick() - exiting immediately (+ {} similar warnings hidden)", (Object)this.getLocationInfo(), (Object)worldUnloadingWarningsHidden);
                worldUnloadingWarningsHidden = 0;
            } else {
                ++worldUnloadingWarningsHidden;
            }
            return;
        }
        if (shouldLogDebug) {
            LOGGER.debug("Bridge at {}: Beginning bridge-specific operations", (Object)this.worldPosition);
        }
        boolean bl = isDedicatedServer = level.getServer() != null && level.getServer().isDedicatedServer();
        if (isDedicatedServer && level.getGameTime() % 100L == 0L && (this.shouldReconnect || this.mainNode.getNode() == null || !this.mainNode.getNode().isActive())) {
            if (Config.enableDebugLogging) {
                LOGGER.info("Bridge at {}: Performing reconnection check for AE2 network on dedicated server", (Object)this.worldPosition);
            }
            this.forceAE2GridConnection();
            this.shouldReconnect = false;
        }
        if (worldUnloading) {
            if (this.initialized == 1) {
                this.onWorldUnload();
            }
            if ((long)worldUnloadingWarningsHidden == 300L) {
                LOGGER.warn("Bridge{}: WORLD UNLOADING DETECTED - entering cleanup mode (+ {} similar warnings hidden)", (Object)this.getLocationInfo(), (Object)worldUnloadingWarningsHidden);
                worldUnloadingWarningsHidden = 0;
            } else {
                ++worldUnloadingWarningsHidden;
            }
            return;
        }
        if (this.shouldReconnect && this.initialized == 1 && !this.nodeCreated) {
            LOGGER.warn("Bridge at {}: Reconnecting after world reload", (Object)this.worldPosition);
            if (this.mainNode.getNode() == null) {
                try {
                    this.mainNode.create(level, this.worldPosition);
                    this.nodeCreated = true;
                    this.forceNeighborUpdates();
                    this.updateConnectedState();
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    this.shouldReconnect = false;
                    LOGGER.warn("Bridge at {}: Reconnection completed successfully", (Object)this.worldPosition);
                }
                catch (Exception e) {
                    LOGGER.error("Bridge at {}: Failed to initialize AE2 node during reconnection: {}", new Object[]{this.worldPosition, e.getMessage(), e});
                    this.shouldReconnect = true;
                }
            }
        }
        if (this.initialized == 0) {
            ++this.initializationTicks;
            if (this.initializationTicks >= 60) {
                LOGGER.warn("Bridge at {}: Initialization completed after {} ticks", (Object)this.worldPosition, (Object)this.initializationTicks);
                this.initialized = 1;
                if (!level.isClientSide()) {
                    try {
                        this.forceNeighborUpdates();
                        this.updateConnectedState();
                        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                        IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                        LOGGER.warn("Bridge at {}: Post-initialization updates completed", (Object)this.worldPosition);
                    }
                    catch (Exception e) {
                        LOGGER.error("Bridge at {}: EXCEPTION during post-initialization updates: {}", new Object[]{this.worldPosition, e.getMessage(), e});
                    }
                }
            }
        }
        if (level.getGameTime() % 20L == 0L && this.initialized == 1) {
            try {
                this.transferItemsToAE2();
            }
            catch (Exception e) {
                LOGGER.error("Bridge at {}: EXCEPTION in transferItemsToAE2(): {}", new Object[]{this.worldPosition, e.getMessage(), e});
            }
        }
        if (this.patternUpdateTicks >= 100) {
            if (this.isActive() && this.getNetwork() != null) {
                try {
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    if (shouldLogDebug) {
                        LOGGER.debug("Bridge at {}: Periodic pattern update completed", (Object)this.worldPosition);
                    } else {
                        ++this.hiddenDebugMessages;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Bridge at {}: EXCEPTION during periodic pattern update: {}", new Object[]{this.worldPosition, e.getMessage(), e});
                }
            }
            this.patternUpdateTicks = 0;
        } else {
            ++this.patternUpdateTicks;
        }
        if (level.getGameTime() % 40L == 0L && this.isActive() && this.mainNode.getNode() != null) {
            try {
                IStorageService storageService;
                IGrid grid = this.mainNode.getNode().getGrid();
                if (grid != null && (storageService = grid.getStorageService()) != null) {
                    KeyCounter items = storageService.getInventory().getAvailableStacks();
                    items.forEach(entry -> {
                        long amount;
                        AEItemKey itemKey;
                        AEKey key = (AEKey)entry.getKey();
                        if (key instanceof AEItemKey && this.isVirtualMatterItem((itemKey = (AEItemKey)key).getItem()) && (amount = entry.getLongValue()) > 0L) {
                            try {
                                MachineSource machineSource = new MachineSource((IActionHost)this);
                                storageService.getInventory().extract((AEKey)itemKey, amount, Actionable.MODULATE, (IActionSource)machineSource);
                            }
                            catch (Exception e) {
                                LOGGER.error("Bridge at {}: EXCEPTION removing virtual matter items: {}", new Object[]{this.worldPosition, e.getMessage(), e});
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge at {}: EXCEPTION during virtual matter cleanup: {}", new Object[]{this.worldPosition, e.getMessage(), e});
            }
        }
        if (this.requestCounterTicks >= 100) {
            try {
                if (worldUnloading) {
                    if (this.initialized == 1) {
                        this.onWorldUnload();
                    }
                    if ((long)worldUnloadingWarningsHidden == 300L) {
                        LOGGER.warn("Bridge{}: World unloading detected during request processing - aborting (+ {} similar warnings hidden)", (Object)this.getLocationInfo(), (Object)worldUnloadingWarningsHidden);
                        worldUnloadingWarningsHidden = 0;
                    } else {
                        ++worldUnloadingWarningsHidden;
                    }
                    return;
                }
                MatterNetwork network = this.getNetwork();
                if (network != null && !this.requestCounters.isEmpty()) {
                    Map<ItemWithSourceId, Integer> sourceCounters;
                    int totalItems = 0;
                    for (UUID sourceId : this.requestCounters.keySet()) {
                        sourceCounters = this.requestCounters.get(sourceId);
                        Iterator<Object> iterator = sourceCounters.values().iterator();
                        while (iterator.hasNext()) {
                            int n = iterator.next();
                            totalItems += n;
                        }
                    }
                    for (UUID sourceId : this.requestCounters.keySet()) {
                        if (worldUnloading) {
                            ++worldUnloadingWarningsHidden;
                            if (this.initialized == 1) {
                                this.onWorldUnload();
                            }
                            return;
                        }
                        sourceCounters = this.requestCounters.get(sourceId);
                        for (Map.Entry entry2 : sourceCounters.entrySet()) {
                            if (worldUnloading) {
                                ++worldUnloadingWarningsHidden;
                                if (this.initialized == 1) {
                                    this.onWorldUnload();
                                }
                                return;
                            }
                            ItemWithSourceId key = (ItemWithSourceId)entry2.getKey();
                            ItemStack itemStack = key.getItemStack();
                            int count = (Integer)entry2.getValue();
                            if (count <= 0) continue;
                            block20: for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                                if (worldUnloading) {
                                    ++worldUnloadingWarningsHidden;
                                    if (this.initialized == 1) {
                                        this.onWorldUnload();
                                    }
                                    return;
                                }
                                BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                                if (!(tile instanceof ChipStorageBlockEntity)) continue;
                                ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                                for (MatterPattern pattern : chipStorage.getPatterns(level, chipStorage)) {
                                    if (worldUnloading) {
                                        ++worldUnloadingWarningsHidden;
                                        if (this.initialized == 1) {
                                            this.onWorldUnload();
                                        }
                                        return;
                                    }
                                    if (!pattern.getStack().getItem().equals(itemStack.getItem())) continue;
                                    ReplicationTask task = new ReplicationTask(pattern.getStack(), count, IReplicationTask.Mode.MULTIPLE, this.worldPosition);
                                    String taskId = task.getUuid().toString();
                                    network.getTaskManager().getPendingTasks().put(taskId, task);
                                    TaskSourceInfo info = new TaskSourceInfo(itemStack, sourceId);
                                    Map sourceTasks = this.activeTasks.getOrDefault(sourceId, new HashMap());
                                    sourceTasks.put(taskId, info);
                                    this.activeTasks.put(sourceId, sourceTasks);
                                    Map sourceRequests = this.patternRequestsBySource.getOrDefault(sourceId, new HashMap());
                                    int currentPatternRequests = sourceRequests.getOrDefault(itemStack, 0);
                                    sourceRequests.put(itemStack, currentPatternRequests + count);
                                    this.patternRequestsBySource.put(sourceId, sourceRequests);
                                    Map globalRequests = this.patternRequests.getOrDefault(sourceId, new HashMap());
                                    int currentGlobalRequests = globalRequests.getOrDefault(itemStack, 0);
                                    globalRequests.put(itemStack, currentGlobalRequests + count);
                                    this.patternRequests.put(sourceId, globalRequests);
                                    MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                                    if (matterCompound == null) continue block20;
                                    for (MatterValue matterValue : matterCompound.getValues().values()) {
                                        IMatterType matterType = matterValue.getMatter();
                                        long matterAmount = (long)Math.ceil(matterValue.getAmount()) * (long)count;
                                        Item matterItem = this.getItemForMatterType(matterType);
                                        if (matterItem == null) continue;
                                        AEItemKey matterKey = AEItemKey.of((ItemLike)matterItem);
                                        long l = this.extract((AEKey)matterKey, matterAmount, Actionable.MODULATE);
                                    }
                                    continue block20;
                                }
                            }
                        }
                    }
                }
                this.requestCounters.clear();
                this.requestCounterTicks = 0;
            }
            catch (Exception e) {
                LOGGER.error("Bridge at {}: EXCEPTION in creating tasks: {}", new Object[]{this.worldPosition, e.getMessage(), e});
            }
        } else {
            ++this.requestCounterTicks;
        }
        if (this.getNetwork() == null && (networkManager = NetworkManager.get((Level)level)) != null && networkManager.getElement(pos) == null) {
            networkManager.addElement(this.createElement(level, pos));
        }
        if (!this.pendingPatterns.isEmpty() && !this.isBusy()) {
            IPatternDetails pattern = this.pendingPatterns.poll();
            KeyCounter[] inputs = this.pendingInputs.remove(pattern);
            if (pattern != null && inputs != null) {
                this.pushPattern(pattern, inputs);
            }
        }
        if (level.getGameTime() % 40L == 0L) {
            if (!this.isActive() && this.shouldReconnect) {
                try {
                    if (this.mainNode.getNode() == null && !this.nodeCreated) {
                        this.mainNode.create(level, this.worldPosition);
                        this.nodeCreated = true;
                        this.forceNeighborUpdates();
                        this.updateConnectedState();
                        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    } else {
                        this.forceNeighborUpdates();
                    }
                    this.shouldReconnect = false;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to reconnect AE2 node: {}", (Object)e.getMessage());
                }
            }
            this.updateConnectedState();
        }
        this.terminalPlayerTracker.checkIfValid();
    }

    public boolean isPowered() {
        return true;
    }

    public MatterNetwork getNetwork() {
        block12: {
            if (this.level == null || this.level.isClientSide()) {
                return null;
            }
            if (worldUnloading) {
                if ((long)worldUnloadingWarningsHidden == 300L) {
                    LOGGER.warn("Bridge{}: getNetwork() called during world unloading - returning null (+ {} similar warnings hidden)", (Object)this.getLocationInfo(), (Object)worldUnloadingWarningsHidden);
                    worldUnloadingWarningsHidden = 0;
                } else {
                    ++worldUnloadingWarningsHidden;
                }
                return null;
            }
            try {
                Network network;
                NetworkManager networkManager = NetworkManager.get((Level)this.level);
                if (networkManager == null) {
                    LOGGER.error("Bridge at {}: NetworkManager not found!", (Object)this.worldPosition);
                    return null;
                }
                NetworkElement element = networkManager.getElement(this.worldPosition);
                if (element == null) {
                    if (worldUnloading) {
                        ++worldUnloadingWarningsHidden;
                        return null;
                    }
                    LOGGER.warn("Bridge at {}: Creating new network element", (Object)this.worldPosition);
                    element = this.createElement(this.level, this.worldPosition);
                    if (element != null) {
                        networkManager.addElement(element);
                        this.forceNeighborUpdates();
                        LOGGER.warn("Bridge at {}: Network element created and added successfully", (Object)this.worldPosition);
                    } else {
                        LOGGER.error("Bridge at {}: Failed to create network element!", (Object)this.worldPosition);
                    }
                }
                if (element != null && (network = element.getNetwork()) instanceof MatterNetwork) {
                    MatterNetwork matterNetwork = (MatterNetwork)network;
                    return matterNetwork;
                }
                LOGGER.error("Bridge at {}: Network element exists but is not a MatterNetwork!", (Object)this.worldPosition);
            }
            catch (Exception e) {
                LOGGER.error("Bridge at {}: EXCEPTION accessing Replication network: {}", new Object[]{this.worldPosition, e.getMessage(), e});
                if (!worldUnloading) break block12;
                ++worldUnloadingWarningsHidden;
            }
        }
        return null;
    }

    public boolean isActive() {
        if (worldUnloading) {
            if ((long)worldUnloadingWarningsHidden == 300L) {
                LOGGER.warn("Bridge{}: isActive() returning false due to world unloading (+ {} similar warnings hidden)", (Object)this.getLocationInfo(), (Object)worldUnloadingWarningsHidden);
                worldUnloadingWarningsHidden = 0;
            } else {
                ++worldUnloadingWarningsHidden;
            }
            return false;
        }
        try {
            boolean active;
            boolean bl = active = this.mainNode.isActive() && this.mainNode.getNode() != null;
            if (!active) {
                if (globalShouldLogDebug) {
                    LOGGER.debug("Bridge at {}: isActive() = false (node inactive or null)", (Object)this.worldPosition);
                } else {
                    ++globalHiddenDebugMessages;
                }
            }
            return active;
        }
        catch (Exception e) {
            LOGGER.error("Bridge at {}: EXCEPTION checking node activity: {}", new Object[]{this.worldPosition, e.getMessage(), e});
            return false;
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (this.level != null && !this.level.isClientSide()) {
            try {
                GridHelper.onFirstTick((BlockEntity)this, blockEntity -> {
                    boolean nodeAlreadyExists;
                    boolean bl = nodeAlreadyExists = this.mainNode.getNode() != null;
                    if (!(!this.shouldReconnect && this.nodeCreated || nodeAlreadyExists)) {
                        this.mainNode.create(this.level, this.worldPosition);
                        this.nodeCreated = true;
                        this.forceNeighborUpdates();
                        this.updateConnectedState();
                        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                        this.shouldReconnect = false;
                    } else if (nodeAlreadyExists) {
                        this.nodeCreated = true;
                        this.shouldReconnect = false;
                        this.forceNeighborUpdates();
                        this.updateConnectedState();
                        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                        LOGGER.debug("Bridge: AE2 node already exists, skipping creation");
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Failed to schedule AE2 node initialization: {}", (Object)e.getMessage());
            }
        }
    }

    private MatterNetwork getReplicationNetwork() {
        return this.getNetwork();
    }

    public ItemInteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (!this.level.isClientSide() && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            this.openGui(playerIn);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public TerminalPlayerTracker getTerminalPlayerTracker() {
        return this.terminalPlayerTracker;
    }

    public InventoryComponent<RepAE2BridgeBlockEntity> getOutput() {
        return this.output;
    }

    public boolean receiveItemFromReplicator(ItemStack stack) {
        IStorageService storageService;
        IGrid grid;
        if (stack.isEmpty()) {
            return false;
        }
        boolean insertedIntoAE2 = false;
        long remainingCount = stack.getCount();
        if (this.mainNode.isActive() && this.mainNode.getNode() != null && (grid = this.mainNode.getNode().getGrid()) != null && (storageService = grid.getStorageService()) != null) {
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            long inserted = storageService.getInventory().insert((AEKey)key, (long)stack.getCount(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
            if (inserted > 0L) {
                for (int i = 0; i < this.output.getSlots(); ++i) {
                    ItemStack slotStack = this.output.getStackInSlot(i);
                    if (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)stack)) continue;
                    int toRemove = (int)Math.min(inserted, (long)slotStack.getCount());
                    slotStack.shrink(toRemove);
                    if ((inserted -= (long)toRemove) <= 0L) break;
                }
                insertedIntoAE2 = true;
                if ((remainingCount -= inserted) <= 0L) {
                    return true;
                }
            }
        }
        if (remainingCount > 0L) {
            ItemStack remainingStack = stack.copy();
            remainingStack.setCount((int)remainingCount);
            ItemStack notInserted = ItemHandlerHelper.insertItem(this.output, (ItemStack)remainingStack, (boolean)false);
            if (notInserted.isEmpty()) {
                this.setChanged();
                return true;
            }
            if ((long)notInserted.getCount() < remainingCount) {
                this.setChanged();
                return insertedIntoAE2 || notInserted.getCount() < stack.getCount();
            }
            return insertedIntoAE2;
        }
        return true;
    }

    public void handleCompletedTask(IReplicationTask task, ItemStack stack) {
        boolean inserted = this.receiveItemFromReplicator(stack);
        if (!inserted) {
            // empty if block
        }
        UUID sourceId = this.blockId;
        if (task.getSource().equals((Object)this.worldPosition)) {
            Map globalRequests;
            int currentGlobalCount;
            Map sourceRequests = this.patternRequestsBySource.getOrDefault(sourceId, new HashMap());
            int currentCount = sourceRequests.getOrDefault(stack, 0);
            if (currentCount > 0) {
                sourceRequests.put(stack, currentCount - 1);
                this.patternRequestsBySource.put(sourceId, sourceRequests);
            }
            if ((currentGlobalCount = (globalRequests = (Map)this.patternRequests.getOrDefault(sourceId, new HashMap())).getOrDefault(stack, 0).intValue()) > 0) {
                globalRequests.put(stack, currentGlobalCount - 1);
                this.patternRequests.put(sourceId, globalRequests);
            }
        }
    }

    public void insert(AEKey what, long amount, Actionable mode) {
        if (mode == Actionable.MODULATE && what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            MatterNetwork network = this.getNetwork();
            if (network != null) {
                for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                    BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                    if (!(tile instanceof ChipStorageBlockEntity)) continue;
                    ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                    for (MatterPattern pattern : chipStorage.getPatterns(this.level, chipStorage)) {
                        if (!pattern.getStack().getItem().equals(itemKey.getItem())) continue;
                        return;
                    }
                }
            }
        }
    }

    public long extract(AEKey what, long amount, Actionable mode) {
        AEItemKey itemKey;
        Item item;
        if (what instanceof AEItemKey && this.isVirtualMatterItem(item = (itemKey = (AEItemKey)what).getItem())) {
            MachineSource machineSource = new MachineSource((IActionHost)this);
            return this.matterItemsStorage.extract(what, amount, mode, (IActionSource)machineSource);
        }
        MatterNetwork network = this.getNetwork();
        if (network != null && what instanceof AEItemKey) {
            AEItemKey itemKey2 = (AEItemKey)what;
            for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                if (!(tile instanceof ChipStorageBlockEntity)) continue;
                ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                for (MatterPattern pattern : chipStorage.getPatterns(this.level, chipStorage)) {
                    if (!pattern.getStack().getItem().equals(itemKey2.getItem())) continue;
                    return amount;
                }
            }
        }
        return 0L;
    }

    public Iterable<AEKey> findFuzzyTemplates(AEKey input) {
        if (input instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)input;
            MatterNetwork network = this.getNetwork();
            if (network != null) {
                ArrayList<AEKey> templates = new ArrayList<AEKey>();
                for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                    BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                    if (!(tile instanceof ChipStorageBlockEntity)) continue;
                    ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                    for (MatterPattern pattern : chipStorage.getPatterns(this.level, chipStorage)) {
                        templates.add((AEKey)AEItemKey.of((ItemLike)pattern.getStack().getItem()));
                    }
                }
                return templates;
            }
        }
        return List.of();
    }

    public List<IPatternDetails> getAvailablePatterns() {
        if (this.initialized != 1) {
            return List.of();
        }
        ArrayList<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
        MatterNetwork network = this.getNetwork();
        if (network != null) {
            for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                if (!(tile instanceof ChipStorageBlockEntity)) continue;
                ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                for (MatterPattern pattern : chipStorage.getPatterns(this.level, chipStorage)) {
                    if (pattern.getStack().isEmpty() || pattern.getCompletion() != 1.0f) continue;
                    try {
                        ItemStack patternStack = new ItemStack((ItemLike)AEItems.BLANK_PATTERN.asItem());
                        AEItemKey output = AEItemKey.of((ItemLike)pattern.getStack().getItem());
                        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                        if (matterCompound == null) continue;
                        ArrayList<GenericStack> inputs = new ArrayList<GenericStack>();
                        for (MatterValue matterValue : matterCompound.getValues().values()) {
                            IMatterType matterType = matterValue.getMatter();
                            long matterAmount = (long)Math.ceil(matterValue.getAmount());
                            Item matterItem = this.getItemForMatterType(matterType);
                            if (matterItem == null) continue;
                            inputs.add(new GenericStack((AEKey)AEItemKey.of((ItemLike)matterItem), matterAmount));
                        }
                        ArrayList<GenericStack> outputs = new ArrayList<GenericStack>();
                        outputs.add(new GenericStack((AEKey)output, 1L));
                        AEProcessingPattern.encode((ItemStack)patternStack, inputs, outputs);
                        AEProcessingPattern aePattern = new AEProcessingPattern(AEItemKey.of((ItemStack)patternStack));
                        patterns.add((IPatternDetails)aePattern);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return patterns;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        GenericStack output;
        Object object;
        if (this.initialized != 1) {
            return false;
        }
        MatterNetwork network = this.getNetwork();
        if (network != null && this.isActive() && patternDetails != null && patternDetails.getOutputs().size() == 1 && (object = (output = (GenericStack)patternDetails.getOutputs().iterator().next()).what()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)object;
            if (this.isBusy()) {
                this.pendingPatterns.add(patternDetails);
                this.pendingInputs.put(patternDetails, inputHolder);
                return true;
            }
            for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                if (!(tile instanceof ChipStorageBlockEntity)) continue;
                ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                for (MatterPattern pattern : chipStorage.getPatterns(this.level, chipStorage)) {
                    if (!pattern.getStack().getItem().equals(itemKey.getItem())) continue;
                    if (inputHolder != null && inputHolder.length > 0) {
                        KeyCounter inputs = inputHolder[0];
                        boolean hasAllMatter = true;
                        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                        if (matterCompound != null) {
                            long matterAmount;
                            IMatterType matterType;
                            for (MatterValue matterValue : matterCompound.getValues().values()) {
                                matterType = matterValue.getMatter();
                                matterAmount = (long)Math.ceil(matterValue.getAmount());
                                long available = network.calculateMatterAmount(matterType);
                                if (available >= matterAmount) continue;
                                hasAllMatter = false;
                                String warningKey = itemKey.getItem().getDescriptionId() + ":" + matterType.getName();
                                long currentTime = this.level.getGameTime();
                                if (this.lastMatterWarnings.containsKey(warningKey) && currentTime - this.lastMatterWarnings.get(warningKey) <= 600L) break;
                                this.lastMatterWarnings.put(warningKey, currentTime);
                                break;
                            }
                            if (hasAllMatter) {
                                for (MatterValue matterValue : matterCompound.getValues().values()) {
                                    matterType = matterValue.getMatter();
                                    matterAmount = (long)Math.ceil(matterValue.getAmount());
                                    Item matterItem = this.getItemForMatterType(matterType);
                                    if (matterItem == null) continue;
                                    AEItemKey matterKey = AEItemKey.of((ItemLike)matterItem);
                                    long l = this.extract((AEKey)matterKey, matterAmount, Actionable.MODULATE);
                                }
                            } else {
                                return false;
                            }
                        }
                    }
                    ItemStack itemStack = pattern.getStack();
                    ItemWithSourceId key = new ItemWithSourceId(itemStack, this.blockId);
                    Map sourceCounters = this.requestCounters.getOrDefault(this.blockId, new HashMap());
                    int currentCount = sourceCounters.getOrDefault(key, 0);
                    sourceCounters.put(key, currentCount + 1);
                    this.requestCounters.put(this.blockId, sourceCounters);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBusy() {
        MatterNetwork network = this.getNetwork();
        if (network != null) {
            boolean busy;
            HashSet networkTaskIds = new HashSet(network.getTaskManager().getPendingTasks().keySet());
            for (UUID sourceId : this.activeTasks.keySet()) {
                Map<String, TaskSourceInfo> sourceTasks = this.activeTasks.get(sourceId);
                HashSet<String> taskIds = new HashSet<String>(sourceTasks.keySet());
                for (String taskId : taskIds) {
                    Map globalRequests;
                    int currentGlobalCount;
                    TaskSourceInfo info;
                    if (networkTaskIds.contains(taskId) || (info = sourceTasks.remove(taskId)) == null) continue;
                    ItemStack pattern = info.getItemStack();
                    Map sourceRequests = this.patternRequestsBySource.getOrDefault(sourceId, new HashMap());
                    int currentCount = sourceRequests.getOrDefault(pattern, 0);
                    if (currentCount > 0) {
                        sourceRequests.put(pattern, currentCount - 1);
                        this.patternRequestsBySource.put(sourceId, sourceRequests);
                    }
                    if ((currentGlobalCount = (globalRequests = (Map)this.patternRequests.getOrDefault(sourceId, new HashMap())).getOrDefault(pattern, 0).intValue()) <= 0) continue;
                    globalRequests.put(pattern, currentGlobalCount - 1);
                    this.patternRequests.put(sourceId, globalRequests);
                }
                if (sourceTasks.isEmpty()) {
                    this.activeTasks.remove(sourceId);
                    continue;
                }
                this.activeTasks.put(sourceId, sourceTasks);
            }
            boolean bl = busy = !network.getTaskManager().getPendingTasks().isEmpty();
            if (!busy && this.requestCounters.isEmpty()) {
                IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
            }
            return busy;
        }
        return false;
    }

    public int getPatternPriority() {
        return this.priority;
    }

    public Future<ICraftingPlan> beginCraftingCalculation(Level level, ICraftingSimulationRequester simRequester, AEKey what, final long amount, CalculationStrategy strategy) {
        if (what instanceof AEItemKey) {
            final AEItemKey itemKey = (AEItemKey)what;
            MatterNetwork network = this.getNetwork();
            if (network != null) {
                for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                    BlockEntity tile = chipSupplier.getLevel().getBlockEntity(chipSupplier.getPos());
                    if (!(tile instanceof ChipStorageBlockEntity)) continue;
                    ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                    for (MatterPattern pattern : chipStorage.getPatterns(level, chipStorage)) {
                        if (!pattern.getStack().getItem().equals(itemKey.getItem())) continue;
                        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                        if (matterCompound != null) {
                            boolean hasEnoughMatter = true;
                            HashMap<IMatterType, Long> missingMatter = new HashMap<IMatterType, Long>();
                            for (MatterValue matterValue : matterCompound.getValues().values()) {
                                IMatterType matterType = matterValue.getMatter();
                                double matterPerItem = matterValue.getAmount();
                                long totalMatterNeeded = (long)(matterPerItem * (double)amount);
                                long available = network.calculateMatterAmount(matterType);
                                if (available >= totalMatterNeeded) continue;
                                hasEnoughMatter = false;
                                missingMatter.put(matterType, totalMatterNeeded - available);
                                String warningKey = itemKey.getItem().getDescriptionId() + ":" + matterType.getName();
                                long currentTime = level.getGameTime();
                                if (this.lastMatterWarnings.containsKey(warningKey) && currentTime - this.lastMatterWarnings.get(warningKey) <= 600L) continue;
                                this.lastMatterWarnings.put(warningKey, currentTime);
                            }
                            if (!hasEnoughMatter) {
                                StringBuilder errorMsg = new StringBuilder();
                                errorMsg.append("Not enough matter available. Missing:\n");
                                for (Map.Entry entry : missingMatter.entrySet()) {
                                    errorMsg.append("- ").append(entry.getValue()).append(" ").append(((IMatterType)entry.getKey()).toString()).append("\n");
                                }
                                return CompletableFuture.failedFuture(new IllegalStateException(errorMsg.toString()));
                            }
                            return CompletableFuture.completedFuture(new ICraftingPlan(){

                                public GenericStack finalOutput() {
                                    return new GenericStack((AEKey)AEItemKey.of((ItemLike)itemKey.getItem()), amount);
                                }

                                public long bytes() {
                                    return 0L;
                                }

                                public boolean simulation() {
                                    return false;
                                }

                                public boolean multiplePaths() {
                                    return false;
                                }

                                public KeyCounter usedItems() {
                                    return new KeyCounter();
                                }

                                public KeyCounter emittedItems() {
                                    return new KeyCounter();
                                }

                                public KeyCounter missingItems() {
                                    return new KeyCounter();
                                }

                                public Map<IPatternDetails, Long> patternTimes() {
                                    return Map.of();
                                }
                            });
                        }
                        return CompletableFuture.failedFuture(new IllegalStateException("Cannot calculate required matter"));
                    }
                }
                return CompletableFuture.failedFuture(new IllegalStateException("No pattern found for this item"));
            }
            return CompletableFuture.failedFuture(new IllegalStateException("No Replication network found"));
        }
        return CompletableFuture.failedFuture(new IllegalStateException("Cannot craft this item"));
    }

    private Item getItemForMatterType(IMatterType type) {
        String name = type.getName();
        if (name.equalsIgnoreCase("earth")) {
            return (Item)ModItems.EARTH_MATTER.get();
        }
        if (name.equalsIgnoreCase("nether")) {
            return (Item)ModItems.NETHER_MATTER.get();
        }
        if (name.equalsIgnoreCase("organic")) {
            return (Item)ModItems.ORGANIC_MATTER.get();
        }
        if (name.equalsIgnoreCase("ender")) {
            return (Item)ModItems.ENDER_MATTER.get();
        }
        if (name.equalsIgnoreCase("metallic")) {
            return (Item)ModItems.METALLIC_MATTER.get();
        }
        if (name.equalsIgnoreCase("precious")) {
            return (Item)ModItems.PRECIOUS_MATTER.get();
        }
        if (name.equalsIgnoreCase("living")) {
            return (Item)ModItems.LIVING_MATTER.get();
        }
        if (name.equalsIgnoreCase("quantum")) {
            return (Item)ModItems.QUANTUM_MATTER.get();
        }
        return null;
    }

    private boolean isVirtualMatterItem(Item item) {
        return item == ModItems.EARTH_MATTER.get() || item == ModItems.NETHER_MATTER.get() || item == ModItems.ORGANIC_MATTER.get() || item == ModItems.ENDER_MATTER.get() || item == ModItems.METALLIC_MATTER.get() || item == ModItems.PRECIOUS_MATTER.get() || item == ModItems.LIVING_MATTER.get() || item == ModItems.QUANTUM_MATTER.get();
    }

    public void getAvailableItems(KeyCounter items) {
        if (this.initialized != 1) {
            return;
        }
        MatterNetwork network = this.getNetwork();
        if (network != null) {
            List<IMatterType> matterTypes = List.of((IMatterType)ReplicationRegistry.Matter.EMPTY.get(), (IMatterType)ReplicationRegistry.Matter.METALLIC.get(), (IMatterType)ReplicationRegistry.Matter.EARTH.get(), (IMatterType)ReplicationRegistry.Matter.NETHER.get(), (IMatterType)ReplicationRegistry.Matter.ORGANIC.get(), (IMatterType)ReplicationRegistry.Matter.ENDER.get(), (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get(), (IMatterType)ReplicationRegistry.Matter.QUANTUM.get(), (IMatterType)ReplicationRegistry.Matter.LIVING.get());
            for (IMatterType matterType : matterTypes) {
                Item item;
                long amount = network.calculateMatterAmount(matterType);
                if (amount <= 0L || (item = this.getItemForMatterType(matterType)) == null) continue;
                items.add((AEKey)AEItemKey.of((ItemLike)item), amount);
            }
        }
    }

    public void mountInventories(IStorageMounts storageMounts) {
        if (this.initialized != 1) {
            return;
        }
        storageMounts.mount((MEStorage)this.matterItemsStorage, 100);
    }

    public void handleReplicationNetworkEvent() {
        if (this.isActive() && this.level != null && !this.level.isClientSide()) {
            ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
        }
    }

    private IMatterType getMatterTypeForItem(Item item) {
        if (item == ModItems.EARTH_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.EARTH.get();
        }
        if (item == ModItems.NETHER_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.NETHER.get();
        }
        if (item == ModItems.ORGANIC_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.ORGANIC.get();
        }
        if (item == ModItems.ENDER_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.ENDER.get();
        }
        if (item == ModItems.METALLIC_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.METALLIC.get();
        }
        if (item == ModItems.PRECIOUS_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get();
        }
        if (item == ModItems.LIVING_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.LIVING.get();
        }
        if (item == ModItems.QUANTUM_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.QUANTUM.get();
        }
        return null;
    }

    public static void cancelAllPendingOperations() {
        try {
            if ((long)globalOperationLogsHidden == 300L) {
                LOGGER.error("GLOBAL OPERATION CANCELLATION - Starting cleanup (+ {} hidden identical messages in last 15s)", (Object)globalOperationLogsHidden);
                LOGGER.error("GLOBAL OPERATION CANCELLATION - All pending operations marked for cancellation");
                globalOperationLogsHidden = 0;
            } else {
                ++globalOperationLogsHidden;
            }
        }
        catch (Exception e) {
            LOGGER.error("GLOBAL OPERATION CANCELLATION - EXCEPTION during cleanup: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void onWorldUnload() {
        LOGGER.error("Bridge{}: onWorldUnload() called - CRITICAL CLEANUP STARTING", (Object)this.getLocationInfo());
        try {
            LOGGER.error("Bridge{}: Setting world unloading flag locally", (Object)this.getLocationInfo());
            worldUnloading = true;
            LOGGER.error("Bridge{}: Starting AE2 node destruction", (Object)this.getLocationInfo());
            if (this.mainNode != null) {
                try {
                    this.mainNode.destroy();
                    LOGGER.error("Bridge{}: AE2 node destruction successful", (Object)this.getLocationInfo());
                }
                catch (Exception e) {
                    LOGGER.error("Bridge{}: EXCEPTION destroying AE2 node in onWorldUnload: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
                }
            } else {
                LOGGER.warn("Bridge{}: AE2 node was null during onWorldUnload", (Object)this.getLocationInfo());
            }
            LOGGER.error("Bridge{}: Clearing data structures", (Object)this.getLocationInfo());
            try {
                this.pendingPatterns.clear();
                this.pendingInputs.clear();
                this.patternRequests.clear();
                this.activeTasks.clear();
                this.patternRequestsBySource.clear();
                this.requestCounters.clear();
                if (this.terminalPlayerTracker != null) {
                    this.terminalPlayerTracker = null;
                }
                this.lastMatterWarnings.clear();
                this.initializationTicks = 0;
                LOGGER.error("Bridge{}: Data structures cleared successfully", (Object)this.getLocationInfo());
            }
            catch (Exception e) {
                LOGGER.error("Bridge{}: EXCEPTION clearing data structures: {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
            }
            LOGGER.error("Bridge{}: Resetting connection flags", (Object)this.getLocationInfo());
            this.nodeCreated = false;
            this.shouldReconnect = false;
            this.initialized = 0;
            LOGGER.error("Bridge{}: Parent class cleanup not needed (no super.onWorldUnload)", (Object)this.getLocationInfo());
            LOGGER.error("Bridge{}: onWorldUnload() CRITICAL CLEANUP COMPLETED", (Object)this.getLocationInfo());
        }
        catch (Exception e) {
            LOGGER.error("Bridge{}: FATAL EXCEPTION in onWorldUnload(): {}", new Object[]{this.getLocationInfo(), e.getMessage(), e});
        }
    }

    public UUID getBlockId() {
        return this.blockId;
    }

    public int getActiveRequestsForThisBlock() {
        Map requests = this.patternRequestsBySource.getOrDefault(this.blockId, new HashMap());
        return requests.values().stream().mapToInt(Integer::intValue).sum();
    }

    public int getActiveRequestsForItem(Item item) {
        Map requests = this.patternRequestsBySource.getOrDefault(this.blockId, new HashMap());
        return requests.entrySet().stream().filter(entry -> ((ItemStack)entry.getKey()).getItem() == item).mapToInt(Map.Entry::getValue).sum();
    }

    public int getTotalActiveRequests() {
        int total = 0;
        for (Map<ItemStack, Integer> sourceRequests : this.patternRequestsBySource.values()) {
            total += sourceRequests.values().stream().mapToInt(Integer::intValue).sum();
        }
        return total;
    }

    private void transferItemsToAE2() {
        if (!this.mainNode.isActive() || this.mainNode.getNode() == null) {
            return;
        }
        IGrid grid = this.mainNode.getNode().getGrid();
        if (grid == null) {
            return;
        }
        IStorageService storageService = grid.getStorageService();
        if (storageService == null) {
            return;
        }
        boolean itemsMoved = false;
        for (int i = 0; i < this.output.getSlots(); ++i) {
            ItemStack stack = this.output.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            long inserted = storageService.getInventory().insert((AEKey)key, (long)stack.getCount(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
            if (inserted <= 0L) continue;
            stack.shrink((int)inserted);
            itemsMoved = true;
        }
        if (itemsMoved) {
            this.setChanged();
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.setChanged();
    }

    public ItemStack getMainMenuIcon() {
        return ((Block)ModBlocks.REPAE2BRIDGE.get()).asItem().getDefaultInstance();
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.closeContainer();
        }
    }

    public void openGui(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuOpener.open((MenuType)PriorityMenu.TYPE, (Player)serverPlayer, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)this));
        }
    }

    public class MatterItemsStorage
    implements MEStorage {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return 0L;
            }
            return 0L;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            IMatterType matterType;
            MatterNetwork network;
            AEItemKey itemKey;
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return 0L;
            }
            if (what instanceof AEItemKey && RepAE2BridgeBlockEntity.this.isVirtualMatterItem((itemKey = (AEItemKey)what).getItem()) && (network = RepAE2BridgeBlockEntity.this.getNetwork()) != null && (matterType = RepAE2BridgeBlockEntity.this.getMatterTypeForItem(itemKey.getItem())) != null) {
                long available = network.calculateMatterAmount(matterType);
                if (available < amount) {
                    // empty if block
                }
                long toExtract = Math.min(amount, available);
                if (mode == Actionable.SIMULATE) {
                    return toExtract;
                }
                if (toExtract > 0L) {
                    return toExtract;
                }
            }
            return 0L;
        }

        public boolean isAutomationPart(IActionSource source) {
            if (source.machine().isPresent()) {
                IActionHost machine = (IActionHost)source.machine().get();
                String machineClass = machine.getClass().getName();
                return machineClass.contains("appeng.parts.autom");
            }
            return false;
        }

        public Component getDescription() {
            return Component.literal((String)"Replication Matter Storage");
        }

        public void getAvailableStacks(KeyCounter out) {
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return;
            }
            MatterNetwork network = RepAE2BridgeBlockEntity.this.getNetwork();
            if (network != null) {
                List<IMatterType> matterTypes = List.of((IMatterType)ReplicationRegistry.Matter.EMPTY.get(), (IMatterType)ReplicationRegistry.Matter.METALLIC.get(), (IMatterType)ReplicationRegistry.Matter.EARTH.get(), (IMatterType)ReplicationRegistry.Matter.NETHER.get(), (IMatterType)ReplicationRegistry.Matter.ORGANIC.get(), (IMatterType)ReplicationRegistry.Matter.ENDER.get(), (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get(), (IMatterType)ReplicationRegistry.Matter.QUANTUM.get(), (IMatterType)ReplicationRegistry.Matter.LIVING.get());
                for (IMatterType matterType : matterTypes) {
                    Item item;
                    long amount = network.calculateMatterAmount(matterType);
                    if (amount <= 0L || (item = RepAE2BridgeBlockEntity.this.getItemForMatterType(matterType)) == null) continue;
                    out.add((AEKey)AEItemKey.of((ItemLike)item), amount);
                }
            }
        }
    }

    public static class TerminalPlayerTracker {
        private List<ServerPlayer> players = new ArrayList<ServerPlayer>();
        private List<UUID> uuidsToRemove = new ArrayList<UUID>();
        private List<ServerPlayer> playersToAdd = new ArrayList<ServerPlayer>();

        public void checkIfValid() {
            ArrayList<ServerPlayer> output = new ArrayList<ServerPlayer>(this.playersToAdd);
            ArrayList<ServerPlayer> input = new ArrayList<ServerPlayer>(this.players);
            for (ServerPlayer serverPlayer : input) {
                if (this.uuidsToRemove.contains(serverPlayer.getUUID())) continue;
                output.add(serverPlayer);
            }
            this.players = output;
            this.uuidsToRemove = new ArrayList<UUID>();
            this.playersToAdd = new ArrayList<ServerPlayer>();
        }

        public void removePlayer(ServerPlayer serverPlayer) {
            this.uuidsToRemove.add(serverPlayer.getUUID());
        }

        public void addPlayer(ServerPlayer serverPlayer) {
            this.playersToAdd.add(serverPlayer);
        }

        public List<ServerPlayer> getPlayers() {
            return this.players;
        }
    }

    public static class ItemWithSourceId {
        private final ItemStack itemStack;
        private final UUID sourceId;

        public ItemWithSourceId(ItemStack itemStack, UUID sourceId) {
            this.itemStack = itemStack.copy();
            this.sourceId = sourceId;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public UUID getSourceId() {
            return this.sourceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemWithSourceId that = (ItemWithSourceId)o;
            return ItemStack.matches((ItemStack)this.itemStack, (ItemStack)that.itemStack) && Objects.equals(this.sourceId, that.sourceId);
        }

        public int hashCode() {
            return Objects.hash(this.itemStack.getItem(), this.sourceId);
        }
    }

    public static class TaskSourceInfo {
        private final ItemStack itemStack;
        private final UUID sourceId;

        public TaskSourceInfo(ItemStack itemStack, UUID sourceId) {
            this.itemStack = itemStack.copy();
            this.sourceId = sourceId;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public UUID getSourceId() {
            return this.sourceId;
        }
    }
}

