/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.events;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.unfamily.repae2bridge.block.entity.RepAE2BridgeBlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber
public class ServerLifecycleEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLifecycleEventHandler.class);
    private static final long THROTTLE_INTERVAL_TICKS = 300L;
    private static int serverStoppingLogsHidden = 0;
    private static int serverStartingLogsHidden = 0;

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        try {
            RepAE2BridgeBlockEntity.setWorldUnloading(true);
            RepAE2BridgeBlockEntity.cancelAllPendingOperations();
            if ((long)serverStoppingLogsHidden == 300L) {
                LOGGER.warn("RepAE2Bridge - Server Stopping: Server stopping detected - emergency cleanup (+ {} similar events hidden in last 15s)", (Object)serverStoppingLogsHidden);
                serverStoppingLogsHidden = 0;
            } else {
                ++serverStoppingLogsHidden;
            }
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge - Server Stopping: Exception during server stop cleanup", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        try {
            RepAE2BridgeBlockEntity.setWorldUnloading(false);
            if ((long)serverStartingLogsHidden == 300L) {
                LOGGER.info("RepAE2Bridge - Server Starting: Server starting detected - resetting unload flag (+ {} similar events hidden in last 15s)", (Object)serverStartingLogsHidden);
                serverStartingLogsHidden = 0;
            } else {
                ++serverStartingLogsHidden;
            }
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge - Server Starting: Exception during server starting handling", (Throwable)e);
        }
    }
}

