/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.block;

import com.buuz135.replication.block.MatterPipeBlock;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.unfamily.repae2bridge.block.custom.RepAE2BridgeBl;
import net.unfamily.repae2bridge.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"rep_ae2_bridge");
    public static final DeferredBlock<Block> REPAE2BRIDGE = ModBlocks.registerBlock("rep_ae2_bridge", () -> new RepAE2BridgeBl(BlockBehaviour.Properties.of().strength(0.3f, 0.3f).sound(SoundType.COPPER).noOcclusion()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ModBlocks.registerConnectableBlocks();
    }

    private static void registerConnectableBlocks() {
        try {
            MatterPipeBlock.ALLOWED_CONNECTION_BLOCKS.add(block -> block instanceof RepAE2BridgeBl || block.getClass().getName().contains("repae2bridge"));
        }
        catch (NoClassDefFoundError | NullPointerException e) {
            LogUtils.getLogger().warn("Replication mod not fully loaded yet, connection registration will be handled later");
        }
    }
}

