/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.util;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.unfamily.repae2bridge.component.MatterComponent;
import net.unfamily.repae2bridge.util.DynamicMatterRegistry;
import net.unfamily.repae2bridge.util.MatterTypeInfo;
import org.slf4j.Logger;

public class MatterTypeUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, MatterTypeInfo> MATTER_CACHE = new HashMap<String, MatterTypeInfo>();
    private static final Map<IMatterType, MatterTypeInfo> MATTER_BY_TYPE = new HashMap<IMatterType, MatterTypeInfo>();

    public static void loadAllMatters() {
        MATTER_CACHE.clear();
        MATTER_BY_TYPE.clear();
        try {
            Registry registry = ReplicationRegistry.MATTER_TYPES_REGISTRY;
            if (registry == null) {
                LOGGER.warn("RepAE2Bridge: Matter type registry not ready, skipping matter info loading for now.");
                return;
            }
            for (Map.Entry entry : registry.entrySet()) {
                ResourceLocation id = ((ResourceKey)entry.getKey()).location();
                IMatterType matterType = (IMatterType)entry.getValue();
                String name = matterType.getName();
                float[] color = (float[])matterType.getColor().get();
                ResourceLocation texture = MatterTypeUtil.resolveTexture(id, name);
                MatterTypeInfo info = new MatterTypeInfo(name, texture, color, id, matterType);
                MATTER_CACHE.put(name, info);
                MATTER_BY_TYPE.put(matterType, info);
                if (id.getNamespace().equals("replication")) continue;
                LOGGER.info("RepAE2Bridge: Loaded custom matter '{}' from mod '{}' with texture '{}' and item '{}'", new Object[]{name, id.getNamespace(), texture, DynamicMatterRegistry.getMatterItem(matterType)});
            }
            LOGGER.info("RepAE2Bridge: Loaded {} matter types with dynamic items.", (Object)MATTER_CACHE.size());
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge: Failed to load matter types", (Throwable)e);
        }
    }

    private static ResourceLocation resolveTexture(ResourceLocation id, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("gui/mattertypes/" + name.toLowerCase()));
    }

    public static Map<String, MatterTypeInfo> getAllMatters() {
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return new HashMap<String, MatterTypeInfo>(MATTER_CACHE);
    }

    public static MatterTypeInfo getMatterInfo(String matterTypeName) {
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return MATTER_CACHE.get(matterTypeName);
    }

    public static MatterTypeInfo getMatterInfo(IMatterType matterType) {
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return MATTER_BY_TYPE.get(matterType);
    }

    public static IMatterType getMatterTypeFromItemStack(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return DynamicMatterRegistry.getMatterType(stack);
    }

    public static IMatterType getMatterTypeFromComponent(MatterComponent component) {
        MatterTypeInfo info;
        if (component == null) {
            return null;
        }
        if (MATTER_CACHE.isEmpty()) {
            MatterTypeUtil.loadAllMatters();
        }
        return (info = MATTER_CACHE.get(component.matterTypeName())) != null ? info.matterType() : null;
    }
}

