/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge;

import appeng.api.ids.AECreativeTabIds;
import appeng.api.networking.IInWorldGridNodeHost;
import com.buuz135.replication.block.MatterPipeBlock;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.block_network.element.NetworkElementFactory;
import com.hrznstudio.titanium.block_network.element.NetworkElementRegistry;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.unfamily.repae2bridge.Config;
import net.unfamily.repae2bridge.RepAE2BridgeCapabilities;
import net.unfamily.repae2bridge.block.ModBlocks;
import net.unfamily.repae2bridge.block.entity.ModBlockEntities;
import net.unfamily.repae2bridge.block.entity.RepAE2BridgeBlockEntity;
import net.unfamily.repae2bridge.item.ModItems;
import org.slf4j.Logger;

@Mod(value="rep_ae2_bridge")
public class RepAE2Bridge {
    public static final String MOD_ID = "rep_ae2_bridge";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Capability<IInWorldGridNodeHost> IN_WORLD_GRID_NODE_HOST = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInWorldGridNodeHost>(){});
    private static boolean networksFixed = false;

    public RepAE2Bridge() {
        LOGGER.info("RepAE2Bridge: Main constructor called");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        modEventBus.register(Config.class);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        LOGGER.info("RepAE2Bridge: Bridge energy consumption set to {} AE/t", (Object)Config.bridgeEnergyConsumption);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void patchNetworkBlockEntityClass() {
        try {
            if (networksFixed) {
                return;
            }
            LOGGER.info("RepAE2Bridge: Applying patch to fix NetworkBlockEntity.getNetwork");
            NetworkPatcher.initialize();
            networksFixed = true;
            LOGGER.info("RepAE2Bridge: NetworkBlockEntity patch applied successfully");
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge: Failed to patch NetworkBlockEntity: {}", (Object)e.getMessage());
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            boolean ae2Loaded;
            boolean replicationLoaded = ModList.get().isLoaded("replication");
            boolean bl = ae2Loaded = ModList.get().isLoaded("appliedenergistics2") || ModList.get().isLoaded("ae2");
            if (replicationLoaded && ae2Loaded) {
                LOGGER.info("Replication and AE2 mods are loaded, skipping DefaultMatterNetworkElement registration to avoid conflicts");
            } else {
                try {
                    LOGGER.info("Replication and AE2 mods are not loaded, registering DefaultMatterNetworkElement factory");
                    NetworkElementRegistry.INSTANCE.addFactory(DefaultMatterNetworkElement.ID, (NetworkElementFactory)new DefaultMatterNetworkElement.Factory());
                    LOGGER.info("Replication network integration complete");
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("duplicate")) {
                        LOGGER.info("DefaultMatterNetworkElement factory already registered, using existing registration");
                    }
                    LOGGER.error("Failed to register with Replication network system", (Throwable)e);
                }
            }
        });
        event.enqueueWork(() -> this.registerWithReplicationMod());
        event.enqueueWork(this::patchNetworkBlockEntityClass);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        RepAE2BridgeCapabilities.register(event);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == AECreativeTabIds.MAIN) {
            event.m_246326_((ItemLike)ModBlocks.REPAE2BRIDGE.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        RepAE2BridgeBlockEntity.setWorldUnloading(false);
        if (!networksFixed) {
            this.patchNetworkBlockEntityClass();
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("RepAE2Bridge: Server stopping, notifying bridges to prepare for unload");
        RepAE2BridgeBlockEntity.setWorldUnloading(true);
        try {
            LOGGER.info("RepAE2Bridge: Cancelling all pending operations for rapid shutdown");
            RepAE2BridgeBlockEntity.cancelAllPendingOperations();
            NetworkPatcher.clearAllRetryCounters();
        }
        catch (Exception e) {
            LOGGER.warn("RepAE2Bridge: Exception during shutdown cleanup, continuing anyway", (Throwable)e);
        }
        LOGGER.info("RepAE2Bridge: All bridges notified of world unload");
    }

    private void registerWithReplicationMod() {
        try {
            try {
                Field field = MatterPipeBlock.class.getDeclaredField("ALLOWED_CONNECTION_BLOCKS");
                if (field != null) {
                    field.setAccessible(true);
                    Object list = field.get(null);
                    if (list != null) {
                        Method addMethod = list.getClass().getMethod("add", Object.class);
                        addMethod.invoke(list, block -> block.getClass().getName().contains(MOD_ID));
                    }
                }
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = MatterPipeBlock.class.getMethod("registerExternalConnectableBlock", Predicate.class);
                    method.invoke(null, block -> block.getClass().getName().contains(MOD_ID));
                    LOGGER.info("Registered with Replication mod using alternative API");
                }
                catch (Exception ex) {
                    LOGGER.error("No compatible registration method found in Replication mod: " + ex.getMessage());
                }
            }
            catch (Exception e) {
                LOGGER.error("Error accessing ALLOWED_CONNECTION_BLOCKS: " + e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register with Replication mod: " + e.getMessage());
        }
    }

    public static class NetworkPatcher {
        private static boolean initialized = false;
        private static final Map<BlockPos, Integer> pipeRetryCounters = new HashMap<BlockPos, Integer>();
        private static final int MAX_RETRY_ATTEMPTS = 10;

        public static void initialize() {
            if (initialized) {
                return;
            }
            LOGGER.info("NetworkPatcher: Initializing safety hooks for NetworkBlockEntity");
            initialized = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static MatterNetwork safeGetNetwork(BlockEntity entity, Level level, BlockPos pos) {
            if (level == null || level.m_5776_()) {
                return null;
            }
            try {
                NetworkManager networkManager = NetworkManager.get((Level)level);
                if (networkManager == null) {
                    return null;
                }
                NetworkElement element = networkManager.getElement(pos);
                if (element == null) {
                    int retryCount = pipeRetryCounters.getOrDefault(pos, 0);
                    if (retryCount >= 10) {
                        LOGGER.warn("NetworkPatcher: Max retry attempts reached for position {}. Returning null to prevent infinite loop.", (Object)pos);
                        return null;
                    }
                    LOGGER.warn("NetworkPatcher: Null network element detected at {}. Creating temporary element to prevent crash. Attempt {}/{}", new Object[]{pos, retryCount + 1, 10});
                    pipeRetryCounters.put(pos, retryCount + 1);
                    try {
                        element = new DefaultMatterNetworkElement(level, pos);
                        networkManager.addElement(element);
                        Network network = element.getNetwork();
                        if (!(network instanceof MatterNetwork)) return null;
                        LOGGER.info("NetworkPatcher: Successfully created network element for position {}", (Object)pos);
                        pipeRetryCounters.remove(pos);
                        return (MatterNetwork)network;
                    }
                    catch (Exception e) {
                        LOGGER.error("NetworkPatcher: Failed to create network element for position {}: {}", (Object)pos, (Object)e.getMessage());
                        return null;
                    }
                }
                Network network = element.getNetwork();
                if (network instanceof MatterNetwork) {
                    pipeRetryCounters.remove(pos);
                    return (MatterNetwork)network;
                }
                if (network != null) return null;
                LOGGER.debug("NetworkPatcher: Element exists but has no network at {}. Searching for nearby networks.", (Object)pos);
                for (Direction direction : Direction.values()) {
                    Network neighborNetwork;
                    BlockPos neighborPos = pos.m_121945_(direction);
                    NetworkElement neighborElement = networkManager.getElement(neighborPos);
                    if (neighborElement == null || !((neighborNetwork = neighborElement.getNetwork()) instanceof MatterNetwork)) continue;
                    LOGGER.info("NetworkPatcher: Found existing network from neighbor at {}", (Object)neighborPos);
                    return (MatterNetwork)neighborNetwork;
                }
                return null;
            }
            catch (Exception e) {
                LOGGER.error("NetworkPatcher: Error in safeGetNetwork: {}", (Object)e.getMessage());
            }
            return null;
        }

        public static void clearRetryCounter(BlockPos pos) {
            pipeRetryCounters.remove(pos);
        }

        public static void clearAllRetryCounters() {
            pipeRetryCounters.clear();
        }
    }

    @Mod.EventBusSubscriber(modid="rep_ae2_bridge", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

