/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.block.custom;

import com.buuz135.replication.block.MatterPipeBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.unfamily.repae2bridge.block.entity.RepAE2BridgeBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RepAE2BridgeBl
extends BasicTileBlock<RepAE2BridgeBlockEntity>
implements INetworkDirectionalConnection {
    public static final VoxelShape SHAPE = RepAE2BridgeBl.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");

    public RepAE2BridgeBl(BlockBehaviour.Properties properties) {
        super("rep_ae2_bridge", properties, RepAE2BridgeBlockEntity.class);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        this.registerWithReplicationMod();
    }

    private void registerWithReplicationMod() {
        try {
            try {
                Field field = MatterPipeBlock.class.getDeclaredField("ALLOWED_CONNECTION_BLOCKS");
                if (field != null) {
                    field.setAccessible(true);
                    Object list = field.get(null);
                    if (list != null) {
                        Method addMethod = list.getClass().getMethod("add", Object.class);
                        addMethod.invoke(list, block -> block instanceof RepAE2BridgeBl);
                    }
                }
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = MatterPipeBlock.class.getMethod("registerExternalConnectableBlock", Predicate.class);
                    method.invoke(null, block -> block instanceof RepAE2BridgeBl);
                }
                catch (Exception ex) {
                    LOGGER.error("No compatible registration method found in Replication mod: " + ex.getMessage());
                }
            }
            catch (Exception e) {
                LOGGER.error("Error accessing ALLOWED_CONNECTION_BLOCKS: " + e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register block with Replication: " + e.getMessage());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONNECTED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, state) -> new RepAE2BridgeBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.m_5776_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RepAE2BridgeBlockEntity) {
                RepAE2BridgeBlockEntity blockEntity2 = (RepAE2BridgeBlockEntity)blockEntity;
                blockEntity2.handleNeighborChanged(pos);
            }
            this.updateNeighbors(level, pos, state);
        }
    }

    private void updateNeighbors(Level level, BlockPos pos, BlockState state) {
        level.m_7260_(pos, state, state, 3);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            level.m_46586_(neighborPos, state.m_60734_(), pos);
            if (!(neighborState.m_60734_() instanceof MatterPipeBlock)) continue;
            level.m_7260_(neighborPos, neighborState, neighborState, 3);
            if (!neighborState.m_61138_((Property)MatterPipeBlock.DIRECTIONS.get(direction.m_122424_()))) continue;
            level.m_7731_(neighborPos, (BlockState)neighborState.m_61124_((Property)MatterPipeBlock.DIRECTIONS.get(direction.m_122424_()), (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.m_5776_()) {
            BlockEntity blockEntity;
            Direction directionToPipe = null;
            for (Direction direction : Direction.values()) {
                if (!pos.m_121945_(direction).equals((Object)fromPos) || !(level.m_8055_(fromPos).m_60734_() instanceof MatterPipeBlock)) continue;
                directionToPipe = direction;
                break;
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof RepAE2BridgeBlockEntity) {
                BlockState pipeState;
                boolean isConnected;
                RepAE2BridgeBlockEntity blockEntity2 = (RepAE2BridgeBlockEntity)blockEntity;
                blockEntity2.handleNeighborChanged(fromPos);
                boolean bl = isConnected = blockEntity2.isActive() && blockEntity2.getNetwork() != null;
                if ((Boolean)state.m_61143_((Property)CONNECTED) != isConnected) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
                }
                if (directionToPipe != null && (pipeState = level.m_8055_(fromPos)).m_60734_() instanceof MatterPipeBlock) {
                    level.m_7260_(fromPos, pipeState, pipeState, 3);
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (!level.f_46443_) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof RepAE2BridgeBlockEntity) {
                RepAE2BridgeBlockEntity blockEntity2 = (RepAE2BridgeBlockEntity)blockEntity;
                InventoryComponent<RepAE2BridgeBlockEntity> inventory = blockEntity2.getOutput();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                }
                blockEntity2.disconnectFromNetworks();
            }
            level.m_46747_(pos);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public boolean canConnect(BlockState state, Direction direction) {
        return true;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return true;
    }
}

