/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.block.entity;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingSimulationRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.core.definitions.AEItems;
import appeng.crafting.inv.ICraftingInventory;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.MachineSource;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.PriorityMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;
import net.unfamily.repae2bridge.Config;
import net.unfamily.repae2bridge.RepAE2Bridge;
import net.unfamily.repae2bridge.block.ModBlocks;
import net.unfamily.repae2bridge.block.custom.RepAE2BridgeBl;
import net.unfamily.repae2bridge.block.entity.ModBlockEntities;
import net.unfamily.repae2bridge.item.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RepAE2BridgeBlockEntity
extends ReplicationMachine<RepAE2BridgeBlockEntity>
implements IInWorldGridNodeHost,
ICraftingInventory,
ICraftingProvider,
IStorageProvider,
IActionHost,
IPriorityHost {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int debugTickCounter = 0;
    private static final int DEBUG_SUMMARY_INTERVAL = 300;
    private static int hiddenDebugMessages = 0;
    private static int hiddenServerTickMessages = 0;
    private static int hiddenPatternUpdateMessages = 0;
    private static int hiddenIsActiveMessages = 0;
    private static final int REQUEST_ACCUMULATION_TICKS = 100;
    private static final int INITIALIZATION_DELAY = 60;
    private byte initialized = 0;
    private int initializationTicks = 0;
    private final Queue<IPatternDetails> pendingPatterns = new LinkedList<IPatternDetails>();
    private final Map<IPatternDetails, KeyCounter[]> pendingInputs = new HashMap<IPatternDetails, KeyCounter[]>();
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)new IGridNodeListener<RepAE2BridgeBlockEntity>(){

        public void onSaveChanges(RepAE2BridgeBlockEntity nodeOwner, IGridNode node) {
            nodeOwner.m_6596_();
        }

        public void onStateChanged(RepAE2BridgeBlockEntity nodeOwner, IGridNode node, IGridNodeListener.State state) {
            if (nodeOwner.f_58857_ != null) {
                nodeOwner.f_58857_.m_7260_(nodeOwner.f_58858_, nodeOwner.m_58900_(), nodeOwner.m_58900_(), 3);
                RepAE2BridgeBlockEntity.this.updateConnectedState();
                if (state == IGridNodeListener.State.POWER && node.isActive()) {
                    ICraftingProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
                }
            }
        }

        public void onGridChanged(RepAE2BridgeBlockEntity nodeOwner, IGridNode node) {
            if (nodeOwner.f_58857_ != null) {
                nodeOwner.f_58857_.m_7260_(nodeOwner.f_58858_, nodeOwner.m_58900_(), nodeOwner.m_58900_(), 3);
                RepAE2BridgeBlockEntity.this.updateConnectedState();
                ICraftingProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
                IStorageProvider.requestUpdate((IManagedGridNode)RepAE2BridgeBlockEntity.this.mainNode);
            }
        }
    }).setVisualRepresentation((ItemLike)ModBlocks.REPAE2BRIDGE.get()).setInWorldNode(true).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage((double)Config.bridgeEnergyConsumption).setExposedOnSides(EnumSet.allOf(Direction.class)).addService(ICraftingProvider.class, (IGridNodeService)this).addService(IStorageProvider.class, (IGridNodeService)this).setTagName("main");
    private boolean nodeCreated = false;
    private boolean shouldReconnect = false;
    @Save
    private InventoryComponent<RepAE2BridgeBlockEntity> output;
    @Save
    private int sortingTypeValue = 0;
    @Save
    private int sortingDirection = 1;
    @Save
    private int matterOpediaSortingTypeValue = 0;
    @Save
    private int matterOpediaSortingDirection = 1;
    private TerminalPlayerTracker terminalPlayerTracker;
    @Save
    private UUID blockId;
    private final Map<UUID, Map<ItemStack, Integer>> patternRequests = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<String, TaskSourceInfo>> activeTasks = new HashMap<UUID, Map<String, TaskSourceInfo>>();
    private final Map<UUID, Map<ItemStack, Integer>> patternRequestsBySource = new HashMap<UUID, Map<ItemStack, Integer>>();
    private final Map<UUID, Map<ItemWithSourceId, Integer>> requestCounters = new HashMap<UUID, Map<ItemWithSourceId, Integer>>();
    private int requestCounterTicks = 0;
    private int patternUpdateTicks = 0;
    private static final int PATTERN_UPDATE_INTERVAL = 100;
    private Map<String, Long> lastMatterWarnings = new HashMap<String, Long>();
    private static final int WARNING_COOLDOWN = 600;
    private static boolean worldUnloading = false;
    private volatile boolean unloadInProgress = false;
    private static final Map<BlockPos, Integer> pipeInitializationDelays = new HashMap<BlockPos, Integer>();
    private static final int PIPE_INITIALIZATION_DELAY = 60;
    @Save
    private int priority = 0;
    private final MatterItemsStorage matterItemsStorage = new MatterItemsStorage();

    public static void setWorldUnloading(boolean unloading) {
        worldUnloading = unloading;
        LOGGER.error("RepAE2Bridge: GLOBAL OPERATION CANCELLATION - World unloading flag set to {}", (Object)unloading);
    }

    private static void logDebugWithSpamReduction(String message, String category) {
        ++debugTickCounter;
        switch (category) {
            case "serverTick": {
                ++hiddenServerTickMessages;
                break;
            }
            case "patternUpdate": {
                ++hiddenPatternUpdateMessages;
                break;
            }
            case "isActive": {
                ++hiddenIsActiveMessages;
                break;
            }
            default: {
                ++hiddenDebugMessages;
            }
        }
        if (debugTickCounter >= 300) {
            int totalHidden = hiddenServerTickMessages + hiddenPatternUpdateMessages + hiddenIsActiveMessages + hiddenDebugMessages;
            LOGGER.info("serverTick summary - {} ticks completed, {} local + {} global debug messages hidden", new Object[]{300, totalHidden, hiddenDebugMessages});
            debugTickCounter = 0;
            hiddenDebugMessages = 0;
            hiddenServerTickMessages = 0;
            hiddenPatternUpdateMessages = 0;
            hiddenIsActiveMessages = 0;
        }
    }

    public static void cancelAllPendingOperations() {
        LOGGER.error("RepAE2Bridge: GLOBAL OPERATION CANCELLATION - Cancelling all pending operations on all bridges");
        try {
            if (!worldUnloading) {
                worldUnloading = true;
                LOGGER.error("RepAE2Bridge: GLOBAL OPERATION CANCELLATION - Setting worldUnloading flag to true for safety");
            }
            LOGGER.error("RepAE2Bridge: GLOBAL OPERATION CANCELLATION - All pending operations have been marked for cancellation");
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge: GLOBAL OPERATION CANCELLATION - Error during cancelAllPendingOperations: {}", (Object)e.getMessage());
        }
    }

    public static boolean isWorldUnloading() {
        return worldUnloading;
    }

    public RepAE2BridgeBlockEntity(BlockPos pos, BlockState blockState) {
        super((BasicTileBlock)ModBlocks.REPAE2BRIDGE.get(), (BlockEntityType)ModBlockEntities.REPAE2BRIDGE_BE.get(), pos, blockState);
        this.blockId = UUID.randomUUID();
        this.terminalPlayerTracker = new TerminalPlayerTracker();
        this.output = new InventoryComponent("output", 11, 131, 18).setRange(9, 2).setComponentHarness((IComponentHarness)this).setInputFilter((stack, slot) -> true);
        this.addInventory(this.output);
    }

    @NotNull
    public RepAE2BridgeBlockEntity getSelf() {
        return this;
    }

    private boolean hasBridgeInDirection(Direction direction) {
        if (this.f_58857_ != null) {
            BlockPos neighborPos = this.f_58858_.m_121945_(direction);
            return this.f_58857_.m_7702_(neighborPos) instanceof RepAE2BridgeBlockEntity;
        }
        return false;
    }

    private boolean isNodeValid() {
        try {
            IGridNode node = this.mainNode.getNode();
            if (node == null) {
                return false;
            }
            return node.getLevel() != null && node.getOwner() != null;
        }
        catch (Exception e) {
            LOGGER.debug("Bridge: Node validation failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    private boolean safeInitializeNode() {
        try {
            boolean isDedicatedServer;
            if (this.mainNode.getNode() != null && !this.isNodeValid()) {
                LOGGER.debug("Bridge: Destroying invalid node before recreation");
                this.mainNode.destroy();
                this.nodeCreated = false;
                Thread.sleep(50L);
            }
            boolean bl = isDedicatedServer = this.f_58857_.m_7654_() != null && this.f_58857_.m_7654_().m_6982_();
            if (isDedicatedServer) {
                LOGGER.info("Bridge: Detected dedicated server environment, using direct node creation");
            }
            if (this.mainNode.getNode() == null) {
                LOGGER.debug("Bridge: Creating new AE2 node");
                if (isDedicatedServer) {
                    this.mainNode.create(this.f_58857_, this.f_58858_);
                    this.nodeCreated = true;
                    this.forceNeighborUpdates();
                    this.updateConnectedState();
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    LOGGER.info("Bridge: AE2 node successfully initialized using direct method on dedicated server");
                } else {
                    this.mainNode.create(this.f_58857_, this.f_58858_);
                    this.nodeCreated = true;
                    this.forceNeighborUpdates();
                    this.updateConnectedState();
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    LOGGER.info("Bridge: AE2 node successfully initialized using standard method");
                }
                return true;
            }
            if (this.isNodeValid()) {
                this.nodeCreated = true;
                LOGGER.debug("Bridge: Node already exists and is valid");
                return true;
            }
            return false;
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("already been initialized")) {
                this.nodeCreated = true;
                LOGGER.warn("Bridge: Node was already initialized: {}", (Object)e.getMessage());
                try {
                    this.forceNeighborUpdates();
                    this.updateConnectedState();
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                }
                catch (Exception updateEx) {
                    LOGGER.error("Bridge: Failed to update connections: {}", (Object)updateEx.getMessage());
                }
                return true;
            }
            LOGGER.error("Bridge: Failed to initialize node with IllegalStateException: {}", (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Bridge: Failed to initialize node: {}", (Object)e.getMessage());
            return false;
        }
    }

    protected NetworkElement createElement(Level level, BlockPos pos) {
        try {
            return new DefaultMatterNetworkElement(level, pos){

                public boolean canConnectFrom(Direction direction) {
                    BlockPos neighborPos = this.pos.m_121945_(direction);
                    if (this.level.m_7702_(neighborPos) instanceof RepAE2BridgeBlockEntity) {
                        return false;
                    }
                    return super.canConnectFrom(direction);
                }
            };
        }
        catch (Exception e) {
            LOGGER.error("Failed to create Replication network element: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void onLoad() {
        try {
            super.onLoad();
        }
        catch (Exception e) {
            LOGGER.error("Bridge: Error in super.onLoad(), will retry initialization: {}", (Object)e.getMessage());
            this.shouldReconnect = true;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            try {
                NetworkManager networkManager = NetworkManager.get((Level)this.f_58857_);
                if (networkManager != null) {
                    NetworkElement element = networkManager.getElement(this.f_58858_);
                    if (element == null) {
                        element = this.createElement(this.f_58857_, this.f_58858_);
                        if (element != null) {
                            networkManager.addElement(element);
                            LOGGER.info("Bridge: Created Replication network element at placement time for {}", (Object)this.f_58858_);
                            this.forceNeighborUpdates();
                        } else {
                            LOGGER.error("Bridge: Failed to create network element at placement time");
                            this.shouldReconnect = true;
                        }
                    } else {
                        LOGGER.info("Bridge: Network element already exists for this block");
                        if (element.getNetwork() == null) {
                            LOGGER.warn("Bridge: Element exists but network is null, will retry initialization");
                            this.shouldReconnect = true;
                        }
                    }
                } else {
                    LOGGER.error("Bridge: NetworkManager not found at block placement time, will retry");
                    this.shouldReconnect = true;
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Error creating Replication network at placement time: {}, will retry", (Object)e.getMessage());
                this.shouldReconnect = true;
            }
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            try {
                if (!this.nodeCreated || !this.isNodeValid()) {
                    LOGGER.debug("Bridge: Attempting safe node initialization in onLoad");
                    boolean success = this.safeInitializeNode();
                    if (!success) {
                        this.shouldReconnect = true;
                        LOGGER.warn("Bridge: Node initialization failed in onLoad, will retry later");
                    }
                } else {
                    LOGGER.debug("Bridge: Node already valid in onLoad");
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Error during AE2 node initialization in onLoad: {}, will retry", (Object)e.getMessage());
                this.shouldReconnect = true;
            }
        }
    }

    private void updateConnectedState() {
        BlockState currentState;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (currentState = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() == ModBlocks.REPAE2BRIDGE.get()) {
            boolean isConnected;
            boolean bl = isConnected = this.isActive() && this.getNetwork() != null;
            if ((Boolean)currentState.m_61143_((Property)RepAE2BridgeBl.CONNECTED) != isConnected) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_((Property)RepAE2BridgeBl.CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
            }
        }
    }

    private boolean hasAE2NetworkConnection() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            for (Direction direction : Direction.values()) {
                IInWorldGridNodeHost host;
                IGridNode node;
                BlockPos neighborPos = this.f_58858_.m_121945_(direction);
                BlockEntity blockEntity = this.f_58857_.m_7702_(neighborPos);
                if (!(blockEntity instanceof IInWorldGridNodeHost) || (node = (host = (IInWorldGridNodeHost)blockEntity).getGridNode(direction.m_122424_())) == null || !node.isActive()) continue;
                return true;
            }
        }
        return false;
    }

    private void forceNeighborUpdates() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = this.f_58858_.m_121945_(direction);
                BlockState neighborState = this.f_58857_.m_8055_(neighborPos);
                if (neighborState.m_60795_()) continue;
                this.f_58857_.m_46586_(neighborPos, this.m_58900_().m_60734_(), this.f_58858_);
            }
        }
    }

    public void handleNeighborChanged(BlockPos fromPos) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Direction directionToNeighbor = null;
            for (Direction dir : Direction.values()) {
                if (!this.f_58858_.m_121945_(dir).equals((Object)fromPos)) continue;
                directionToNeighbor = dir;
                break;
            }
            if (directionToNeighbor != null && this.f_58857_.m_7702_(fromPos) instanceof RepAE2BridgeBlockEntity) {
                return;
            }
            boolean hasAE2Connection = this.hasAE2NetworkConnection();
            if (!(!hasAE2Connection || this.nodeCreated && this.isNodeValid())) {
                LOGGER.debug("Bridge: Initializing AE2 node from handleNeighborChanged");
                boolean success = this.safeInitializeNode();
                if (!success) {
                    this.shouldReconnect = true;
                    LOGGER.warn("Bridge: Node initialization failed in handleNeighborChanged");
                }
            } else if (this.mainNode.getNode() != null) {
                this.forceNeighborUpdates();
            }
            this.updateConnectedState();
        }
    }

    public void disconnectFromNetworks() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.mainNode != null) {
            this.mainNode.destroy();
            this.nodeCreated = false;
        }
    }

    public void m_7651_() {
        LOGGER.error("RepAE2Bridge: setRemoved() called at {} - starting cleanup", (Object)this.f_58858_);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            try {
                this.mainNode.destroy();
                LOGGER.error("RepAE2Bridge: AE2 node destruction completed at {}", (Object)this.f_58858_);
            }
            catch (Exception e) {
                LOGGER.error("RepAE2Bridge: EXCEPTION during AE2 node destruction at {}: {}", (Object)this.f_58858_, (Object)e.getMessage());
            }
            this.nodeCreated = false;
            try {
                RepAE2Bridge.NetworkPatcher.clearRetryCounter(this.f_58858_);
                LOGGER.error("RepAE2Bridge: Retry counter cleared at {}", (Object)this.f_58858_);
            }
            catch (Exception e) {
                LOGGER.error("RepAE2Bridge: EXCEPTION clearing retry counter at {}: {}", (Object)this.f_58858_, (Object)e.getMessage());
            }
        }
        try {
            super.m_7651_();
            LOGGER.error("RepAE2Bridge: setRemoved() completed at {}", (Object)this.f_58858_);
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge: EXCEPTION in super.setRemoved() at {}: {}", (Object)this.f_58858_, (Object)e.getMessage());
        }
    }

    public void onChunkUnloaded() {
        LOGGER.error("RepAE2Bridge: onChunkUnloaded() called at {} - starting cleanup", (Object)this.f_58858_);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            try {
                this.mainNode.destroy();
                LOGGER.error("RepAE2Bridge: AE2 node destruction completed during chunk unload at {}", (Object)this.f_58858_);
            }
            catch (Exception e) {
                LOGGER.error("RepAE2Bridge: EXCEPTION during AE2 node destruction during chunk unload at {}: {}", (Object)this.f_58858_, (Object)e.getMessage());
            }
            this.nodeCreated = false;
            this.shouldReconnect = true;
            try {
                RepAE2Bridge.NetworkPatcher.clearRetryCounter(this.f_58858_);
                LOGGER.error("RepAE2Bridge: Retry counter cleared during chunk unload at {}", (Object)this.f_58858_);
            }
            catch (Exception e) {
                LOGGER.error("RepAE2Bridge: EXCEPTION clearing retry counter during chunk unload at {}: {}", (Object)this.f_58858_, (Object)e.getMessage());
            }
        }
        try {
            super.onChunkUnloaded();
            LOGGER.error("RepAE2Bridge: onChunkUnloaded() completed at {}", (Object)this.f_58858_);
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge: EXCEPTION in super.onChunkUnloaded() at {}: {}", (Object)this.f_58858_, (Object)e.getMessage());
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.mainNode.saveToNBT(tag);
        tag.m_128379_("nodeCreated", this.nodeCreated);
        tag.m_128379_("shouldReconnect", this.shouldReconnect);
        if (this.blockId != null) {
            tag.m_128362_("blockId", this.blockId);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mainNode.loadFromNBT(tag);
        if (tag.m_128441_("nodeCreated")) {
            this.nodeCreated = tag.m_128471_("nodeCreated");
        }
        if (tag.m_128441_("shouldReconnect")) {
            this.shouldReconnect = tag.m_128471_("shouldReconnect");
        }
        this.blockId = tag.m_128441_("blockId") ? tag.m_128342_("blockId") : UUID.randomUUID();
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        return this.mainNode.getNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Nullable
    public IGridNode getActionableNode() {
        return this.mainNode.getNode();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, RepAE2BridgeBlockEntity blockEntity) {
        NetworkManager networkManager;
        if (worldUnloading) {
            LOGGER.warn("Bridge at {}: EXITING serverTick early - world is unloading", (Object)this.f_58858_);
            return;
        }
        RepAE2BridgeBlockEntity.logDebugWithSpamReduction("serverTick starting", "serverTick");
        try {
            RepAE2BridgeBlockEntity.logDebugWithSpamReduction("Calling super.serverTick()", "serverTick");
            super.serverTick(level, pos, state, (NetworkBlockEntity)blockEntity);
            RepAE2BridgeBlockEntity.logDebugWithSpamReduction("super.serverTick() completed successfully", "serverTick");
        }
        catch (Exception e) {
            LOGGER.error("Bridge at {}: EXCEPTION in super.serverTick(): {}", new Object[]{this.f_58858_, e.getMessage(), e});
            return;
        }
        if (worldUnloading) {
            LOGGER.warn("Bridge at {}: World unloading detected during serverTick - aborting", (Object)this.f_58858_);
            return;
        }
        if (worldUnloading) {
            LOGGER.warn("RepAE2Bridge: EXITING serverTick early due to world unloading at {}", (Object)this.f_58858_);
            return;
        }
        if (this.shouldReconnect && this.initialized == 1) {
            LOGGER.debug("Bridge: Attempting reconnection after world reload");
            try {
                boolean success;
                NetworkElement element;
                networkManager = NetworkManager.get((Level)level);
                if (networkManager != null && ((element = networkManager.getElement(this.f_58858_)) == null || element.getNetwork() == null)) {
                    LOGGER.debug("Bridge: Replication network element missing or invalid, recreating");
                    if (element == null && (element = this.createElement(level, this.f_58858_)) != null) {
                        networkManager.addElement(element);
                        LOGGER.info("Bridge: Recreated Replication network element");
                    }
                }
                if (success = this.safeInitializeNode()) {
                    this.shouldReconnect = false;
                    LOGGER.info("Bridge: Successfully reconnected both networks after world reload");
                } else {
                    LOGGER.warn("Bridge: Failed to reconnect AE2 node, will retry next tick");
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Error during reconnection attempt: {}, will retry", (Object)e.getMessage());
            }
        }
        if (worldUnloading) {
            return;
        }
        if (this.initialized == 0) {
            ++this.initializationTicks;
            if (this.initializationTicks >= 60) {
                this.initialized = 1;
                if (!level.m_5776_()) {
                    this.forceNeighborUpdates();
                    this.updateConnectedState();
                    ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                    IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                }
            }
        }
        if (worldUnloading) {
            return;
        }
        if (level.m_46467_() % 20L == 0L && this.initialized == 1) {
            this.transferItemsToAE2();
        }
        if (worldUnloading) {
            return;
        }
        if (this.patternUpdateTicks >= 100) {
            if (this.isActive() && this.getNetwork() != null) {
                RepAE2BridgeBlockEntity.logDebugWithSpamReduction("Periodic pattern update completed", "patternUpdate");
                ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
            }
            this.patternUpdateTicks = 0;
        } else {
            ++this.patternUpdateTicks;
        }
        if (worldUnloading) {
            return;
        }
        if (level.m_46467_() % 40L == 0L && this.isActive() && this.mainNode.getNode() != null) {
            try {
                IStorageService storageService;
                IGrid grid = this.mainNode.getNode().getGrid();
                if (grid != null && (storageService = grid.getStorageService()) != null) {
                    KeyCounter items = storageService.getInventory().getAvailableStacks();
                    items.forEach(entry -> {
                        long amount;
                        AEItemKey itemKey;
                        AEKey key = (AEKey)entry.getKey();
                        if (key instanceof AEItemKey && this.isVirtualMatterItem((itemKey = (AEItemKey)key).getItem()) && (amount = entry.getLongValue()) > 0L) {
                            storageService.getInventory().extract((AEKey)itemKey, amount, Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Error during virtual matter cleanup: {}", (Object)e.getMessage());
            }
        }
        if (worldUnloading) {
            return;
        }
        if (this.requestCounterTicks >= 100) {
            MatterNetwork network = this.getNetwork();
            if (network != null && !this.requestCounters.isEmpty()) {
                Map<ItemWithSourceId, Integer> sourceCounters;
                int totalItems = 0;
                for (UUID sourceId : this.requestCounters.keySet()) {
                    sourceCounters = this.requestCounters.get(sourceId);
                    Iterator<Object> iterator = sourceCounters.values().iterator();
                    while (iterator.hasNext()) {
                        int n = iterator.next();
                        totalItems += n;
                    }
                }
                for (UUID sourceId : this.requestCounters.keySet()) {
                    if (worldUnloading) {
                        LOGGER.warn("RepAE2Bridge: EXITING request processing due to world unloading at {}", (Object)this.f_58858_);
                        return;
                    }
                    sourceCounters = this.requestCounters.get(sourceId);
                    for (Map.Entry entry2 : sourceCounters.entrySet()) {
                        if (worldUnloading) {
                            LOGGER.warn("RepAE2Bridge: EXITING item processing due to world unloading at {}", (Object)this.f_58858_);
                            return;
                        }
                        ItemWithSourceId key = (ItemWithSourceId)entry2.getKey();
                        ItemStack itemStack = key.getItemStack();
                        int count = (Integer)entry2.getValue();
                        if (count <= 0) continue;
                        block12: for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                            if (worldUnloading) {
                                LOGGER.warn("RepAE2Bridge: EXITING chip supplier processing due to world unloading at {}", (Object)this.f_58858_);
                                return;
                            }
                            BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
                            if (!(tile instanceof ChipStorageBlockEntity)) continue;
                            ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                            for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                                if (worldUnloading) {
                                    LOGGER.warn("RepAE2Bridge: EXITING pattern processing due to world unloading at {}", (Object)this.f_58858_);
                                    return;
                                }
                                if (!pattern.getStack().m_41720_().equals(itemStack.m_41720_())) continue;
                                ReplicationTask task = new ReplicationTask(pattern.getStack(), count, IReplicationTask.Mode.MULTIPLE, this.f_58858_);
                                String taskId = task.getUuid().toString();
                                network.getTaskManager().getPendingTasks().put(taskId, task);
                                TaskSourceInfo info = new TaskSourceInfo(itemStack, sourceId);
                                Map sourceTasks = this.activeTasks.getOrDefault(sourceId, new HashMap());
                                sourceTasks.put(taskId, info);
                                this.activeTasks.put(sourceId, sourceTasks);
                                Map sourceRequests = this.patternRequestsBySource.getOrDefault(sourceId, new HashMap());
                                int currentPatternRequests = sourceRequests.getOrDefault(itemStack, 0);
                                sourceRequests.put(itemStack, currentPatternRequests + count);
                                this.patternRequestsBySource.put(sourceId, sourceRequests);
                                Map globalRequests = this.patternRequests.getOrDefault(sourceId, new HashMap());
                                int currentGlobalRequests = globalRequests.getOrDefault(itemStack, 0);
                                globalRequests.put(itemStack, currentGlobalRequests + count);
                                this.patternRequests.put(sourceId, globalRequests);
                                MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                                if (matterCompound == null) continue block12;
                                for (MatterValue matterValue : matterCompound.getValues().values()) {
                                    if (worldUnloading) {
                                        LOGGER.warn("RepAE2Bridge: EXITING matter processing due to world unloading at {}", (Object)this.f_58858_);
                                        return;
                                    }
                                    IMatterType matterType = matterValue.getMatter();
                                    long matterAmount = (long)Math.ceil(matterValue.getAmount()) * (long)count;
                                    Item matterItem = this.getItemForMatterType(matterType);
                                    if (matterItem == null) continue;
                                    AEItemKey matterKey = AEItemKey.of((ItemLike)matterItem);
                                    long l = this.extract((AEKey)matterKey, matterAmount, Actionable.MODULATE);
                                }
                                continue block12;
                            }
                        }
                    }
                }
            }
            this.requestCounters.clear();
            this.requestCounterTicks = 0;
        } else {
            ++this.requestCounterTicks;
        }
        if (worldUnloading) {
            LOGGER.warn("RepAE2Bridge: EXITING after request processing due to world unloading at {}", (Object)this.f_58858_);
            return;
        }
        if (this.getNetwork() == null && (networkManager = NetworkManager.get((Level)level)) != null && networkManager.getElement(pos) == null) {
            networkManager.addElement(this.createElement(level, pos));
        }
        if (worldUnloading) {
            LOGGER.warn("RepAE2Bridge: EXITING after network connection due to world unloading at {}", (Object)this.f_58858_);
            return;
        }
        if (!this.pendingPatterns.isEmpty() && !this.isBusy()) {
            IPatternDetails pattern = this.pendingPatterns.poll();
            KeyCounter[] inputs = this.pendingInputs.remove(pattern);
            if (pattern != null && inputs != null) {
                this.pushPattern(pattern, inputs);
            }
        }
        if (worldUnloading) {
            LOGGER.warn("RepAE2Bridge: EXITING after pattern queue processing due to world unloading at {}", (Object)this.f_58858_);
            return;
        }
        if (level.m_46467_() % 40L == 0L) {
            if (!this.isActive() && this.shouldReconnect) {
                try {
                    if (this.mainNode.getNode() == null && !this.nodeCreated) {
                        this.mainNode.create(level, this.f_58858_);
                        this.forceNeighborUpdates();
                        this.updateConnectedState();
                        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                        this.nodeCreated = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to reconnect AE2 node: {}", (Object)e.getMessage());
                }
            }
            this.updateConnectedState();
        }
        if (worldUnloading) {
            LOGGER.warn("RepAE2Bridge: EXITING after AE2 node operations due to world unloading at {}", (Object)this.f_58858_);
            return;
        }
        this.terminalPlayerTracker.checkIfValid();
        if (worldUnloading) {
            LOGGER.warn("RepAE2Bridge: EXITING serverTick at end due to world unloading at {}", (Object)this.f_58858_);
        }
    }

    public boolean isPowered() {
        return true;
    }

    public MatterNetwork getNetwork() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return null;
        }
        if (worldUnloading) {
            LOGGER.warn("RepAE2Bridge: getNetwork() returning null due to world unloading at {}", (Object)this.f_58858_);
            return null;
        }
        try {
            NetworkElement element;
            NetworkManager networkManager = NetworkManager.get((Level)this.f_58857_);
            if (networkManager == null) {
                return null;
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            boolean fromMatterPipe = false;
            BlockPos pipePos = null;
            block8: for (StackTraceElement element2 : stackTrace) {
                if (!element2.getClassName().contains("MatterPipeBlockEntity") || !element2.getMethodName().equals("serverTick")) continue;
                fromMatterPipe = true;
                for (Direction direction : Direction.values()) {
                    BlockPos neighborPos = this.f_58858_.m_121945_(direction);
                    if (this.f_58857_.m_7702_(neighborPos) == null || !this.f_58857_.m_7702_(neighborPos).getClass().getName().contains("MatterPipeBlockEntity")) continue;
                    pipePos = neighborPos;
                    break block8;
                }
                break;
            }
            if (fromMatterPipe && pipePos != null) {
                if (!pipeInitializationDelays.containsKey(pipePos)) {
                    pipeInitializationDelays.put(pipePos, 0);
                    LOGGER.info("Bridge: Starting initialization delay for pipe at {}", pipePos);
                    return null;
                }
                int currentDelay = pipeInitializationDelays.get(pipePos);
                if (currentDelay < 60) {
                    pipeInitializationDelays.put(pipePos, currentDelay + 1);
                    if (currentDelay % 10 == 0) {
                        LOGGER.debug("Bridge: Pipe at {} initialization delay: {}/{}", new Object[]{pipePos, currentDelay, 60});
                    }
                    return null;
                }
                LOGGER.info("Bridge: Pipe at {} completed initialization delay, proceeding with network connection", pipePos);
                return RepAE2Bridge.NetworkPatcher.safeGetNetwork((BlockEntity)this, this.f_58857_, this.f_58858_);
            }
            if (fromMatterPipe) {
                LOGGER.debug("Bridge: Reindirizzando chiamata da MatterPipeBlockEntity a NetworkPatcher");
                return RepAE2Bridge.NetworkPatcher.safeGetNetwork((BlockEntity)this, this.f_58857_, this.f_58858_);
            }
            MatterNetwork existingNetwork = null;
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = this.f_58858_.m_121945_(direction);
                NetworkElement neighborElement = networkManager.getElement(neighborPos);
                if (neighborElement == null || !(neighborElement.getNetwork() instanceof MatterNetwork)) continue;
                existingNetwork = (MatterNetwork)neighborElement.getNetwork();
                break;
            }
            if (fromMatterPipe) {
                for (Direction direction : Direction.values()) {
                    NetworkElement pipeElement;
                    BlockPos neighborPos = this.f_58858_.m_121945_(direction);
                    if (this.f_58857_.m_7702_(neighborPos) == null || !this.f_58857_.m_7702_(neighborPos).getClass().getName().contains("MatterPipeBlockEntity") || (pipeElement = networkManager.getElement(neighborPos)) != null) continue;
                    try {
                        DefaultMatterNetworkElement newElement = new DefaultMatterNetworkElement(this.f_58857_, neighborPos);
                        networkManager.addElement((NetworkElement)newElement);
                        LOGGER.info("Fixed missing network element for pipe at {}", (Object)neighborPos);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to register pipe at {}: {}", (Object)neighborPos, (Object)e.getMessage());
                    }
                }
            }
            if ((element = networkManager.getElement(this.f_58858_)) == null) {
                if (fromMatterPipe) {
                    LOGGER.warn("Bridge: Element null durante chiamata da MatterPipeBlockEntity.serverTick, creazione elemento di emergenza");
                    try {
                        element = this.createElement(this.f_58857_, this.f_58858_);
                        if (element != null) {
                            networkManager.addElement(element);
                            LOGGER.info("Bridge: Creato elemento di emergenza per evitare NullPointerException");
                            if (existingNetwork != null) {
                                this.forceNeighborUpdates();
                                return existingNetwork;
                            }
                            if (element.getNetwork() instanceof MatterNetwork) {
                                return (MatterNetwork)element.getNetwork();
                            }
                            LOGGER.warn("Bridge: Elemento creato ma senza rete, restituisco null");
                            return null;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Bridge: Error during the creation of the emergency element: {}", (Object)e.getMessage());
                        return null;
                    }
                }
                return null;
            }
            if (element != null) {
                Network network = element.getNetwork();
                if (network instanceof MatterNetwork) {
                    MatterNetwork matterNetwork = (MatterNetwork)network;
                    return matterNetwork;
                }
                if (network == null) {
                    try {
                        LOGGER.info("Bridge: Element exists but has no network, creating a new network");
                        this.forceNeighborUpdates();
                        network = element.getNetwork();
                        if (network instanceof MatterNetwork) {
                            MatterNetwork matterNetwork = (MatterNetwork)network;
                            LOGGER.info("Bridge: Successfully created a new network");
                            return matterNetwork;
                        }
                        if (fromMatterPipe && existingNetwork != null) {
                            LOGGER.info("Bridge: Returning existing network for MatterPipeBlockEntity");
                            return existingNetwork;
                        }
                        LOGGER.warn("Network creation attempt failed, element still has no network at {}", (Object)this.f_58858_);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error creating a new network: {}", (Object)e.getMessage());
                    }
                } else {
                    LOGGER.warn("Network element has wrong network type: {}", (Object)network.getClass().getName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error accessing Replication network: {}", (Object)e.getMessage());
        }
        return null;
    }

    public boolean isActive() {
        if (worldUnloading) {
            RepAE2BridgeBlockEntity.logDebugWithSpamReduction("isActive() = false (node inactive or null)", "isActive");
            return false;
        }
        return this.mainNode.isActive();
    }

    public static MatterNetwork createReplicationNetwork(Level targetLevel, BlockPos centerPos) {
        if (targetLevel == null || targetLevel.m_5776_()) {
            return null;
        }
        try {
            NetworkManager networkManager = NetworkManager.get((Level)targetLevel);
            if (networkManager == null) {
                LOGGER.error("NetworkManager not found, impossibile creare una rete Replication");
                return null;
            }
            NetworkElement existingElement = networkManager.getElement(centerPos);
            if (existingElement != null) {
                Network network = existingElement.getNetwork();
                if (network instanceof MatterNetwork) {
                    LOGGER.info("A Replication network already exists at this position");
                    return (MatterNetwork)network;
                }
                LOGGER.info("Network element found but no network, attempting creation");
            } else {
                LOGGER.info("Creation of a new network element in {}", (Object)centerPos);
                DefaultMatterNetworkElement newElement = new DefaultMatterNetworkElement(targetLevel, centerPos){

                    public boolean canConnectFrom(Direction direction) {
                        return true;
                    }
                };
                networkManager.addElement((NetworkElement)newElement);
                Network network = newElement.getNetwork();
                if (network instanceof MatterNetwork) {
                    LOGGER.info("Replication network created successfully");
                    return (MatterNetwork)network;
                }
            }
            LOGGER.warn("It was not possible to create the Replication network in {}", (Object)centerPos);
        }
        catch (Exception e) {
            LOGGER.error("Error during the creation of the Replication network: {}", (Object)e.getMessage());
        }
        return null;
    }

    public void m_6339_() {
        super.m_6339_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            try {
                GridHelper.onFirstTick((BlockEntity)this, blockEntity -> {
                    if (this.shouldReconnect || !this.nodeCreated || !this.isNodeValid()) {
                        LOGGER.debug("Bridge: Attempting safe node initialization in clearRemoved");
                        boolean success = this.safeInitializeNode();
                        if (success) {
                            this.shouldReconnect = false;
                            LOGGER.debug("Bridge: Node initialization successful in clearRemoved");
                        } else {
                            this.shouldReconnect = true;
                            LOGGER.warn("Bridge: Node initialization failed in clearRemoved, will retry");
                        }
                    } else {
                        try {
                            this.forceNeighborUpdates();
                            this.updateConnectedState();
                            ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
                            IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
                            LOGGER.debug("Bridge: Node already valid, performed updates in clearRemoved");
                        }
                        catch (Exception e) {
                            LOGGER.error("Bridge: Failed to update existing valid node in clearRemoved: {}", (Object)e.getMessage());
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Bridge: Failed to schedule AE2 node initialization in clearRemoved: {}", (Object)e.getMessage());
                this.shouldReconnect = true;
            }
        }
    }

    private MatterNetwork getReplicationNetwork() {
        return this.getNetwork();
    }

    public InteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (!this.f_58857_.m_5776_() && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            this.openGui(playerIn);
        }
        return InteractionResult.SUCCESS;
    }

    public TerminalPlayerTracker getTerminalPlayerTracker() {
        return this.terminalPlayerTracker;
    }

    public InventoryComponent<RepAE2BridgeBlockEntity> getOutput() {
        return this.output;
    }

    public boolean receiveItemFromReplicator(ItemStack stack) {
        IStorageService storageService;
        IGrid grid;
        if (stack.m_41619_()) {
            return false;
        }
        boolean insertedIntoAE2 = false;
        long remainingCount = stack.m_41613_();
        if (this.mainNode.isActive() && this.mainNode.getNode() != null && (grid = this.mainNode.getNode().getGrid()) != null && (storageService = grid.getStorageService()) != null) {
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            long inserted = storageService.getInventory().insert((AEKey)key, (long)stack.m_41613_(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
            if (inserted > 0L) {
                for (int i = 0; i < this.output.getSlots(); ++i) {
                    ItemStack slotStack = this.output.getStackInSlot(i);
                    if (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack)) continue;
                    int toRemove = (int)Math.min(inserted, (long)slotStack.m_41613_());
                    slotStack.m_41774_(toRemove);
                    if ((inserted -= (long)toRemove) <= 0L) break;
                }
                insertedIntoAE2 = true;
                if ((remainingCount -= inserted) <= 0L) {
                    return true;
                }
            }
        }
        if (remainingCount > 0L) {
            ItemStack remainingStack = stack.m_41777_();
            remainingStack.m_41764_((int)remainingCount);
            ItemStack notInserted = ItemHandlerHelper.insertItem(this.output, (ItemStack)remainingStack, (boolean)false);
            if (notInserted.m_41619_()) {
                this.m_6596_();
                return true;
            }
            if ((long)notInserted.m_41613_() < remainingCount) {
                this.m_6596_();
                return insertedIntoAE2 || notInserted.m_41613_() < stack.m_41613_();
            }
            return insertedIntoAE2;
        }
        return true;
    }

    public void handleCompletedTask(IReplicationTask task, ItemStack stack) {
        boolean inserted = this.receiveItemFromReplicator(stack);
        if (!inserted) {
            // empty if block
        }
        UUID sourceId = this.blockId;
        if (task.getSource().equals((Object)this.f_58858_)) {
            Map globalRequests;
            int currentGlobalCount;
            Map sourceRequests = this.patternRequestsBySource.getOrDefault(sourceId, new HashMap());
            int currentCount = sourceRequests.getOrDefault(stack, 0);
            if (currentCount > 0) {
                sourceRequests.put(stack, currentCount - 1);
                this.patternRequestsBySource.put(sourceId, sourceRequests);
            }
            if ((currentGlobalCount = (globalRequests = (Map)this.patternRequests.getOrDefault(sourceId, new HashMap())).getOrDefault(stack, 0).intValue()) > 0) {
                globalRequests.put(stack, currentGlobalCount - 1);
                this.patternRequests.put(sourceId, globalRequests);
            }
        }
    }

    public void insert(AEKey what, long amount, Actionable mode) {
        if (mode == Actionable.MODULATE && what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            MatterNetwork network = this.getNetwork();
            if (network != null) {
                for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                    BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
                    if (!(tile instanceof ChipStorageBlockEntity)) continue;
                    ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                    for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                        if (!pattern.getStack().m_41720_().equals(itemKey.getItem())) continue;
                        return;
                    }
                }
            }
        }
    }

    public long extract(AEKey what, long amount, Actionable mode) {
        AEItemKey itemKey;
        Item item;
        if (what instanceof AEItemKey && this.isVirtualMatterItem(item = (itemKey = (AEItemKey)what).getItem())) {
            return this.matterItemsStorage.extract(what, amount, mode, null);
        }
        MatterNetwork network = this.getNetwork();
        if (network != null && what instanceof AEItemKey) {
            AEItemKey itemKey2 = (AEItemKey)what;
            for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
                if (!(tile instanceof ChipStorageBlockEntity)) continue;
                ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                    if (!pattern.getStack().m_41720_().equals(itemKey2.getItem())) continue;
                    return amount;
                }
            }
        }
        return 0L;
    }

    public Iterable<AEKey> findFuzzyTemplates(AEKey input) {
        if (input instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)input;
            MatterNetwork network = this.getNetwork();
            if (network != null) {
                ArrayList<AEKey> templates = new ArrayList<AEKey>();
                for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                    BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
                    if (!(tile instanceof ChipStorageBlockEntity)) continue;
                    ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                    for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                        templates.add((AEKey)AEItemKey.of((ItemLike)pattern.getStack().m_41720_()));
                    }
                }
                return templates;
            }
        }
        return List.of();
    }

    public List<IPatternDetails> getAvailablePatterns() {
        if (this.initialized != 1) {
            return List.of();
        }
        ArrayList<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
        MatterNetwork network = this.getNetwork();
        if (network != null) {
            for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
                if (!(tile instanceof ChipStorageBlockEntity)) continue;
                ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                    if (pattern.getStack().m_41619_() || pattern.getCompletion() != 1.0f) continue;
                    try {
                        ItemStack patternStack = new ItemStack((ItemLike)AEItems.BLANK_PATTERN.m_5456_());
                        AEItemKey output = AEItemKey.of((ItemLike)pattern.getStack().m_41720_());
                        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                        if (matterCompound == null) continue;
                        ArrayList<GenericStack> inputs = new ArrayList<GenericStack>();
                        for (MatterValue matterValue : matterCompound.getValues().values()) {
                            IMatterType matterType = matterValue.getMatter();
                            long matterAmount = (long)Math.ceil(matterValue.getAmount());
                            Item matterItem = this.getItemForMatterType(matterType);
                            if (matterItem == null) continue;
                            inputs.add(new GenericStack((AEKey)AEItemKey.of((ItemLike)matterItem), matterAmount));
                        }
                        ArrayList<GenericStack> outputs = new ArrayList<GenericStack>();
                        outputs.add(new GenericStack((AEKey)output, 1L));
                        CompoundTag tag = patternStack.m_41784_();
                        ListTag inputsTag = new ListTag();
                        for (GenericStack genericStack : inputs) {
                            inputsTag.add((Object)GenericStack.writeTag((GenericStack)genericStack));
                        }
                        tag.m_128365_("in", (Tag)inputsTag);
                        ListTag outputsTag = new ListTag();
                        for (GenericStack stack3 : outputs) {
                            outputsTag.add((Object)GenericStack.writeTag((GenericStack)stack3));
                        }
                        tag.m_128365_("out", (Tag)outputsTag);
                        AEProcessingPattern aEProcessingPattern = new AEProcessingPattern(AEItemKey.of((ItemStack)patternStack));
                        patterns.add((IPatternDetails)aEProcessingPattern);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return patterns;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        GenericStack output;
        Object object;
        if (this.initialized != 1) {
            return false;
        }
        MatterNetwork network = this.getNetwork();
        if (network != null && this.isActive() && patternDetails != null && patternDetails.getOutputs().length == 1 && (object = (output = patternDetails.getOutputs()[0]).what()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)object;
            if (this.isBusy()) {
                this.pendingPatterns.add(patternDetails);
                this.pendingInputs.put(patternDetails, inputHolder);
                return true;
            }
            for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
                if (!(tile instanceof ChipStorageBlockEntity)) continue;
                ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                    if (!pattern.getStack().m_41720_().equals(itemKey.getItem())) continue;
                    if (inputHolder != null && inputHolder.length > 0) {
                        KeyCounter inputs = inputHolder[0];
                        boolean hasAllMatter = true;
                        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                        if (matterCompound != null) {
                            long matterAmount;
                            IMatterType matterType;
                            for (MatterValue matterValue : matterCompound.getValues().values()) {
                                matterType = matterValue.getMatter();
                                matterAmount = (long)Math.ceil(matterValue.getAmount());
                                long available = network.calculateMatterAmount(matterType);
                                if (available >= matterAmount) continue;
                                hasAllMatter = false;
                                String warningKey = itemKey.getItem().m_5524_() + ":" + matterType.getName();
                                long currentTime = this.f_58857_.m_46467_();
                                if (this.lastMatterWarnings.containsKey(warningKey) && currentTime - this.lastMatterWarnings.get(warningKey) <= 600L) break;
                                this.lastMatterWarnings.put(warningKey, currentTime);
                                break;
                            }
                            if (hasAllMatter) {
                                for (MatterValue matterValue : matterCompound.getValues().values()) {
                                    matterType = matterValue.getMatter();
                                    matterAmount = (long)Math.ceil(matterValue.getAmount());
                                    Item matterItem = this.getItemForMatterType(matterType);
                                    if (matterItem == null) continue;
                                    AEItemKey matterKey = AEItemKey.of((ItemLike)matterItem);
                                    long l = this.extract((AEKey)matterKey, matterAmount, Actionable.MODULATE);
                                }
                            } else {
                                return false;
                            }
                        }
                    }
                    ItemStack itemStack = pattern.getStack();
                    ItemWithSourceId key = new ItemWithSourceId(itemStack, this.blockId);
                    Map sourceCounters = this.requestCounters.getOrDefault(this.blockId, new HashMap());
                    int currentCount = sourceCounters.getOrDefault(key, 0);
                    sourceCounters.put(key, currentCount + 1);
                    this.requestCounters.put(this.blockId, sourceCounters);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBusy() {
        MatterNetwork network = this.getNetwork();
        if (network != null) {
            boolean busy;
            HashSet networkTaskIds = new HashSet(network.getTaskManager().getPendingTasks().keySet());
            for (UUID sourceId : this.activeTasks.keySet()) {
                Map<String, TaskSourceInfo> sourceTasks = this.activeTasks.get(sourceId);
                HashSet<String> taskIds = new HashSet<String>(sourceTasks.keySet());
                for (String taskId : taskIds) {
                    Map globalRequests;
                    int currentGlobalCount;
                    TaskSourceInfo info;
                    if (networkTaskIds.contains(taskId) || (info = sourceTasks.remove(taskId)) == null) continue;
                    ItemStack pattern = info.getItemStack();
                    Map sourceRequests = this.patternRequestsBySource.getOrDefault(sourceId, new HashMap());
                    int currentCount = sourceRequests.getOrDefault(pattern, 0);
                    if (currentCount > 0) {
                        sourceRequests.put(pattern, currentCount - 1);
                        this.patternRequestsBySource.put(sourceId, sourceRequests);
                    }
                    if ((currentGlobalCount = (globalRequests = (Map)this.patternRequests.getOrDefault(sourceId, new HashMap())).getOrDefault(pattern, 0).intValue()) <= 0) continue;
                    globalRequests.put(pattern, currentGlobalCount - 1);
                    this.patternRequests.put(sourceId, globalRequests);
                }
                if (sourceTasks.isEmpty()) {
                    this.activeTasks.remove(sourceId);
                    continue;
                }
                this.activeTasks.put(sourceId, sourceTasks);
            }
            boolean bl = busy = !network.getTaskManager().getPendingTasks().isEmpty();
            if (!busy && this.requestCounters.isEmpty()) {
                IStorageProvider.requestUpdate((IManagedGridNode)this.mainNode);
            }
            return busy;
        }
        return false;
    }

    public int getPatternPriority() {
        return this.priority;
    }

    public Future<ICraftingPlan> beginCraftingCalculation(Level level, ICraftingSimulationRequester simRequester, AEKey what, final long amount, CalculationStrategy strategy) {
        if (what instanceof AEItemKey) {
            final AEItemKey itemKey = (AEItemKey)what;
            MatterNetwork network = this.getNetwork();
            if (network != null) {
                for (NetworkElement chipSupplier : network.getChipSuppliers()) {
                    BlockEntity tile = chipSupplier.getLevel().m_7702_(chipSupplier.getPos());
                    if (!(tile instanceof ChipStorageBlockEntity)) continue;
                    ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
                    for (MatterPattern pattern : chipStorage.getPatterns(chipStorage)) {
                        if (!pattern.getStack().m_41720_().equals(itemKey.getItem())) continue;
                        MatterCompound matterCompound = ReplicationCalculation.getMatterCompound((ItemStack)pattern.getStack());
                        if (matterCompound != null) {
                            boolean hasEnoughMatter = true;
                            HashMap<IMatterType, Long> missingMatter = new HashMap<IMatterType, Long>();
                            for (MatterValue matterValue : matterCompound.getValues().values()) {
                                IMatterType matterType = matterValue.getMatter();
                                double matterPerItem = matterValue.getAmount();
                                long totalMatterNeeded = (long)(matterPerItem * (double)amount);
                                long available = network.calculateMatterAmount(matterType);
                                if (available >= totalMatterNeeded) continue;
                                hasEnoughMatter = false;
                                missingMatter.put(matterType, totalMatterNeeded - available);
                                String warningKey = itemKey.getItem().m_5524_() + ":" + matterType.getName();
                                long currentTime = level.m_46467_();
                                if (this.lastMatterWarnings.containsKey(warningKey) && currentTime - this.lastMatterWarnings.get(warningKey) <= 600L) continue;
                                this.lastMatterWarnings.put(warningKey, currentTime);
                            }
                            if (!hasEnoughMatter) {
                                StringBuilder errorMsg = new StringBuilder();
                                errorMsg.append("Not enough matter available. Missing:\n");
                                for (Map.Entry entry : missingMatter.entrySet()) {
                                    errorMsg.append("- ").append(entry.getValue()).append(" ").append(((IMatterType)entry.getKey()).toString()).append("\n");
                                }
                                return CompletableFuture.failedFuture(new IllegalStateException(errorMsg.toString()));
                            }
                            return CompletableFuture.completedFuture(new ICraftingPlan(){

                                public GenericStack finalOutput() {
                                    return new GenericStack((AEKey)AEItemKey.of((ItemLike)itemKey.getItem()), amount);
                                }

                                public long bytes() {
                                    return 0L;
                                }

                                public boolean simulation() {
                                    return false;
                                }

                                public boolean multiplePaths() {
                                    return false;
                                }

                                public KeyCounter usedItems() {
                                    return new KeyCounter();
                                }

                                public KeyCounter emittedItems() {
                                    return new KeyCounter();
                                }

                                public KeyCounter missingItems() {
                                    return new KeyCounter();
                                }

                                public Map<IPatternDetails, Long> patternTimes() {
                                    return Map.of();
                                }
                            });
                        }
                        return CompletableFuture.failedFuture(new IllegalStateException("Cannot calculate required matter"));
                    }
                }
                return CompletableFuture.failedFuture(new IllegalStateException("No pattern found for this item"));
            }
            return CompletableFuture.failedFuture(new IllegalStateException("No Replication network found"));
        }
        return CompletableFuture.failedFuture(new IllegalStateException("Cannot craft this item"));
    }

    private Item getItemForMatterType(IMatterType type) {
        String name = type.getName();
        if (name.equalsIgnoreCase("earth")) {
            return (Item)ModItems.EARTH_MATTER.get();
        }
        if (name.equalsIgnoreCase("nether")) {
            return (Item)ModItems.NETHER_MATTER.get();
        }
        if (name.equalsIgnoreCase("organic")) {
            return (Item)ModItems.ORGANIC_MATTER.get();
        }
        if (name.equalsIgnoreCase("ender")) {
            return (Item)ModItems.ENDER_MATTER.get();
        }
        if (name.equalsIgnoreCase("metallic")) {
            return (Item)ModItems.METALLIC_MATTER.get();
        }
        if (name.equalsIgnoreCase("precious")) {
            return (Item)ModItems.PRECIOUS_MATTER.get();
        }
        if (name.equalsIgnoreCase("living")) {
            return (Item)ModItems.LIVING_MATTER.get();
        }
        if (name.equalsIgnoreCase("quantum")) {
            return (Item)ModItems.QUANTUM_MATTER.get();
        }
        return null;
    }

    private boolean isVirtualMatterItem(Item item) {
        return item == ModItems.EARTH_MATTER.get() || item == ModItems.NETHER_MATTER.get() || item == ModItems.ORGANIC_MATTER.get() || item == ModItems.ENDER_MATTER.get() || item == ModItems.METALLIC_MATTER.get() || item == ModItems.PRECIOUS_MATTER.get() || item == ModItems.LIVING_MATTER.get() || item == ModItems.QUANTUM_MATTER.get();
    }

    public void getAvailableItems(KeyCounter items) {
        if (this.initialized != 1) {
            return;
        }
        MatterNetwork network = this.getNetwork();
        if (network != null) {
            List<IMatterType> matterTypes = List.of((IMatterType)ReplicationRegistry.Matter.EMPTY.get(), (IMatterType)ReplicationRegistry.Matter.METALLIC.get(), (IMatterType)ReplicationRegistry.Matter.EARTH.get(), (IMatterType)ReplicationRegistry.Matter.NETHER.get(), (IMatterType)ReplicationRegistry.Matter.ORGANIC.get(), (IMatterType)ReplicationRegistry.Matter.ENDER.get(), (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get(), (IMatterType)ReplicationRegistry.Matter.QUANTUM.get(), (IMatterType)ReplicationRegistry.Matter.LIVING.get());
            for (IMatterType matterType : matterTypes) {
                Item item;
                long amount = network.calculateMatterAmount(matterType);
                if (amount <= 0L || (item = this.getItemForMatterType(matterType)) == null) continue;
                items.add((AEKey)AEItemKey.of((ItemLike)item), amount);
            }
        }
    }

    public void mountInventories(IStorageMounts storageMounts) {
        if (this.initialized != 1) {
            return;
        }
        storageMounts.mount((MEStorage)this.matterItemsStorage, 100);
    }

    public void handleReplicationNetworkEvent() {
        if (this.isActive() && this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
        }
    }

    private IMatterType getMatterTypeForItem(Item item) {
        if (item == ModItems.EARTH_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.EARTH.get();
        }
        if (item == ModItems.NETHER_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.NETHER.get();
        }
        if (item == ModItems.ORGANIC_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.ORGANIC.get();
        }
        if (item == ModItems.ENDER_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.ENDER.get();
        }
        if (item == ModItems.METALLIC_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.METALLIC.get();
        }
        if (item == ModItems.PRECIOUS_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get();
        }
        if (item == ModItems.LIVING_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.LIVING.get();
        }
        if (item == ModItems.QUANTUM_MATTER.get()) {
            return (IMatterType)ReplicationRegistry.Matter.QUANTUM.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldUnload() {
        if (this.unloadInProgress) {
            LOGGER.warn("Bridge at {}: onWorldUnload() already in progress - skipping", (Object)this.f_58858_);
            return;
        }
        this.unloadInProgress = true;
        long startTime = System.currentTimeMillis();
        long timeoutMs = 5000L;
        LOGGER.error("Bridge at {}: onWorldUnload() called - starting aggressive cleanup", (Object)this.f_58858_);
        try {
            this.requestCounterTicks = 0;
            this.patternUpdateTicks = 0;
            this.initializationTicks = 0;
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                LOGGER.error("Bridge at {}: Cleanup timeout exceeded - forcing exit", (Object)this.f_58858_);
                return;
            }
            this.pendingPatterns.clear();
            this.pendingInputs.clear();
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                LOGGER.error("Bridge at {}: Cleanup timeout exceeded - forcing exit", (Object)this.f_58858_);
                return;
            }
            this.patternRequests.clear();
            this.patternRequestsBySource.clear();
            this.activeTasks.clear();
            this.requestCounters.clear();
            this.lastMatterWarnings.clear();
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                LOGGER.error("Bridge at {}: Cleanup timeout exceeded - forcing exit", (Object)this.f_58858_);
                return;
            }
            if (this.terminalPlayerTracker != null) {
                try {
                    this.terminalPlayerTracker.getPlayers().clear();
                    LOGGER.error("Bridge at {}: Cleaned up terminalPlayerTracker", (Object)this.f_58858_);
                }
                catch (Exception e) {
                    LOGGER.error("Bridge at {}: Error cleaning up terminalPlayerTracker: {}", (Object)this.f_58858_, (Object)e.getMessage());
                }
            }
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                LOGGER.error("Bridge at {}: Cleanup timeout exceeded - forcing exit", (Object)this.f_58858_);
                return;
            }
            try {
                if (this.getNetwork() != null && this.getNetwork().getTaskManager() != null) {
                    this.getNetwork().getTaskManager().getPendingTasks().clear();
                    LOGGER.error("Bridge at {}: Forced cancellation of all active Replication tasks", (Object)this.f_58858_);
                }
            }
            catch (Exception e) {
                LOGGER.error("Bridge at {}: Exception while force-cancelling Replication tasks: {}", (Object)this.f_58858_, (Object)e.getMessage());
            }
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                LOGGER.error("Bridge at {}: Cleanup timeout exceeded - forcing exit", (Object)this.f_58858_);
                return;
            }
            this.initialized = 0;
            if (System.currentTimeMillis() - startTime > timeoutMs) {
                LOGGER.error("Bridge at {}: Cleanup timeout exceeded - forcing exit", (Object)this.f_58858_);
                return;
            }
            if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.mainNode != null) {
                try {
                    this.mainNode.destroy();
                    LOGGER.error("Bridge at {}: AE2 node successfully destroyed during world unload", (Object)this.f_58858_);
                }
                catch (Exception e) {
                    LOGGER.error("Bridge at {}: Error destroying AE2 node during world unload: {}", (Object)this.f_58858_, (Object)e.getMessage());
                    this.nodeCreated = false;
                    this.shouldReconnect = true;
                }
                this.nodeCreated = false;
                this.shouldReconnect = true;
            }
            LOGGER.error("Bridge at {}: onWorldUnload() cleanup completed successfully", (Object)this.f_58858_);
        }
        catch (Exception e) {
            LOGGER.error("Bridge at {}: Exception during onWorldUnload cleanup: {}", new Object[]{this.f_58858_, e.getMessage(), e});
        }
        finally {
            this.unloadInProgress = false;
        }
    }

    public UUID getBlockId() {
        return this.blockId;
    }

    public int getActiveRequestsForThisBlock() {
        Map requests = this.patternRequestsBySource.getOrDefault(this.blockId, new HashMap());
        return requests.values().stream().mapToInt(Integer::intValue).sum();
    }

    public int getActiveRequestsForItem(Item item) {
        Map requests = this.patternRequestsBySource.getOrDefault(this.blockId, new HashMap());
        return requests.entrySet().stream().filter(entry -> ((ItemStack)entry.getKey()).m_41720_() == item).mapToInt(Map.Entry::getValue).sum();
    }

    public int getTotalActiveRequests() {
        int total = 0;
        for (Map<ItemStack, Integer> sourceRequests : this.patternRequestsBySource.values()) {
            total += sourceRequests.values().stream().mapToInt(Integer::intValue).sum();
        }
        return total;
    }

    private void transferItemsToAE2() {
        if (!this.mainNode.isActive() || this.mainNode.getNode() == null) {
            return;
        }
        IGrid grid = this.mainNode.getNode().getGrid();
        if (grid == null) {
            return;
        }
        IStorageService storageService = grid.getStorageService();
        if (storageService == null) {
            return;
        }
        boolean itemsMoved = false;
        for (int i = 0; i < this.output.getSlots(); ++i) {
            ItemStack stack = this.output.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            long inserted = storageService.getInventory().insert((AEKey)key, (long)stack.m_41613_(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
            if (inserted <= 0L) continue;
            stack.m_41774_((int)inserted);
            itemsMoved = true;
        }
        if (itemsMoved) {
            this.m_6596_();
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.m_6596_();
    }

    public void openGui(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuOpener.open((MenuType)PriorityMenu.TYPE, (Player)serverPlayer, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)this));
        }
    }

    public ItemStack getMainMenuIcon() {
        return ((Block)ModBlocks.REPAE2BRIDGE.get()).m_5456_().m_7968_();
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_6915_();
        }
    }

    public class MatterItemsStorage
    implements MEStorage {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return 0L;
            }
            return 0L;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            IMatterType matterType;
            MatterNetwork network;
            AEItemKey itemKey;
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return 0L;
            }
            if (what instanceof AEItemKey && RepAE2BridgeBlockEntity.this.isVirtualMatterItem((itemKey = (AEItemKey)what).getItem()) && (network = RepAE2BridgeBlockEntity.this.getNetwork()) != null && (matterType = RepAE2BridgeBlockEntity.this.getMatterTypeForItem(itemKey.getItem())) != null) {
                long available = network.calculateMatterAmount(matterType);
                if (available < amount) {
                    // empty if block
                }
                long toExtract = Math.min(amount, available);
                if (mode == Actionable.SIMULATE) {
                    return toExtract;
                }
                if (toExtract > 0L) {
                    return toExtract;
                }
            }
            return 0L;
        }

        public boolean isAutomationPart(IActionSource source) {
            if (source.machine().isPresent()) {
                IActionHost machine = (IActionHost)source.machine().get();
                String machineClass = machine.getClass().getName();
                return machineClass.contains("appeng.parts.autom");
            }
            return false;
        }

        public Component getDescription() {
            return Component.m_237113_((String)"Replication Matter Storage");
        }

        public void getAvailableStacks(KeyCounter out) {
            if (RepAE2BridgeBlockEntity.this.initialized != 1) {
                return;
            }
            MatterNetwork network = RepAE2BridgeBlockEntity.this.getNetwork();
            if (network != null) {
                List<IMatterType> matterTypes = List.of((IMatterType)ReplicationRegistry.Matter.EMPTY.get(), (IMatterType)ReplicationRegistry.Matter.METALLIC.get(), (IMatterType)ReplicationRegistry.Matter.EARTH.get(), (IMatterType)ReplicationRegistry.Matter.NETHER.get(), (IMatterType)ReplicationRegistry.Matter.ORGANIC.get(), (IMatterType)ReplicationRegistry.Matter.ENDER.get(), (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get(), (IMatterType)ReplicationRegistry.Matter.QUANTUM.get(), (IMatterType)ReplicationRegistry.Matter.LIVING.get());
                for (IMatterType matterType : matterTypes) {
                    Item item;
                    long amount = network.calculateMatterAmount(matterType);
                    if (amount <= 0L || (item = RepAE2BridgeBlockEntity.this.getItemForMatterType(matterType)) == null) continue;
                    out.add((AEKey)AEItemKey.of((ItemLike)item), amount);
                }
            }
        }
    }

    public static class TerminalPlayerTracker {
        private List<ServerPlayer> players = new ArrayList<ServerPlayer>();
        private List<UUID> uuidsToRemove = new ArrayList<UUID>();
        private List<ServerPlayer> playersToAdd = new ArrayList<ServerPlayer>();

        public void checkIfValid() {
            ArrayList<ServerPlayer> output = new ArrayList<ServerPlayer>(this.playersToAdd);
            ArrayList<ServerPlayer> input = new ArrayList<ServerPlayer>(this.players);
            for (ServerPlayer serverPlayer : input) {
                if (this.uuidsToRemove.contains(serverPlayer.m_20148_())) continue;
                output.add(serverPlayer);
            }
            this.players = output;
            this.uuidsToRemove = new ArrayList<UUID>();
            this.playersToAdd = new ArrayList<ServerPlayer>();
        }

        public void removePlayer(ServerPlayer serverPlayer) {
            this.uuidsToRemove.add(serverPlayer.m_20148_());
        }

        public void addPlayer(ServerPlayer serverPlayer) {
            this.playersToAdd.add(serverPlayer);
        }

        public List<ServerPlayer> getPlayers() {
            return this.players;
        }
    }

    public static class ItemWithSourceId {
        private final ItemStack itemStack;
        private final UUID sourceId;

        public ItemWithSourceId(ItemStack itemStack, UUID sourceId) {
            this.itemStack = itemStack.m_41777_();
            this.sourceId = sourceId;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public UUID getSourceId() {
            return this.sourceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemWithSourceId that = (ItemWithSourceId)o;
            return ItemStack.m_41728_((ItemStack)this.itemStack, (ItemStack)that.itemStack) && Objects.equals(this.sourceId, that.sourceId);
        }

        public int hashCode() {
            return Objects.hash(this.itemStack.m_41720_(), this.sourceId);
        }
    }

    public static class TaskSourceInfo {
        private final ItemStack itemStack;
        private final UUID sourceId;

        public TaskSourceInfo(ItemStack itemStack, UUID sourceId) {
            this.itemStack = itemStack.m_41777_();
            this.sourceId = sourceId;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public UUID getSourceId() {
            return this.sourceId;
        }
    }
}

