/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.block;

import com.buuz135.replication.block.MatterPipeBlock;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.unfamily.repae2bridge.block.custom.RepAE2BridgeBl;
import net.unfamily.repae2bridge.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"rep_ae2_bridge");
    public static final RegistryObject<Block> REPAE2BRIDGE = ModBlocks.registerBlock("rep_ae2_bridge", () -> new RepAE2BridgeBl(BlockBehaviour.Properties.m_284310_().m_60913_(0.3f, 0.3f).m_60918_(SoundType.f_154663_).m_60955_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ModBlocks.registerConnectableBlocks();
    }

    private static void registerConnectableBlocks() {
        try {
            try {
                Field field = MatterPipeBlock.class.getDeclaredField("ALLOWED_CONNECTION_BLOCKS");
                if (field != null) {
                    field.setAccessible(true);
                    Object list = field.get(null);
                    if (list != null) {
                        Method addMethod = list.getClass().getMethod("add", Object.class);
                        addMethod.invoke(list, block -> block instanceof RepAE2BridgeBl || block.getClass().getName().contains("repae2bridge"));
                    }
                }
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method = MatterPipeBlock.class.getMethod("registerExternalConnectableBlock", Predicate.class);
                    method.invoke(null, block -> block instanceof RepAE2BridgeBl || block.getClass().getName().contains("repae2bridge"));
                }
                catch (NoSuchMethodException | NullPointerException ex) {
                    System.out.println("RepAE2Bridge: Alternative registration method not available: " + ex.getMessage());
                }
                catch (Exception ex) {
                    System.out.println("RepAE2Bridge: Error in alternative registration: " + ex.getMessage());
                }
            }
            catch (NullPointerException e) {
                System.out.println("RepAE2Bridge: Field ALLOWED_CONNECTION_BLOCKS is null, Replication might not be fully initialized");
            }
            catch (Exception e) {
                System.out.println("RepAE2Bridge: Error during field access: " + e.getMessage());
            }
        }
        catch (NoClassDefFoundError e) {
            System.out.println("RepAE2Bridge: MatterPipeBlock class not found, Replication might not be loaded");
        }
        catch (Exception e) {
            System.out.println("RepAE2Bridge: Error during connectable block registration: " + e.getMessage());
        }
    }
}

