/*
 * Decompiled with CFR 0.152.
 */
package me.owdding.catharsis.utils.types.boundingboxes;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import me.owdding.catharsis.utils.types.boundingboxes.BoundingBox;
import me.owdding.catharsis.utils.types.boundingboxes.Branch;
import me.owdding.catharsis.utils.types.boundingboxes.DebugRenderable;
import me.owdding.catharsis.utils.types.boundingboxes.Leaf;
import me.owdding.catharsis.utils.types.boundingboxes.Node;
import me.owdding.catharsis.utils.types.boundingboxes.OctreeDebugRenderer;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import tech.thatgravyboat.skyblockapi.api.events.render.RenderWorldEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB%\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0012\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0014H\u0086\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b#\u0010$J*\u0010%\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b%\u0010&J\u001a\u0010)\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010'H\u00d6\u0003\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010+\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b+\u0010$R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010,\u001a\u0004\b-\u0010\"R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010.\u001a\u0004\b/\u0010$R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00063"}, d2={"Lme/owdding/catharsis/utils/types/boundingboxes/Octree;", "Lme/owdding/catharsis/utils/types/boundingboxes/DebugRenderable;", "", "Lme/owdding/catharsis/utils/types/boundingboxes/BoundingBox;", "boxes", "", "minSize", "<init>", "(Ljava/util/List;I)V", "", "([Lme/owdding/catharsis/utils/types/boundingboxes/BoundingBox;I)V", "", "toString", "()Ljava/lang/String;", "Lkotlin/Function2;", "Lme/owdding/catharsis/utils/types/boundingboxes/Node;", "", "visitor", "visitNode", "(Lkotlin/jvm/functions/Function2;)V", "Lnet/minecraft/class_2338;", "pos", "Lme/owdding/catharsis/utils/types/boundingboxes/Leaf;", "findLeaf", "(Lnet/minecraft/class_2338;)Lme/owdding/catharsis/utils/types/boundingboxes/Leaf;", "", "isInside", "(Lnet/minecraft/class_2338;)Z", "contains", "Ltech/thatgravyboat/skyblockapi/api/events/render/RenderWorldEvent;", "event", "render", "(Ltech/thatgravyboat/skyblockapi/api/events/render/RenderWorldEvent;)V", "component1", "()Ljava/util/List;", "component2", "()I", "copy", "(Ljava/util/List;I)Lme/owdding/catharsis/utils/types/boundingboxes/Octree;", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "Ljava/util/List;", "getBoxes", "I", "getMinSize", "Lme/owdding/catharsis/utils/types/boundingboxes/Branch;", "root", "Lme/owdding/catharsis/utils/types/boundingboxes/Branch;", "Catharsis-1.21.10"})
public final class Octree
implements DebugRenderable {
    @NotNull
    private final List<BoundingBox> boxes;
    private final int minSize;
    @NotNull
    private final Branch root;

    public Octree(@NotNull List<BoundingBox> boxes, int minSize) {
        Intrinsics.checkNotNullParameter(boxes, (String)"boxes");
        this.boxes = boxes;
        this.minSize = minSize;
        BoundingBox boundingBox = BoundingBox.Companion.encapsulatingBoxes((Iterable<BoundingBox>)this.boxes);
        Intrinsics.checkNotNull((Object)boundingBox);
        BoundingBox encapsulatingBox = boundingBox;
        Vector3i center = encapsulatingBox.getCenter();
        int span = Math.max(encapsulatingBox.getXSpan(), encapsulatingBox.getZSpan()) / 2 + 5;
        this.root = new Branch(new BoundingBox((Vector3ic)center).inflateBy(span), this.boxes, this.minSize);
    }

    @NotNull
    public final List<BoundingBox> getBoxes() {
        return this.boxes;
    }

    public final int getMinSize() {
        return this.minSize;
    }

    public Octree(@NotNull BoundingBox[] boxes, int minSize) {
        Intrinsics.checkNotNullParameter((Object)boxes, (String)"boxes");
        this(CollectionsKt.listOf((Object[])Arrays.copyOf(boxes, boxes.length)), minSize);
    }

    @NotNull
    public String toString() {
        return this.root.toString();
    }

    public final void visitNode(@NotNull Function2<? super Node, ? super Integer, Unit> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        this.root.visit(visitor, 0);
    }

    @Nullable
    public final Leaf findLeaf(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!this.root.getBox().contains((class_2382)pos)) {
            return null;
        }
        return this.root.getNode(pos);
    }

    public final boolean isInside(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Leaf leaf = this.findLeaf(pos);
        return leaf != null ? leaf.isInside(pos) : false;
    }

    public final boolean contains(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.isInside(pos);
    }

    @Override
    public void render(@NotNull RenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        OctreeDebugRenderer.INSTANCE.render(this, event);
    }

    @NotNull
    public final List<BoundingBox> component1() {
        return this.boxes;
    }

    public final int component2() {
        return this.minSize;
    }

    @NotNull
    public final Octree copy(@NotNull List<BoundingBox> boxes, int minSize) {
        Intrinsics.checkNotNullParameter(boxes, (String)"boxes");
        return new Octree(boxes, minSize);
    }

    public static /* synthetic */ Octree copy$default(Octree octree, List list, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = octree.boxes;
        }
        if ((n2 & 2) != 0) {
            n = octree.minSize;
        }
        return octree.copy(list, n);
    }

    public int hashCode() {
        int result = ((Object)this.boxes).hashCode();
        result = result * 31 + Integer.hashCode(this.minSize);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Octree)) {
            return false;
        }
        Octree octree = (Octree)other;
        if (!Intrinsics.areEqual(this.boxes, octree.boxes)) {
            return false;
        }
        return this.minSize == octree.minSize;
    }
}

