/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import uk.co.dotcode.lootevents.LootEvents;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class LootEventSystem {
    private static final HashMap<String, ArrayList<ItemStack>> players = new HashMap();
    private static final HashMap<String, ArrayList<ItemStack>> rewardsToClaim = new HashMap();
    private static final ArrayList<ItemEntity> eventItemEntities = new ArrayList();
    private static final Random RANDOM = new Random();
    private static int unclaimedRewardsNotificationTimer = 0;
    private static int timer = ConfigManager.CONFIG.eventDurationSeconds * 20;
    private static int eventCountdownTimer = ConfigManager.CONFIG.eventCountdownSeconds * 20;
    private static boolean eventPrepared = false;
    private static boolean eventStarted = false;
    private static boolean blockPickups = false;
    private static boolean eventCountdownComplete = false;
    private static Level targetWorld = null;
    public static final SuggestionProvider<CommandSourceStack> BLACKLIST_SUGGESTIONS = (context, builder) -> {
        for (String blacklistedItem : ConfigManager.CONFIG.blacklistedItems) {
            if (!blacklistedItem.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(blacklistedItem);
        }
        return builder.buildFuture();
    };

    public static void tick(MinecraftServer server) {
        if (!LootEventSystem.getRewardsToClaim().isEmpty() && ++unclaimedRewardsNotificationTimer % (20 * ConfigManager.CONFIG.unclaimedRewardsNotificationSeconds) == 0) {
            for (String uuid : LootEventSystem.getRewardsToClaim().keySet()) {
                server.getPlayerList().getPlayer(UUID.fromString(uuid)).sendSystemMessage((Component)CommandUtil.warningText("You have unclaimed event rewards! /cle claim"), false);
            }
            unclaimedRewardsNotificationTimer = 0;
        }
        if (LootEventSystem.isEventPrepared() && LootEventSystem.isEventStarted()) {
            if (eventCountdownTimer > 0) {
                if (eventCountdownTimer % 20 == 0) {
                    LootEventSystem.announceToPlayers(server, "COUNTDOWN: " + eventCountdownTimer / 20);
                }
                --eventCountdownTimer;
            } else if (!eventCountdownComplete) {
                LootEventSystem.announceToPlayers(server, "!!! GO !!!");
                eventCountdownComplete = true;
                blockPickups = true;
            } else if (timer > 0) {
                --timer;
                switch (ConfigManager.CONFIG.eventType) {
                    case "itemdrop": {
                        LootEventSystem.processItemDropEvent(server, (RegistryAccess)server.registryAccess());
                        break;
                    }
                }
                if (timer % 100 == 0) {
                    LootEventSystem.announceToPlayers(server, timer / 20 + " SECONDS REMAIN!");
                }
            } else {
                LootEventSystem.finishEvent(server);
            }
        }
    }

    private static void processItemDropEvent(MinecraftServer server, RegistryAccess registryAccess) {
        for (int i = 0; i < ConfigManager.CONFIG.lootFrequency; ++i) {
            int spawnX = ConfigManager.CONFIG.eventCenterPosition.getX() - ConfigManager.CONFIG.radius + RANDOM.nextInt(ConfigManager.CONFIG.radius * 2) + 1;
            int spawnY = ConfigManager.CONFIG.eventCenterPosition.getY();
            int spawnZ = ConfigManager.CONFIG.eventCenterPosition.getZ() - ConfigManager.CONFIG.radius + RANDOM.nextInt(ConfigManager.CONFIG.radius * 2) + 1;
            ItemEntity itemEntity = new ItemEntity(targetWorld, (double)spawnX, (double)spawnY, (double)spawnZ, LootEventSystem.getRandomItem(registryAccess));
            eventItemEntities.add(itemEntity);
            targetWorld.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void prepareEvent() {
        if (!eventStarted) {
            players.clear();
            eventPrepared = true;
            blockPickups = false;
        }
    }

    public static void startEvent(MinecraftServer server) {
        if (LootEventSystem.isEventPrepared() && !LootEventSystem.isEventStarted() && LootEventSystem.isEventReady().isEmpty()) {
            targetWorld = server.getLevel(LootEventSystem.getDimensionKey(ConfigManager.CONFIG.eventDimension));
            timer = ConfigManager.CONFIG.eventDurationSeconds * 20;
            eventCountdownTimer = ConfigManager.CONFIG.eventCountdownSeconds * 20;
            eventCountdownComplete = false;
            eventStarted = true;
            ServerLevel teleportDim = server.getLevel(LootEventSystem.getDimensionKey(ConfigManager.CONFIG.playerTeleportDimension));
            try {
                players.forEach((id, loot) -> Optional.ofNullable(server.getPlayerList().getPlayer(UUID.fromString(id))).ifPresentOrElse(player -> player.teleportTo(teleportDim, (double)ConfigManager.CONFIG.playerTeleportPosition.getX(), (double)ConfigManager.CONFIG.playerTeleportPosition.getY(), (double)ConfigManager.CONFIG.playerTeleportPosition.getZ(), Set.of(), 0.0f, 0.0f), () -> LootEvents.LOGGER.warn("Player with UUID {} is offline or does not exist", id)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetEvent() {
        players.clear();
        eventStarted = false;
        eventPrepared = false;
        eventCountdownComplete = false;
        blockPickups = false;
        for (ItemEntity e : eventItemEntities) {
            if (e == null || !e.isAlive()) continue;
            e.remove(Entity.RemovalReason.DISCARDED);
        }
        eventItemEntities.clear();
    }

    public static void finishEvent(MinecraftServer server) {
        LootEventSystem.announceToPlayers(server, "The event is over! Thanks for participating!");
        for (Map.Entry<String, ArrayList<ItemStack>> entry : players.entrySet()) {
            ArrayList<ItemStack> copiedList = new ArrayList<ItemStack>();
            for (ItemStack item : entry.getValue()) {
                copiedList.add(item.copy());
            }
            rewardsToClaim.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll(copiedList);
        }
        LootEventSystem.resetEvent();
    }

    public static ArrayList<String> isEventReady() {
        ArrayList<String> errors = new ArrayList<String>();
        if (LootEventSystem.isEventStarted()) {
            errors.add("Another Event Is Already Underway");
        }
        if (!LootEventSystem.isEventPrepared()) {
            errors.add("Event Not Prepared (/cle prepare)");
        }
        if (players.isEmpty()) {
            errors.add("No Players (/cle join)");
        }
        errors.addAll(ConfigManager.validate());
        return errors;
    }

    public static void addPlayer(Player player) {
        if (!LootEventSystem.getPlayers().containsKey(player.getStringUUID())) {
            players.put(player.getStringUUID(), new ArrayList());
        }
    }

    public static boolean addLoot(Player player, ItemStack loot) {
        if (players.containsKey(player.getStringUUID())) {
            if (players.get(player.getStringUUID()).size() < ConfigManager.CONFIG.lootStackLimit) {
                players.get(player.getStringUUID()).add(loot);
                return true;
            }
            return false;
        }
        return false;
    }

    public static void announceToPlayers(MinecraftServer server, String message) {
        for (String uuidString : players.keySet()) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                ServerPlayer player = server.getPlayerList().getPlayer(uuid);
                if (player == null) continue;
                player.sendSystemMessage((Component)CommandUtil.styledText(message, -11141121), false);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID in players map: " + uuidString);
            }
        }
    }

    public static boolean isEventPrepared() {
        return eventPrepared;
    }

    public static boolean isEventStarted() {
        return eventStarted;
    }

    public static boolean isItemEntityTracked(ItemEntity entity) {
        return eventItemEntities.contains(entity);
    }

    public static ArrayList<Component> getSignedUpPlayerNames(MinecraftServer server) {
        ArrayList<Component> names = new ArrayList<Component>();
        for (String uuidString : players.keySet()) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                ServerPlayer player = server.getPlayerList().getPlayer(uuid);
                if (player == null) continue;
                names.add(player.getDisplayName());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID in players map: " + uuidString);
            }
        }
        return names;
    }

    public static HashMap<String, ArrayList<ItemStack>> getPlayers() {
        return players;
    }

    public static float getRemainingTime() {
        return (float)(eventCountdownTimer + timer) / 20.0f;
    }

    public static boolean pickupsBlocked() {
        return blockPickups;
    }

    public static HashMap<String, ArrayList<ItemStack>> getRewardsToClaim() {
        return rewardsToClaim;
    }

    private static ResourceKey<Level> getDimensionKey(String dimensionString) {
        return switch (dimensionString.toLowerCase()) {
            case "overworld", "minecraft:overworld" -> {
                ResourceKey var3_3;
                yield var3_3 = Level.OVERWORLD;
            }
            case "nether", "the_nether", "minecraft:the_nether" -> {
                ResourceKey var3_4;
                yield var3_4 = Level.NETHER;
            }
            case "end", "the_end", "minecraft:the_end" -> {
                ResourceKey var3_5;
                yield var3_5 = Level.END;
            }
            default -> {
                try {
                    ResourceKey var3_6;
                    ResourceLocation id = ResourceLocation.tryParse((String)dimensionString);
                    yield var3_6 = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
                }
                catch (Exception e) {
                    Object var3_7 = null;
                    yield var3_7;
                }
            }
        };
    }

    public static ItemStack getRandomItem(RegistryAccess registryAccess) {
        ArrayList allItems = new ArrayList();
        Registry itemRegistry = registryAccess.registryOrThrow(Registries.ITEM);
        itemRegistry.stream().forEach(item -> {
            ResourceLocation id = itemRegistry.getKey(item);
            if (id != null && !ConfigManager.CONFIG.blacklistedItems.contains(id.toString())) {
                allItems.add(item);
            }
        });
        if (allItems.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item randomItem = (Item)allItems.get(RANDOM.nextInt(allItems.size()));
        int quantity = RANDOM.nextInt(ConfigManager.CONFIG.maximumStackSize) + 1;
        return new ItemStack((ItemLike)randomItem, Math.min(Math.min(quantity, ConfigManager.CONFIG.maximumStackSize), randomItem.getDefaultMaxStackSize()));
    }
}

