/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class AllUnclaimedRewardsCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> build() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"allUnclaimedRewards").requires(source -> source.hasPermission(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(AllUnclaimedRewardsCommand::execute);
    }

    public static int execute(CommandContext<CommandSourceStack> context) {
        if (LootEventSystem.getRewardsToClaim().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("There are no unclaimed rewards"));
            return 0;
        }
        for (Map.Entry<String, ArrayList<ItemStack>> entry : LootEventSystem.getRewardsToClaim().entrySet()) {
            Component username = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(UUID.fromString(entry.getKey())).getDisplayName();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Username: ").append(username), false);
            for (ItemStack stack : entry.getValue()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.warningText(stack.toString()), false);
            }
        }
        return 1;
    }
}

