/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class BlacklistedItemsCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> build(CommandBuildContext commandRegistryAccess) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blacklistedItems").requires(source -> source.hasPermission(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(BlacklistedItemsCommand::getBlacklistedItems)).then(Commands.literal((String)"get").executes(BlacklistedItemsCommand::getBlacklistedItems))).then(Commands.literal((String)"add").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)commandRegistryAccess)).executes(BlacklistedItemsCommand::addBlacklistedItem)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests(LootEventSystem.BLACKLIST_SUGGESTIONS).executes(BlacklistedItemsCommand::removeBlacklistedItem)));
    }

    public static int getBlacklistedItems(CommandContext<CommandSourceStack> context) {
        if (!ConfigManager.CONFIG.blacklistedItems.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.styledText("=== Blacklisted Items ===", -22016), false);
            for (String s : ConfigManager.CONFIG.blacklistedItems) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.warningText(s), false);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.styledText("=========================", -22016), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("There are no blacklisted items"));
        return 0;
    }

    public static int addBlacklistedItem(CommandContext<CommandSourceStack> context) {
        Item item = ItemArgument.getItem(context, (String)"item").getItem();
        RegistryAccess.Frozen registryAccess = ((CommandSourceStack)context.getSource()).getServer().registryAccess();
        ResourceLocation id = registryAccess.registryOrThrow(Registries.ITEM).getKey((Object)item);
        String blacklistAdd = id.toString();
        if (ConfigManager.CONFIG.blacklistedItems.contains(blacklistAdd)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("This item is already blacklisted: ").append((Component)CommandUtil.warningText(blacklistAdd)));
            return 0;
        }
        ConfigManager.CONFIG.blacklistedItems.add(blacklistAdd);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Added ").append((Component)CommandUtil.warningText(blacklistAdd)).append((Component)CommandUtil.successText(" to the blacklist")), false);
        ConfigManager.save();
        return 1;
    }

    public static int removeBlacklistedItem(CommandContext<CommandSourceStack> context) {
        String blacklistRemove = StringArgumentType.getString(context, (String)"item");
        if (!ConfigManager.CONFIG.blacklistedItems.contains(blacklistRemove)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("This item is not blacklisted: ").append((Component)CommandUtil.warningText(blacklistRemove)));
            return 0;
        }
        ConfigManager.CONFIG.blacklistedItems.removeIf(str -> str.equalsIgnoreCase(blacklistRemove));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Removed ").append((Component)CommandUtil.warningText(blacklistRemove)).append((Component)CommandUtil.successText(" from the blacklist")), false);
        ConfigManager.save();
        return 1;
    }
}

