/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class CancelCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> build() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"cancel").requires(source -> source.hasPermission(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(CancelCommand::execute);
    }

    public static int execute(CommandContext<CommandSourceStack> context) {
        if (LootEventSystem.isEventStarted() || LootEventSystem.isEventPrepared()) {
            LootEventSystem.resetEvent();
            CommandUtil.broadcastMessage(((CommandSourceStack)context.getSource()).getServer(), CommandUtil.getPrefix().append((Component)CommandUtil.failText("The event has been cancelled! Sorry everyone!")));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.warningText("Event has been cancelled, loot removed and the parameters have been wiped"), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("There is no event prepared or underway!"));
        return 0;
    }
}

