/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;

public class JoinCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> build() {
        return Commands.literal((String)"join").executes(JoinCommand::execute);
    }

    public static int execute(CommandContext<CommandSourceStack> context) {
        boolean isEventPrepared = LootEventSystem.isEventPrepared();
        boolean isEventStarted = LootEventSystem.isEventStarted();
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            if (!isEventPrepared && !isEventStarted) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.getPrefix().append((Component)CommandUtil.failText("There are no events underway!")), false);
                return 0;
            }
            if (isEventPrepared && isEventStarted) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.getPrefix().append((Component)CommandUtil.failText("You were too late! The event has already started.!")), false);
                return 0;
            }
            if (isEventPrepared && !isEventStarted) {
                if (!LootEventSystem.getPlayers().containsKey(((CommandSourceStack)context.getSource()).getPlayer().getStringUUID())) {
                    LootEventSystem.addPlayer((Player)((CommandSourceStack)context.getSource()).getPlayer());
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.getPrefix().append((Component)CommandUtil.successText("You have signed up for the event!")), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.getPrefix().append((Component)CommandUtil.failText("You are already signed up for the event!")));
                return 0;
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("This command can only be run by a player"));
            return 0;
        }
        return 0;
    }
}

