/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class PrepareCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> build() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"prepare").requires(source -> source.hasPermission(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).executes(PrepareCommand::execute);
    }

    public static int execute(CommandContext<CommandSourceStack> context) {
        if (LootEventSystem.isEventStarted()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot prepare an event as one is already underway."));
            return 0;
        }
        if (LootEventSystem.isEventPrepared()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.warningText("An event was already being prepared. It has been reset. You can now prepare your event."), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.warningText("Use the '/cle set' command to setup everything."), false);
            CommandUtil.broadcastMessage(((CommandSourceStack)context.getSource()).getServer(), CommandUtil.getPrefix().append((Component)CommandUtil.styledText("Event preparation is underway! Use /cle join to sign up for the event!", -11141121)));
            LootEventSystem.prepareEvent();
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Event preparation started!"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.warningText("Use the '/cle set' command to setup everything."), false);
        CommandUtil.broadcastMessage(((CommandSourceStack)context.getSource()).getServer(), CommandUtil.getPrefix().append((Component)CommandUtil.styledText("Event preparation is underway! Use /cle join to sign up for the event!", -11141121)));
        LootEventSystem.prepareEvent();
        return 1;
    }
}

