/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.lootevents.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import uk.co.dotcode.lootevents.LootEventSystem;
import uk.co.dotcode.lootevents.command.CommandUtil;
import uk.co.dotcode.lootevents.config.ConfigManager;

public class SetCommand {
    public static final SuggestionProvider<CommandSourceStack> EVENT_TYPE_SUGGESTIONS = (context, builder) -> {
        for (String eventType : ConfigManager.VALID_EVENT_TYPES) {
            if (!eventType.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
            builder.suggest(eventType);
        }
        return builder.buildFuture();
    };

    public static ArgumentBuilder<CommandSourceStack, ?> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.hasPermission(ConfigManager.CONFIG.adminPermissionLevel.intValue()))).then(Commands.literal((String)"announcerName").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(SetCommand::setAnnouncerName)))).then(Commands.literal((String)"adminPermissionLevel").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).executes(SetCommand::setAdminPermissionLevel)))).then(Commands.literal((String)"eventCountdownSeconds").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)3)).executes(SetCommand::setEventCountdownSeconds)))).then(Commands.literal((String)"eventDurationSeconds").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)5)).executes(SetCommand::setEventDurationSeconds)))).then(Commands.literal((String)"eventType").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).suggests(EVENT_TYPE_SUGGESTIONS).executes(SetCommand::setEventType)))).then(Commands.literal((String)"radius").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(SetCommand::setRadius)))).then(Commands.literal((String)"eventCenterPosition").executes(SetCommand::setEventCenterPosition))).then(Commands.literal((String)"playerTeleportPosition").executes(SetCommand::setTeleportPosition))).then(Commands.literal((String)"lootFrequency").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(SetCommand::setLootFrequency)))).then(Commands.literal((String)"lootStackLimit").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(SetCommand::setLootStackLimit)))).then(Commands.literal((String)"maximumStackSize").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(SetCommand::setMaximumStackSize)))).then(Commands.literal((String)"unclaimedRewardsNotificationSeconds").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)5)).executes(SetCommand::setNotificationSeconds)));
    }

    private static boolean checkCanModify() {
        return !LootEventSystem.isEventStarted();
    }

    private static int setAnnouncerName(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.announcerName = StringArgumentType.getString(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set announcer name to: " + ConfigManager.CONFIG.announcerName), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setAdminPermissionLevel(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.adminPermissionLevel = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set admin permission level to: " + ConfigManager.CONFIG.adminPermissionLevel), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventCountdownSeconds(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.eventCountdownSeconds = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set event countdown (seconds) to: " + ConfigManager.CONFIG.eventCountdownSeconds), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventDurationSeconds(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.eventDurationSeconds = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set event duration (seconds) to: " + ConfigManager.CONFIG.eventDurationSeconds), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventType(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            String eventType = StringArgumentType.getString(context, (String)"value");
            if (ConfigManager.VALID_EVENT_TYPES.contains(eventType)) {
                ConfigManager.CONFIG.eventType = eventType;
                ConfigManager.save();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set event type to: " + ConfigManager.CONFIG.eventType), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("'" + eventType + "' is not a valid event type. Valid options: " + String.join((CharSequence)", ", ConfigManager.VALID_EVENT_TYPES)));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setRadius(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.radius = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set radius to: " + ConfigManager.CONFIG.radius), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setEventCenterPosition(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            if (((CommandSourceStack)context.getSource()).isPlayer()) {
                ConfigManager.CONFIG.eventDimension = ((CommandSourceStack)context.getSource()).getPlayer().level().dimension().location().toString();
                ConfigManager.CONFIG.eventCenterPosition = ((CommandSourceStack)context.getSource()).getPlayer().blockPosition();
                ConfigManager.save();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set event center position to: " + ConfigManager.CONFIG.eventDimension + ", " + String.valueOf(ConfigManager.CONFIG.eventCenterPosition)), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("This command can only be run by a player"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setTeleportPosition(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            if (((CommandSourceStack)context.getSource()).isPlayer()) {
                ConfigManager.CONFIG.playerTeleportDimension = ((CommandSourceStack)context.getSource()).getPlayer().level().dimension().location().toString();
                ConfigManager.CONFIG.playerTeleportPosition = ((CommandSourceStack)context.getSource()).getPlayer().blockPosition();
                ConfigManager.save();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set teleport position to: " + ConfigManager.CONFIG.playerTeleportDimension + ", " + String.valueOf(ConfigManager.CONFIG.playerTeleportPosition)), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("This command can only be run by a player"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setLootFrequency(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.lootFrequency = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set loot frequency to: " + ConfigManager.CONFIG.lootFrequency), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setLootStackLimit(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.lootStackLimit = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set loot stack limit to: " + ConfigManager.CONFIG.lootStackLimit), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setMaximumStackSize(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.maximumStackSize = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set maximum stack size to: " + ConfigManager.CONFIG.maximumStackSize), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }

    private static int setNotificationSeconds(CommandContext<CommandSourceStack> context) {
        if (SetCommand.checkCanModify()) {
            ConfigManager.CONFIG.unclaimedRewardsNotificationSeconds = IntegerArgumentType.getInteger(context, (String)"value");
            ConfigManager.save();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtil.successText("Set unclaimed rewards notification (seconds) to: " + ConfigManager.CONFIG.unclaimedRewardsNotificationSeconds), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtil.failText("You cannot modify any settings because an event is underway"));
        return 0;
    }
}

